/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.basic_2;

import de.rtb.pcon.features.bonus.AppliedBonus;
import de.rtb.pcon.features.bonus.AppliedBonusKind;
import de.rtb.pcon.features.bonus.AppliedBonusRepository;
import de.rtb.pcon.features.bonus.AppliedBonusSource;
import de.rtb.pcon.features.bonus.BonusValue;
import de.rtb.pcon.features.bonus.basic_2.BonBasic2ConfigEntity;
import de.rtb.pcon.features.bonus.basic_2.BonBasic2ConfigRepository;
import de.rtb.pcon.features.bonus.basic_2.BonBasic2Service;
import de.rtb.pcon.features.bonus.basic_2.BonBasic2UiLcnInidvidualProperties;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.repositories.PaymentTransactionRepository;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
class BonBasic2Service {
    private static final Logger log = LoggerFactory.getLogger(BonBasic2Service.class);
    private final PaymentTransactionRepository paymentRepository;
    private final AppliedBonusRepository appliedBonusRepo;
    private final BonBasic2ConfigRepository bonusRepo;
    private static final DateTimeFormatter LOG_TIME_FMT = DateTimeFormatter.ofPattern("YYYY-MM-dd'T'HH:MMX");

    public BonBasic2Service(PaymentTransactionRepository paymentRepository, AppliedBonusRepository appliedBonusRepo, BonBasic2ConfigRepository bonusRepo) {
        this.paymentRepository = paymentRepository;
        this.appliedBonusRepo = appliedBonusRepo;
        this.bonusRepo = bonusRepo;
    }

    public BonBasic2ConfigEntity createDefaultBonus(Zone zone) {
        BonBasic2ConfigEntity bonus = new BonBasic2ConfigEntity();
        bonus.setEnabled(false);
        bonus.setDuration(Duration.ofMinutes(30L));
        bonus.setPrice(BigDecimal.ZERO);
        bonus.setGap(Duration.ofHours(4L));
        bonus.setZone(zone);
        return bonus;
    }

    @Transactional
    public Optional<BonusValue> findBonusValue(Pdm pdm, String lpn) {
        Optional<Object> result;
        Optional bonusConfigO = this.bonusRepo.findByZonePdmsAndEnabledTrue(pdm);
        if (bonusConfigO.isEmpty()) {
            return Optional.empty();
        }
        OffsetDateTime now = OffsetDateTime.now();
        Area area = pdm.getZone().getArea();
        BonBasic2ConfigEntity bonusConfig = (BonBasic2ConfigEntity)bonusConfigO.get();
        OffsetDateTime bonusPeriodStart = now.minus(bonusConfig.getGap());
        BonBasic2UiLcnInidvidualProperties.BonusMode bonusMode = bonusConfig.isStartOfPermitMode() ? BonBasic2UiLcnInidvidualProperties.BonusMode.PAYMENT : BonBasic2UiLcnInidvidualProperties.BonusMode.END_OF_VALIDITY;
        Optional<OffsetDateTime> lastBonusTs = switch (1.$SwitchMap$de$rtb$pcon$features$bonus$basic_2$BonBasic2UiLcnInidvidualProperties$BonusMode[bonusMode.ordinal()]) {
            default -> throw new MatchException(null, null);
            case 1 -> {
                PageRequest pageRequest = PageRequest.of((int)0, (int)1, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"id.pdmTime"}));
                Slice paymentSlice = this.paymentRepository.findInAreaWithLpn(area, lpn, bonusPeriodStart, now, (Pageable)pageRequest);
                yield paymentSlice.get().findFirst().map(p -> p.getId().getPdmTime());
            }
            case 2 -> {
                PageRequest pageRequest = PageRequest.of((int)0, (int)1, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"parkEndTime"}));
                OffsetDateTime startOfSearch = bonusPeriodStart.minusDays(bonusConfig.getMaxParkDays());
                Slice paymentSlice = this.paymentRepository.findInAreaWithLpn(area, lpn, startOfSearch, now, (Pageable)pageRequest);
                yield paymentSlice.get().findFirst().map(p -> p.getParkEndTime());
            }
        };
        if (lastBonusTs.isEmpty() || lastBonusTs.orElseThrow().isBefore(bonusPeriodStart)) {
            if (log.isDebugEnabled()) {
                String lastBonusTsStr = lastBonusTs.map(ts -> ts.format(LOG_TIME_FMT)).orElse("<not found>");
                String protTimeStart = bonusPeriodStart.format(LOG_TIME_FMT);
                String protTimeEnd = now.format(LOG_TIME_FMT);
                log.debug("Bonus (mode {}) for '{}' available. Last ticket {}, protected time span <{}, {}>", new Object[]{bonusMode, lpn, lastBonusTsStr, protTimeStart, protTimeEnd});
            }
            result = Optional.of(bonusConfig);
        } else {
            if (log.isDebugEnabled()) {
                OffsetDateTime lastBonusTs2 = lastBonusTs.orElseThrow().withOffsetSameInstant(now.getOffset());
                OffsetDateTime nextPossibleBousTs = lastBonusTs2.plus(bonusConfig.getGap());
                log.debug("Bonus (mode {}) for '{}' already used at {}. Next bonus will be given at {}.", new Object[]{bonusMode, lpn, lastBonusTs2, nextPossibleBousTs});
            }
            result = Optional.empty();
        }
        return result;
    }

    @Transactional
    public void recordLpnIndividualPeriod(PaymentTransaction payment) {
        Optional bonus = this.bonusRepo.findByZonePdmsAndEnabledTrue(payment.getId().getPdm());
        bonus.ifPresent(b -> this.recordLpnIndividualPeriod(payment, (BonusValue)b));
    }

    @Transactional
    public void recordLpnIndividualPeriod(PaymentTransaction payment, BonusValue bonusValue) {
        if (payment.getBonus() == null) {
            payment.setBonus(new LinkedList());
        }
        AppliedBonus bonus = new AppliedBonus();
        bonus.setPrice(bonusValue.getPrice());
        bonus.setDuration(bonusValue.getDuration());
        bonus.setKind(AppliedBonusKind.BASIC_2);
        bonus.setSource(AppliedBonusSource.SERVER);
        bonus.setPayment(payment);
        this.appliedBonusRepo.save((Object)bonus);
    }

    @Transactional(readOnly=true)
    public Optional<BonBasic2ConfigEntity> findByZone(Zone zone) {
        return this.bonusRepo.findByZone(zone);
    }

    @Transactional
    public BonBasic2ConfigEntity save(BonBasic2ConfigEntity bonus) {
        return (BonBasic2ConfigEntity)this.bonusRepo.save((Object)bonus);
    }
}

