/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.real_time_request;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.real_time_request.RealTimeRequestParameterException;
import de.rtb.pcon.core.services.pdm_in.MessageParserHelper;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.Pdm;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class RealTimeRequestExecutionContext {
    private PdmMessageDto globalContext;
    private Map<String, Object> localContext;
    private ObjectMapper pdmObjectMapper;

    public RealTimeRequestExecutionContext(PdmMessageDto globalContext, Map<String, Object> localContext, ObjectMapper pdmObjectMapper) {
        this.globalContext = globalContext;
        this.localContext = localContext;
        this.pdmObjectMapper = pdmObjectMapper;
    }

    public PdmMessageDto global() {
        return this.globalContext;
    }

    public <T> T mapLocalToObject(Class<T> cls) {
        return (T)this.pdmObjectMapper.convertValue((Object)this.localContext, cls);
    }

    public Optional<String> getLocalStringO(String mnemonic) {
        Object val = this.localContext.get(mnemonic);
        if (val == null) {
            return Optional.empty();
        }
        if (val instanceof String) {
            String str = (String)val;
            return Optional.of(str);
        }
        throw new RealTimeRequestParameterException("Value is expected to be String but was " + val.getClass().getName() + ".");
    }

    public String getLocalString(String mnemonic) {
        return (String)this.getLocalStringO(mnemonic).orElseThrow(() -> RealTimeRequestParameterException.ofValueIsNotAvailable((String)mnemonic));
    }

    public Optional<Integer> getLocalIntegerO(String mnemonic) {
        Object val = this.localContext.get(mnemonic);
        if (val == null) {
            return Optional.empty();
        }
        if (val instanceof Integer) {
            Integer intgr = (Integer)val;
            return Optional.of(intgr);
        }
        throw new RealTimeRequestParameterException("Value is expected to be Integer but was " + val.getClass().getName() + ".");
    }

    public int getLocalInteger(String mnemonic) {
        return (Integer)this.getLocalIntegerO(mnemonic).orElseThrow(() -> RealTimeRequestParameterException.ofValueIsNotAvailable((String)mnemonic));
    }

    public <T> Optional<T> getLocalObjectO(String mnemonic, Class<T> clazz) {
        Object val = this.localContext.get(mnemonic);
        if (val != null) {
            try {
                return Optional.of(this.pdmObjectMapper.convertValue(val, clazz));
            }
            catch (IllegalArgumentException e) {
                throw RealTimeRequestParameterException.ofClassNotConvertible((String)mnemonic, val, clazz, (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public <T> T getLocalObject(String mnemonic, Class<T> clazz) {
        return this.getLocalObjectO(mnemonic, clazz).orElseThrow(() -> RealTimeRequestParameterException.ofValueIsNotAvailable((String)mnemonic));
    }

    public <T> T getLocalObject(String mnemonic, TypeReference<T> typeReference) {
        Object val = this.localContext.get(mnemonic);
        if (val != null) {
            try {
                return (T)this.pdmObjectMapper.convertValue(val, typeReference);
            }
            catch (IllegalArgumentException e) {
                throw RealTimeRequestParameterException.ofClassNotConvertible((String)mnemonic, val, typeReference.getType().getClass(), (Throwable)e);
            }
        }
        throw RealTimeRequestParameterException.ofValueIsNotAvailable((String)mnemonic);
    }

    public <T> Optional<T> getLocalObjectO(String mnemonic, TypeReference<T> typeReference) {
        Object val = this.localContext.get(mnemonic);
        if (val != null) {
            try {
                return Optional.of(this.pdmObjectMapper.convertValue(val, typeReference));
            }
            catch (IllegalArgumentException e) {
                throw RealTimeRequestParameterException.ofClassNotConvertible((String)mnemonic, val, typeReference.getType().getClass(), (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public <T> T getLocalObject(Class<T> clazz) {
        try {
            return (T)this.pdmObjectMapper.convertValue((Object)this.localContext, clazz);
        }
        catch (IllegalArgumentException e) {
            String localContextStr = this.localContext.entrySet().stream().map(entry -> "[" + (String)entry.getKey() + "=" + String.valueOf(entry.getValue()) + "]").collect(Collectors.joining(","));
            throw RealTimeRequestParameterException.ofClassNotConvertible((String)"", (Object)localContextStr, clazz, (Throwable)e);
        }
    }

    public Object getLocalObject(String mnemonic) {
        return this.localContext.get(mnemonic);
    }

    public Pdm findPdmEntity() {
        return this.globalContext.getPdm();
    }

    public PaymentTransaction findPayment() {
        return this.globalContext.getPayment();
    }

    public BigDecimal getValue() {
        return this.globalContext.getBet();
    }

    public int getMonetaryScale() {
        return this.globalContext.getDpa();
    }

    public String getLicensePlate() {
        return Optional.ofNullable((String)this.localContext.get("LCN")).or(() -> Optional.ofNullable(this.globalContext.getLcn())).map(MessageParserHelper::parseLcn).orElse(null);
    }
}

