/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.look_up.payment_filters;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class PaymentFilterLookupDto {
    @JsonProperty(value="area")
    private Integer area;
    @JsonIgnore
    private Set<PaymentType> paymentTypes;
    @JsonIgnore
    private Set<PaymentReason> paymentReasons;
    @JsonProperty(value="tarifs")
    private Set<Integer> tariffIds;

    public PaymentFilterLookupDto() {
    }

    public PaymentFilterLookupDto(int area) {
        this.area = area;
        this.paymentTypes = new HashSet();
        this.paymentReasons = new HashSet();
        this.tariffIds = new HashSet();
    }

    @JsonGetter(value="pt")
    Set<Integer> getPaymentTypesJson() {
        if (this.paymentTypes == null) {
            return Set.of();
        }
        return this.paymentTypes.stream().map(PaymentType::getValue).collect(Collectors.toSet());
    }

    @JsonSetter(value="pt")
    void setPaymentTypesJson(Collection<Integer> paymentTypeValues) {
        if (CollectionUtils.isNotEmpty(paymentTypeValues)) {
            this.paymentTypes = paymentTypeValues.stream().map(PaymentType::fromValue).collect(Collectors.toSet());
        }
    }

    @JsonGetter(value="pr")
    Set<Integer> getPaymentReasonsJson() {
        if (this.paymentReasons == null) {
            return Set.of();
        }
        return this.paymentReasons.stream().map(PaymentReason::getValue).collect(Collectors.toSet());
    }

    @JsonSetter(value="pr")
    void setPaymentReasonsJson(Collection<Integer> paymentReasonsValues) {
        if (CollectionUtils.isNotEmpty(paymentReasonsValues)) {
            this.paymentReasons = paymentReasonsValues.stream().map(PaymentReason::fromValue).collect(Collectors.toSet());
        }
    }

    public Set<PaymentType> getPaymentTypes() {
        return this.paymentTypes;
    }

    public Integer getArea() {
        return this.area;
    }

    public void setArea(Integer area) {
        this.area = area;
    }

    public void setPaymentTypes(Set<PaymentType> paymentTypes) {
        this.paymentTypes = paymentTypes;
    }

    public Set<PaymentReason> getPaymentReasons() {
        return this.paymentReasons;
    }

    public void setPaymentReasons(Set<PaymentReason> paymentReasons) {
        this.paymentReasons = paymentReasons;
    }

    public Set<Integer> getTariffIds() {
        return this.tariffIds;
    }

    public void setTariffIds(Set<Integer> tariffIds) {
        this.tariffIds = tariffIds;
    }

    public String toString() {
        String sPaymentType = "null";
        if (this.paymentTypes != null) {
            sPaymentType = this.paymentTypes.stream().sorted().map(Enum::toString).collect(Collectors.joining(", "));
        }
        String sPaymentReasons = "null";
        if (this.paymentReasons != null) {
            sPaymentReasons = this.paymentReasons.stream().sorted().map(Enum::toString).collect(Collectors.joining(", "));
        }
        String sTariffs = null;
        if (this.tariffIds != null) {
            sTariffs = this.tariffIds.stream().map(Objects::toString).collect(Collectors.joining(", "));
        }
        return "PaymentFilterLookupDto [area=" + this.area + ", paymentTypes=[" + sPaymentType + "], paymentReasons=[" + sPaymentReasons + "], tariffIds=[" + sTariffs + "]]";
    }
}

