/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download.ui.plan;

import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.download.DownloadPlan;
import jakarta.persistence.criteria.Expression;
import java.io.Serializable;
import org.springframework.data.jpa.domain.Specification;

final class FirmwareUpdateSpecifications {
    private FirmwareUpdateSpecifications() {
    }

    public static Specification<DownloadPlan> hasArea(Area area) {
        return (Specification & Serializable)(root, query, builder) -> builder.equal((Expression)root.get("area"), (Object)area);
    }

    public static Specification<DownloadPlan> isVisible() {
        return (Specification & Serializable)(root, query, builder) -> builder.isTrue((Expression)root.get("visible"));
    }

    public static Specification<DownloadPlan> isHidden() {
        return (Specification & Serializable)(root, query, builder) -> builder.isFalse((Expression)root.get("visible"));
    }

    public static Specification<DownloadPlan> containsText(String text) {
        return (Specification & Serializable)(root, query, builder) -> builder.like(builder.lower((Expression)root.get("name")), "%" + text.toLowerCase() + "%");
    }
}

