/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.remote_data_acces;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import de.rtb.pcon.api.remote_data_acces.ExportedMoney;
import de.rtb.pcon.model.PaymentType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;

@Schema(name="CashBoxLevels", description="Cash box levels for one PDM.")
class ExpotedCashBoxLevels {
    @Schema(description="Type of cash box.")
    private PaymentType type;
    @Schema(description="Time stamp of last cash box clearing.")
    private LocalDateTime lastClearing;
    @Schema(description="Composition of money in the cash box.")
    @JacksonXmlElementWrapper(localName="levels")
    @JacksonXmlProperty(localName="level")
    private List<ExportedMoney> levels;

    protected ExpotedCashBoxLevels(PaymentType paymentType, LocalDateTime lastClearing) {
        this.type = paymentType;
        this.lastClearing = lastClearing;
        this.levels = new LinkedList();
    }

    @JsonProperty(value="type")
    public String getTypeJson() {
        return this.type != null ? this.type.name() : null;
    }

    public PaymentType getType() {
        return this.type;
    }

    public LocalDateTime getLastClearing() {
        return this.lastClearing;
    }

    public List<ExportedMoney> getLevels() {
        return this.levels;
    }
}

