/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.enforcement.v1.dao;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import de.rtb.pcon.model.zone.EnforcementMode;
import de.rtb.pcon.model.zone.Zone;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.function.Predicate;

@Schema(name="Zone", description="Enforcement zone")
@JacksonXmlRootElement(localName="zone")
public class EnfZoneDao {
    public static final Predicate<Zone> enforecmentEnabled = z -> z != null && EnforcementMode.DISABLED != z.getEnforcementMode();
    @Schema(description="Zone unique ID.")
    @JacksonXmlProperty(isAttribute=true)
    private Integer id;
    @Schema(description="Zone's name.")
    private String name;
    @Schema(description="User's description of the zone.")
    private String description;
    @Schema(description="User's preferred color of the zone.")
    private String color;
    @Schema(description="Enforcement mode applied here.")
    private int enfMode;

    public EnfZoneDao(Zone zone) {
        this.id = zone.getId();
        this.name = zone.getName();
        this.description = zone.getDescription();
        this.color = zone.getColor();
        this.enfMode = zone.getEnforcementMode() != null ? zone.getEnforcementMode().ordinal() : EnforcementMode.DISABLED.ordinal();
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getColor() {
        return this.color;
    }

    public int getEnfMode() {
        return this.enfMode;
    }
}

