--liquibase formatted sql
--changeset ales.holec:250228T1135 stripComments:false splitStatements:false

DROP FUNCTION IF EXISTS control.extendible_permits(integer, character varying, integer);

CREATE OR REPLACE FUNCTION control.extendible_permits(
	parareanr integer,
	parlpn character varying,
	parpsn integer)
    RETURNS TABLE(res_pay_date_time timestamp with time zone, res_pdm_id integer, res_pdm_number integer, res_pdm_name character varying, res_base_price numeric, res_exp_date_time timestamp with time zone, res_tariff_name character varying, res_base_permit_nr integer, res_tolerance_time integer, res_penalty_value numeric, res_parts integer, res_ext_price numeric, res_max_permits integer, res_max_duration integer, res_max_price numeric) 
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE PARALLEL UNSAFE
    ROWS 1000

AS $BODY$
DECLARE
	historyLimit TIMESTAMP WITH TIME ZONE;
BEGIN
	SELECT NOW() - INTERVAL '5 days' INTO historyLimit;

	RETURN QUERY
	WITH extension_candidates AS(
		SELECT
		pay_ts AS pay_time,
		payment.pdm_id as pdm_id,
		pdm_number AS seller_number,
		pdm_name AS seller_name,
		amount AS base_price,
		expiration_ts AS exp_time, 
		tai_name AS tariff_name,
		ticket_nr AS base_permit_nr,
		pex_tolerance_time AS tolerance_time, pex_penalty_value AS penalty_value,
		-- Count number of parts of already sold extensions.
		(SELECT COUNT (*) 
			FROM control.payment AS payment2 
			LEFT JOIN control.payment_ext ON payment_ext.ext_pay_ts = payment2.pay_ts AND payment_ext.ext_pdm_id = payment2.pdm_id
			WHERE payment_ext.base_pay_ts = payment.pay_ts AND payment_ext.base_pdm_id = payment.pdm_id AND pay_reason = 'PERMIT_EXTENSION'::control.payment_reason AND pay_ts > historyLimit 
		)::integer AS ext_parts,
		-- Count total amount spent on this ticket. Currency is not considered. Assuming that one town use only one currency.
		(SELECT COALESCE (SUM (amount), 0) 
			FROM control.payment AS payment2 
			LEFT JOIN control.payment_ext ON payment_ext.ext_pay_ts = payment2.pay_ts AND payment_ext.ext_pdm_id = payment2.pdm_id
			WHERE payment_ext.base_pay_ts = payment.pay_ts AND payment_ext.base_pdm_id = payment.pdm_id AND pay_reason = 'PERMIT_EXTENSION'::control.payment_reason AND pay_ts > historyLimit
		) AS ext_price,
		pex_max_permits AS max_permits,
		pex_max_duration AS max_duration,
		pex_max_price AS max_price
		FROM control.payment
			JOIN control.pdm on (payment.pdm_id = pdm.pdm_id)
			LEFT JOIN control.zone on (zon_id = pdm_zone_id)
			LEFT JOIN control.zone__perm_ext on pex_id = zon_id
			LEFT JOIN control.tariff_info on tai_id = tariff_info_id
		WHERE
			pex_enabled
			AND pay_ts > historyLimit
			AND pay_reason = 'PURCHASE'::control.payment_reason 
			AND zon_area_id = parAreaNr
			-- Choose LPN or PSN filleter based on what is NON NULL
			AND (
				((parLpn IS NOT NULL) AND (payment.lpn = parLpn))
				OR
				((parPsn IS NOT NULL) AND (payment.psn = parPsn))
			)
			AND (
				expiration_ts > NOW()
				OR
				expiration_ts > NOW() - CAST(GREATEST(pex_penalty_time, pex_tolerance_time) || 'minutes' AS interval)
			)
		ORDER BY expiration_ts DESC
	)
	SELECT DISTINCT ON (pay_time, pdm_id) * FROM extension_candidates
	WHERE
		ext_parts < max_permits
		AND
		(base_price + ext_price) < max_price
		AND
		(EXTRACT(epoch FROM (exp_time - pay_time)) / 60) < max_duration
	LIMIT 10;
END; 
$BODY$;

