--liquibase formatted sql
--changeset ales.holec:230704T1152

-- Create column for last contat from PDM as server time.
-- PDM somtimes send messages wiht delay.

-- First create a column
ALTER TABLE control.pdm_runtime ADD COLUMN last_contact timestamp with time zone;

-- Set last contact to greates value from list as initial value.
UPDATE control.pdm_runtime SET last_contact = GREATEST(kal_time, pay_time, sta_time, sys_time, clr_time);

-- Set start of century for PDM where no time in any column above. It should not happen. But be sure to not fail NON NULL constraint.
UPDATE control.pdm_runtime SET last_contact = '2000-01-01+00' WHERE last_contact IS NULL;

-- Set not null. Every PDM must have last contact time stamp.
ALTER TABLE control.pdm_runtime ALTER COLUMN last_contact SET NOT NULL;

COMMENT ON COLUMN control.pdm_runtime.last_contact  IS 'Time stamp of last row update, time from server. (Not from PDM as the other columns).';
