--liquibase formatted sql
--changeset ales.holec:220518T1636

-- Parking permit present on paking place.
CREATE TABLE control.bonus_gate_present
(
   id serial NOT NULL,
   ticket_number CHARACTER VARYING NOT NULL,
   arrival TIMESTAMP WITH TIME ZONE NOT NULL,
   valid_from TIMESTAMP WITH TIME ZONE NOT NULL,
   valid_to TIMESTAMP WITH TIME ZONE NOT NULL,
   type CHARACTER VARYING NOT NULL,
   data JSONB,
   zone_id INTEGER NOT NULL,
   CONSTRAINT pk_bonus_gate_present PRIMARY KEY (id),
   CONSTRAINT fk_bonus_gate_present__zone FOREIGN KEY (zone_id) REFERENCES control.zone (zon_id) MATCH SIMPLE ON UPDATE CASCADE ON DELETE CASCADE NOT VALID,
   CONSTRAINT uk_bonus_gate_present_ticket_number_and_zone UNIQUE (ticket_number, zone_id)
);

CREATE INDEX fki_bonus_gate_present__zone ON control.bonus_gate_present USING btree (zone_id ASC NULLS LAST);
COMMENT ON TABLE control.bonus_gate_present  IS 'Permits of vehicles present on parking place. It is cars which entered parking area and not left yet.';
