--liquibase formatted sql
--changeset ales.holec:220216T0000 stripComments:false splitStatements:false

-- Initialize empty database with default values.
-- Script is created from database dump of older version of PDM.control.

--
-- PostgreSQL database dump
--

-- Dumped from database version 14.1
-- Dumped by pg_dump version 14.1

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', 'public', false);
SET check_function_bodies = true;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 5 (class 2615 OID 31218)
-- Name: control; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA IF NOT EXISTS control;


--
-- TOC entry 1088 (class 1247 OID 29956)
-- Name: applied_bonus_kind; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.applied_bonus_kind AS ENUM (
    'BASIC_1',
    'BASIC_2'
);


--
-- TOC entry 1091 (class 1247 OID 29962)
-- Name: applied_bonus_origin; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.applied_bonus_origin AS ENUM (
    'NOT_USED',
    'TARIFF',
    'SPECIAL_CARD',
    'DEFAULT',
    'SERVER',
    'DEBT'
);


--
-- TOC entry 1094 (class 1247 OID 29976)
-- Name: area_service_type; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.area_service_type AS ENUM (
    'BRAIN_BEHIND',
    'FERATEL'
);


--
-- TOC entry 1097 (class 1247 OID 29982)
-- Name: bonus_card_tariff_mode; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.bonus_card_tariff_mode AS ENUM (
    'INDEX',
    'NAME'
);


--
-- TOC entry 1100 (class 1247 OID 29988)
-- Name: day_of_week; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.day_of_week AS ENUM (
    'MONDAY',
    'TUESDAY',
    'WEDNESDAY',
    'THURSDAY',
    'FRIDAY',
    'SATURDAY',
    'SUNDAY'
);


--
-- TOC entry 1103 (class 1247 OID 30004)
-- Name: device_part; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.device_part AS ENUM (
    'DEVICE',
    'CONFIG'
);


--
-- TOC entry 1106 (class 1247 OID 30010)
-- Name: device_type; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.device_type AS ENUM (
    'PDM_FW',
    'MODEM',
    'PRINTER',
    'CARD_READER',
    'COIN_SELECTOR',
    'PDM_CONFIG',
    'DISPLAY'
);


--
-- TOC entry 1109 (class 1247 OID 30026)
-- Name: download_status; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.download_status AS ENUM (
    'QUEUED',
    'IN_PROGRESS',
    'TRANSFERRED',
    'ACTIVATED',
    'TRANSFER_FAILED',
    'ACTIVATION_FAILED',
    'ABORTED',
    'OVERWRITTEN'
);


--
-- TOC entry 1112 (class 1247 OID 30044)
-- Name: download_target; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.download_target AS ENUM (
    'CONFIG',
    'PDM',
    'MODEM',
    'PRINTER_1',
    'PRINTER_2',
    'CARD_READER_1',
    'CARD_READER_2',
    'COIN_SELECTOR_FW',
    'COIN_SELECTOR_DATA',
    'BNA',
    'DISPLAY'
);


--
-- TOC entry 1115 (class 1247 OID 30068)
-- Name: network_type; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.network_type AS ENUM (
    'GPRS',
    'UMTS',
    'HSDPA',
    'HSUPA',
    'LTE',
    'LAN'
);


--
-- TOC entry 1118 (class 1247 OID 30082)
-- Name: payment_reason; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.payment_reason AS ENUM (
    'PURCHASE',
    'RECHARGING',
    'RTP_LOGON',
    'RECONCILIATION',
    'RTP_LOGOFF',
    'RTP_FORCED_LOGOFF',
    'RTP_EXTRINSIC_LOGOFF',
    'PAYMENT_FAILED',
    'PENALTY',
    'PERMIT_EXTENSION',
    'ZERO_TICKET',
    'JETON',
    'CANCEL',
    'RTP'
);


--
-- TOC entry 1121 (class 1247 OID 30112)
-- Name: payment_type; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.payment_type AS ENUM (
    'NONE',
    'COINS',
    'SLE',
    'GK',
    'RESIDENT',
    'MONEO',
    'QUICK',
    'MINI_CASH',
    'FAST_PAY',
    'PROTON',
    'BANK_CARD',
    'MPARK',
    'BANK_NOTES',
    'MIFARE',
    'MIFARE_LOGOFF',
    'MIFARE_EXP_LOGOFF',
    'MIFARE_X_LOGOFF',
    'MIFARE2',
    'VISA_INT',
    'VISA_NAT',
    'AMEX_INT',
    'AMEX_NAT',
    'MASTER_INT',
    'MASTER_NAT',
    'JCB_INT',
    'JCB_NAT',
    'DINERS_INT',
    'DINERS_NAT',
    'DEBIT_INT',
    'DEBIT_NAT',
    'CARD_0',
    'CARD_1',
    'CARD_2',
    'CARD_3',
    'CARD_4',
    'CARD_5',
    'CARD_6',
    'CARD_7',
    'MILLENNIUM_EPURSE',
    'MUENCHEN_KARTE',
    'OCIF',
    'OCIF1',
    'OCIF2',
    'OCIF3',
    'OCIF4',
    'OCIF5',
    'OCIF6',
    'OCIF7',
    'OCIF8',
    'OCIF9',
    'OCIF10',
    'MASTERCARD',
    'MAESTRO',
    'VISA',
    'GIROCARD',
    'AMEX',
    'VPAY',
    'DINERS',
    'EC_CARD',
    'EURO_ELV',
    'VISA_ELECTRON',
    'JCB',
    'GELD_CARD',
    'DKV',
    'DELTA',
    'SWITCH',
    'SOLO',
    'DISCOVER',
    'PAGO_BANKOMAT',
    'PEKA_POZNAN',
    'BRAIN_BEHIND',
    'BONUS_BEE',
    'SLO_URBANA',
    'SLO_VALU',
    'SLO_BA_MAESTRO',
    'SLO_VALU_MOBILE'
);


--
-- TOC entry 1124 (class 1247 OID 30266)
-- Name: permanent_cache_type; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.permanent_cache_type AS ENUM (
    'PAYMENT_FILTER',
    'STATUS_FILTER',
    'GDPR_EVICTION'
);


--
-- TOC entry 1127 (class 1247 OID 30272)
-- Name: status_message_alert; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.status_message_alert AS ENUM (
    'NONE',
    'INFO',
    'WARNING',
    'ERROR',
    'CRITICAL',
    'NEW'
);


--
-- TOC entry 1130 (class 1247 OID 30286)
-- Name: status_message_impact; Type: TYPE; Schema: control; Owner: -
--

CREATE TYPE control.status_message_impact AS ENUM (
    'NEGATIVE',
    'POSITIVE',
    'TRANSIENT'
);


--
-- TOC entry 324 (class 1255 OID 31219)
-- Name: add_default_message_config(integer, integer, control.status_message_alert, control.status_message_impact, boolean, boolean); Type: FUNCTION; Schema: control; Owner: -
--

CREATE FUNCTION control.add_default_message_config(in_msg_nr integer, in_solve_nr integer, in_alert_type control.status_message_alert, in_msg_impact control.status_message_impact, in_manual boolean DEFAULT false, in_important boolean DEFAULT false) RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
	-- Sanity checks
	IF in_msg_impact = 'NEGATIVE' AND in_solve_nr IS NULL THEN RAISE EXCEPTION 'Negative message has to define solve number.'; END IF;
	IF in_msg_impact IN ('POSITIVE', 'TRANSIENT') AND in_solve_nr IS NOT NULL THEN RAISE EXCEPTION 'Positive and transient message must not define solve number.'; END IF;
	IF in_manual IS NULL THEN RAISE EXCEPTION 'Manual mode must not be null'; END IF;
	IF in_important IS NULL THEN RAISE EXCEPTION 'Important mode must not be null'; END IF;
	IF in_msg_impact = 'POSITIVE' AND in_alert_type != 'NONE' IS NULL THEN RAISE EXCEPTION 'Alert type for positive messages has to be NONE'; END IF;

	-- Test solve message properties
	IF in_solve_nr IS NOT NULL
	THEN
		-- Test if referenced message exists
		IF (SELECT COUNT(*) FROM control.message_config_default WHERE mcd_number = in_solve_nr) = 0 THEN RAISE EXCEPTION 'Referenced positive message % does not exits.', in_solve_nr; END IF;
		-- Test if referenced message is really positive
		IF (SELECT mcd_impact FROM control.message_config_default WHERE mcd_number = in_solve_nr) != 'POSITIVE' THEN RAISE EXCEPTION 'Referenced positive message % is not positive.', in_solve_nr; END IF;
	END IF;

	INSERT INTO control.message_config_default(mcd_number, mcd_solve, mcd_alert, mcd_impact, mcd_manual, mcd_important)
	VALUES (in_msg_nr, in_solve_nr, in_alert_type, in_msg_impact, in_manual, in_important)
	ON CONFLICT (mcd_number)
	DO UPDATE SET mcd_solve = in_solve_nr, mcd_alert = in_alert_type, mcd_impact = in_msg_impact, mcd_manual = in_manual, mcd_important = in_important;
END;
$$;


--
-- TOC entry 323 (class 1255 OID 30294)
-- Name: extendible_permits(integer, character varying, integer); Type: FUNCTION; Schema: control; Owner: -
--

CREATE FUNCTION control.extendible_permits(areanr integer, lpn character varying, psn integer) RETURNS TABLE(res_id bigint, res_base_price numeric, res_pay_date_time timestamp without time zone, res_exp_date_time timestamp without time zone, res_tariff_name character varying, res_base_permit_nr integer, res_pdm_number integer, res_pdm_name character varying, res_tolerance_time integer, res_peanlty_value numeric, res_parts integer, res_ext_price numeric, res_max_permits integer, res_max_duration integer, res_max_price numeric)
    LANGUAGE plpgsql
    AS $$
DECLARE
  aTimeZone VARCHAR;
  historyLimit TIMESTAMP WITH TIME ZONE;
BEGIN
	SELECT ac_time_zone INTO aTimeZone FROM control.area WHERE ac_id = areaNr;
	EXECUTE 'SET LOCAL TIME ZONE ''' || aTimeZone || ''';' ;
	SELECT NOW() - INTERVAL '5 days' INTO historyLimit;

	RETURN QUERY
	WITH extension_candidates AS(
		SELECT
		tl_id AS id, tl_amount AS base_price, tl_pay_date_time::timestamp AS pay_time, tl_exp_date_time::timestamp AS exp_time, tai_name AS tariff_name, tl_ticket_no AS base_permit_nr, pdm_number AS seller_number, pdm_name AS seller_name,
		pex_tolerance_time AS tolerance_time, pex_peanlty_value AS peanlty_value,
		(SELECT COUNT (*)
		  FROM control.translog AS translog2
		  LEFT JOIN control.translog_ext ON translog_ext.permit_ext = translog2.tl_id
		  WHERE translog_ext.permit_base = translog.tl_id AND tl_pay_reason = 'PERMIT_EXTENSION'::control.payment_reason AND tl_pay_date_time > historyLimit
		)::integer AS ext_parts,
		(SELECT COALESCE (SUM (tl_amount), 0)
		  FROM control.translog AS translog2
		  LEFT JOIN control.translog_ext ON translog_ext.permit_ext = translog2.tl_id
		  WHERE control.translog_ext.permit_base = translog.tl_id AND tl_pay_reason = 'PERMIT_EXTENSION'::control.payment_reason AND tl_pay_date_time > historyLimit
		) AS ext_price,
		pex_max_permits AS max_permits, pex_max_duration AS max_duration, pex_max_price AS max_price
		FROM control.translog
			JOIN control.pdm on (tl_pdm_id = pdm_id)
			JOIN control.zone on (zon_id = pdm_zone_id)
			JOIN control.zone__perm_ext on pex_id = zon_id
			JOIN control.tariff_info on tai_id = tl_tariff_info_id
		WHERE
			pex_enabled
			AND tl_pay_date_time > historyLimit
			AND tl_pay_reason = 'PURCHASE'::control.payment_reason
			AND pdm_area_id = areaNr
			AND (
				((lpn IS NOT NULL) AND (tl_license_no = lpn))
				OR
				((psn IS NOT NULL) AND (tl_parking_space_no = psn))
			)
			AND (
				tl_exp_date_time > NOW()
				OR
				tl_exp_date_time > NOW() - CAST(GREATEST(pex_peanlty_time, pex_tolerance_time) || 'minutes' AS interval)
			)
		ORDER BY tl_exp_date_time DESC
	)
	SELECT DISTINCT ON (id) * FROM extension_candidates
	WHERE
		ext_parts < max_permits
		AND
		(base_price + ext_price) < max_price
		AND
		(EXTRACT(epoch FROM (exp_time - pay_time)) / 60) < max_duration
	LIMIT 10;
END;$$;


--
-- TOC entry 3943 (class 0 OID 0)
-- Dependencies: 323
-- Name: FUNCTION extendible_permits(areanr integer, lpn character varying, psn integer); Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON FUNCTION control.extendible_permits(areanr integer, lpn character varying, psn integer) IS 'List all extendible permits having provided lpn OR psn. Use null for not provided value. Both values can be provided simultaneously.';


SET default_table_access_method = heap;

--
-- TOC entry 210 (class 1259 OID 30297)
-- Name: accu_level; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.accu_level (
    al_id bigint NOT NULL,
    al_date_time timestamp with time zone NOT NULL,
    al_voltage_avg real NOT NULL,
    al_pdm_id integer NOT NULL,
    al_voltage_min real,
    al_mcs_sol real,
    al_sven_bat real,
    al_sven_in real
);


--
-- TOC entry 3944 (class 0 OID 0)
-- Dependencies: 210
-- Name: COLUMN accu_level.al_mcs_sol; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.accu_level.al_mcs_sol IS 'Charge from solar panel. MCS embedded measurement.';


--
-- TOC entry 3945 (class 0 OID 0)
-- Dependencies: 210
-- Name: COLUMN accu_level.al_sven_bat; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.accu_level.al_sven_bat IS 'Difference between changring and discharging. Counter on battery side of Sven''s measurement board.';


--
-- TOC entry 3946 (class 0 OID 0)
-- Dependencies: 210
-- Name: COLUMN accu_level.al_sven_in; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.accu_level.al_sven_in IS 'Charge from external power source. Counter on input side of Sven'' measurment board.';


--
-- TOC entry 211 (class 1259 OID 30300)
-- Name: accu_level_al_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.accu_level_al_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3947 (class 0 OID 0)
-- Dependencies: 211
-- Name: accu_level_al_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.accu_level_al_id_seq OWNED BY control.accu_level.al_id;


--
-- TOC entry 212 (class 1259 OID 30301)
-- Name: area; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.area (
    ac_id integer NOT NULL,
    ac_description character varying(255),
    ac_time_zone character varying(255)
);


--
-- TOC entry 213 (class 1259 OID 30306)
-- Name: area_partner; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.area_partner (
    id integer NOT NULL,
    area_id integer NOT NULL,
    cfg_type control.area_service_type NOT NULL,
    config jsonb
);


--
-- TOC entry 214 (class 1259 OID 30311)
-- Name: area_service_area_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.area_service_area_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3948 (class 0 OID 0)
-- Dependencies: 214
-- Name: area_service_area_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.area_service_area_id_seq OWNED BY control.area_partner.area_id;


--
-- TOC entry 215 (class 1259 OID 30312)
-- Name: area_service_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.area_service_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3949 (class 0 OID 0)
-- Dependencies: 215
-- Name: area_service_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.area_service_id_seq OWNED BY control.area_partner.id;


--
-- TOC entry 216 (class 1259 OID 30313)
-- Name: area_x_user; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.area_x_user (
    user_id integer NOT NULL,
    area_id integer NOT NULL
);


--
-- TOC entry 217 (class 1259 OID 30316)
-- Name: bonus_lpn_basic1_config; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.bonus_lpn_basic1_config (
    id integer NOT NULL,
    title character varying,
    description character varying,
    color character varying,
    b_max_emit integer DEFAULT 1 NOT NULL,
    enabled boolean DEFAULT true NOT NULL
);


--
-- TOC entry 3950 (class 0 OID 0)
-- Dependencies: 217
-- Name: COLUMN bonus_lpn_basic1_config.id; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.bonus_lpn_basic1_config.id IS 'One to one relation to zone.';


--
-- TOC entry 3951 (class 0 OID 0)
-- Dependencies: 217
-- Name: COLUMN bonus_lpn_basic1_config.b_max_emit; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.bonus_lpn_basic1_config.b_max_emit IS 'The maximal count of bonusses issued within one time period.';


--
-- TOC entry 218 (class 1259 OID 30323)
-- Name: bonus_bon_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.bonus_bon_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3952 (class 0 OID 0)
-- Dependencies: 218
-- Name: bonus_bon_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.bonus_bon_id_seq OWNED BY control.bonus_lpn_basic1_config.id;


--
-- TOC entry 219 (class 1259 OID 30324)
-- Name: static_bonus_definition_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.static_bonus_definition_id_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE -2147483648
    MAXVALUE 2147483647
    CACHE 1
    CYCLE;


--
-- TOC entry 220 (class 1259 OID 30325)
-- Name: bonus_card_rule; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.bonus_card_rule (
    sbd_id integer DEFAULT nextval('control.static_bonus_definition_id_seq'::regclass) NOT NULL,
    sbd_card_nr character varying NOT NULL,
    sbd_type_id integer NOT NULL,
    sbd_tariff character varying
);


--
-- TOC entry 221 (class 1259 OID 30331)
-- Name: bonus_card_type; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.bonus_card_type (
    sbt_id integer NOT NULL,
    sbt_key character varying,
    sbt_description character varying,
    sbt_zone_id integer,
    sbt_tariff_mode control.bonus_card_tariff_mode NOT NULL
);


--
-- TOC entry 222 (class 1259 OID 30336)
-- Name: bonus_counting_rule; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.bonus_counting_rule (
    id integer NOT NULL,
    name character varying NOT NULL,
    max_value integer NOT NULL,
    zone_id integer NOT NULL
);


--
-- TOC entry 223 (class 1259 OID 30341)
-- Name: bonus_counting_rule_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.bonus_counting_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3953 (class 0 OID 0)
-- Dependencies: 223
-- Name: bonus_counting_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.bonus_counting_rule_id_seq OWNED BY control.bonus_counting_rule.id;


--
-- TOC entry 224 (class 1259 OID 30342)
-- Name: bonus_counting_usage; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.bonus_counting_usage (
    id integer NOT NULL,
    config_id integer NOT NULL,
    current_value integer NOT NULL,
    day date NOT NULL
);


--
-- TOC entry 225 (class 1259 OID 30345)
-- Name: bonus_counting_usage_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.bonus_counting_usage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3954 (class 0 OID 0)
-- Dependencies: 225
-- Name: bonus_counting_usage_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.bonus_counting_usage_id_seq OWNED BY control.bonus_counting_usage.id;


--
-- TOC entry 226 (class 1259 OID 30346)
-- Name: bonus_disposable; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.bonus_disposable (
    id integer NOT NULL,
    code character varying NOT NULL,
    duration integer,
    discount numeric(8,2),
    valid_from timestamp with time zone,
    valid_to timestamp with time zone,
    payment_id bigint,
    creator_id integer NOT NULL,
    created timestamp with time zone NOT NULL,
    zone_id integer NOT NULL,
    tariff_name character varying
);


--
-- TOC entry 227 (class 1259 OID 30351)
-- Name: bonus_disposable_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.bonus_disposable_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3955 (class 0 OID 0)
-- Dependencies: 227
-- Name: bonus_disposable_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.bonus_disposable_id_seq OWNED BY control.bonus_disposable.id;


--
-- TOC entry 228 (class 1259 OID 30352)
-- Name: bonus_lpn_basic1_exception; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.bonus_lpn_basic1_exception (
    id integer NOT NULL,
    lpn character varying NOT NULL,
    b_time integer NOT NULL,
    bonus_id integer NOT NULL
);


--
-- TOC entry 229 (class 1259 OID 30357)
-- Name: bonus_exception_boe_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.bonus_exception_boe_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3956 (class 0 OID 0)
-- Dependencies: 229
-- Name: bonus_exception_boe_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.bonus_exception_boe_id_seq OWNED BY control.bonus_lpn_basic1_exception.id;


--
-- TOC entry 230 (class 1259 OID 30358)
-- Name: bonus_lpn_basic1_rule; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.bonus_lpn_basic1_rule (
    id integer NOT NULL,
    b_duration integer,
    b_amount numeric,
    bonus_id integer NOT NULL,
    renew_cron character varying DEFAULT '0 0 0 ? * * *'::character varying NOT NULL
);


--
-- TOC entry 231 (class 1259 OID 30364)
-- Name: bonus_lpn_basic2_config; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.bonus_lpn_basic2_config (
    id integer NOT NULL,
    enabled boolean DEFAULT false NOT NULL,
    gap integer NOT NULL,
    b_duration integer,
    b_price numeric(8,2)
);


--
-- TOC entry 3957 (class 0 OID 0)
-- Dependencies: 231
-- Name: COLUMN bonus_lpn_basic2_config.id; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.bonus_lpn_basic2_config.id IS 'One to one relation to zone.';


--
-- TOC entry 232 (class 1259 OID 30368)
-- Name: bonus_lpn_individual_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.bonus_lpn_individual_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3958 (class 0 OID 0)
-- Dependencies: 232
-- Name: bonus_lpn_individual_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.bonus_lpn_individual_id_seq OWNED BY control.bonus_lpn_basic2_config.id;


--
-- TOC entry 233 (class 1259 OID 30369)
-- Name: bonus_lpn_mt1_rule; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.bonus_lpn_mt1_rule (
    id integer NOT NULL,
    lpn character varying NOT NULL,
    tariff_info_id integer NOT NULL,
    zone_id integer NOT NULL
);


--
-- TOC entry 3959 (class 0 OID 0)
-- Dependencies: 233
-- Name: TABLE bonus_lpn_mt1_rule; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON TABLE control.bonus_lpn_mt1_rule IS 'Entries for multi-tariff bonus.';


--
-- TOC entry 234 (class 1259 OID 30374)
-- Name: bonus_lpn_mt2_rule; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.bonus_lpn_mt2_rule (
    id integer NOT NULL,
    lpn character varying(255) NOT NULL,
    valid_from timestamp with time zone NOT NULL,
    valid_to timestamp with time zone NOT NULL,
    tariff_name character varying(255) NOT NULL,
    zone_id integer NOT NULL,
    expiry_tolerance integer NOT NULL
);


--
-- TOC entry 3960 (class 0 OID 0)
-- Dependencies: 234
-- Name: COLUMN bonus_lpn_mt2_rule.valid_to; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.bonus_lpn_mt2_rule.valid_to IS 'Bonus becomes invalid from this date on.';


--
-- TOC entry 235 (class 1259 OID 30379)
-- Name: bonus_lpn_mt2_rule_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.bonus_lpn_mt2_rule_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3961 (class 0 OID 0)
-- Dependencies: 235
-- Name: bonus_lpn_mt2_rule_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.bonus_lpn_mt2_rule_id_seq OWNED BY control.bonus_lpn_mt2_rule.id;


--
-- TOC entry 236 (class 1259 OID 30380)
-- Name: bonus_lpn_mt2_usage; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.bonus_lpn_mt2_usage (
    id integer NOT NULL,
    lpn character varying(255) NOT NULL,
    used timestamp with time zone NOT NULL,
    pdm_id integer NOT NULL
);


--
-- TOC entry 3962 (class 0 OID 0)
-- Dependencies: 236
-- Name: TABLE bonus_lpn_mt2_usage; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON TABLE control.bonus_lpn_mt2_usage IS 'Bonus usage history.';


--
-- TOC entry 3963 (class 0 OID 0)
-- Dependencies: 236
-- Name: COLUMN bonus_lpn_mt2_usage.used; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.bonus_lpn_mt2_usage.used IS 'Time reported by PDM.';


--
-- TOC entry 237 (class 1259 OID 30383)
-- Name: bonus_lpn_mt2_usage_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.bonus_lpn_mt2_usage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3964 (class 0 OID 0)
-- Dependencies: 237
-- Name: bonus_lpn_mt2_usage_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.bonus_lpn_mt2_usage_id_seq OWNED BY control.bonus_lpn_mt2_usage.id;


--
-- TOC entry 238 (class 1259 OID 30384)
-- Name: bonus_mt_entry_bmte_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.bonus_mt_entry_bmte_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3965 (class 0 OID 0)
-- Dependencies: 238
-- Name: bonus_mt_entry_bmte_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.bonus_mt_entry_bmte_id_seq OWNED BY control.bonus_lpn_mt1_rule.id;


--
-- TOC entry 239 (class 1259 OID 30385)
-- Name: bonus_psn_mt1_rule; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.bonus_psn_mt1_rule (
    id integer NOT NULL,
    psn integer NOT NULL,
    tariff_info_id integer NOT NULL,
    zone_id integer NOT NULL
);


--
-- TOC entry 240 (class 1259 OID 30388)
-- Name: bonus_psn_mt_entry_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.bonus_psn_mt_entry_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3966 (class 0 OID 0)
-- Dependencies: 240
-- Name: bonus_psn_mt_entry_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.bonus_psn_mt_entry_id_seq OWNED BY control.bonus_psn_mt1_rule.id;


--
-- TOC entry 241 (class 1259 OID 30389)
-- Name: bonus_rule_bor_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.bonus_rule_bor_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3967 (class 0 OID 0)
-- Dependencies: 241
-- Name: bonus_rule_bor_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.bonus_rule_bor_id_seq OWNED BY control.bonus_lpn_basic1_rule.id;


--
-- TOC entry 242 (class 1259 OID 30390)
-- Name: cash_box_level; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.cash_box_level (
    id integer NOT NULL,
    pdm_id integer NOT NULL,
    cash_box_level numeric(10,2),
    currency character varying(3) NOT NULL,
    payment_type control.payment_type NOT NULL,
    last_clearing timestamp with time zone
);


--
-- TOC entry 3968 (class 0 OID 0)
-- Dependencies: 242
-- Name: TABLE cash_box_level; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON TABLE control.cash_box_level IS 'Table contains cash box level as it is incrementally build. It is save to truncate this table but be aware that cash box level will be incorrect until clearing is performed.';


--
-- TOC entry 3969 (class 0 OID 0)
-- Dependencies: 242
-- Name: COLUMN cash_box_level.cash_box_level; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.cash_box_level.cash_box_level IS 'Amount of money since last clearing. Null means that there are no pyaments yet.';


--
-- TOC entry 243 (class 1259 OID 30393)
-- Name: cache_cash_box_level_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.cache_cash_box_level_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3970 (class 0 OID 0)
-- Dependencies: 243
-- Name: cache_cash_box_level_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.cache_cash_box_level_id_seq OWNED BY control.cash_box_level.id;


--
-- TOC entry 244 (class 1259 OID 30394)
-- Name: cache_permanent; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.cache_permanent (
    id integer NOT NULL,
    type control.permanent_cache_type NOT NULL,
    value jsonb NOT NULL,
    last_id bigint
);


--
-- TOC entry 245 (class 1259 OID 30399)
-- Name: cache_permanent_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.cache_permanent_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3971 (class 0 OID 0)
-- Dependencies: 245
-- Name: cache_permanent_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.cache_permanent_id_seq OWNED BY control.cache_permanent.id;


--
-- TOC entry 246 (class 1259 OID 30400)
-- Name: cash_box_item; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.cash_box_item (
    cbi_id bigint NOT NULL,
    cbi_count integer NOT NULL,
    cbi_cash_kind_id bigint,
    cbi_clearing_id bigint
);


--
-- TOC entry 247 (class 1259 OID 30403)
-- Name: cash_box_item_cbi_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.cash_box_item_cbi_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3972 (class 0 OID 0)
-- Dependencies: 247
-- Name: cash_box_item_cbi_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.cash_box_item_cbi_id_seq OWNED BY control.cash_box_item.cbi_id;


--
-- TOC entry 248 (class 1259 OID 30404)
-- Name: cash_kind; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.cash_kind (
    csk_id bigint NOT NULL,
    csk_code character varying(3) NOT NULL,
    csk_value numeric(8,2) NOT NULL
);


--
-- TOC entry 249 (class 1259 OID 30407)
-- Name: cash_kind_csk_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.cash_kind_csk_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3973 (class 0 OID 0)
-- Dependencies: 249
-- Name: cash_kind_csk_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.cash_kind_csk_id_seq OWNED BY control.cash_kind.csk_id;


--
-- TOC entry 250 (class 1259 OID 30408)
-- Name: clearing; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.clearing (
    clr_id bigint NOT NULL,
    clr_date_pdm timestamp with time zone NOT NULL,
    clr_date_pc timestamp with time zone NOT NULL,
    clr_currency character varying(3) NOT NULL,
    clr_clearing_nr integer,
    clr_asn integer,
    clr_tracer integer NOT NULL,
    clr_pay_type control.payment_type,
    clr_value numeric(10,2),
    clr_value_lifelong numeric(12,2),
    clr_recharge numeric(10,2),
    clr_tickets integer,
    clr_account_name character varying(255),
    clr_pdm_id integer NOT NULL,
    clr_class_type integer NOT NULL
);


--
-- TOC entry 251 (class 1259 OID 30411)
-- Name: clearing_clr_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.clearing_clr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3974 (class 0 OID 0)
-- Dependencies: 251
-- Name: clearing_clr_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.clearing_clr_id_seq OWNED BY control.clearing.clr_id;


--
-- TOC entry 252 (class 1259 OID 30412)
-- Name: component_history_cmp_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.component_history_cmp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 255 (class 1259 OID 30421)
-- Name: download_entry; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.download_entry (
    dwe_id integer NOT NULL,
    dwe_status control.download_status,
    dwe_file_activation_msg_id bigint,
    dwe_file_download_msg_id bigint,
    dwe_plan_id integer NOT NULL,
    dwe_pdm_id integer NOT NULL,
    dwe_path character varying
);


--
-- TOC entry 256 (class 1259 OID 30426)
-- Name: download_entry_dwe_id_seq1; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.download_entry_dwe_id_seq1
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3975 (class 0 OID 0)
-- Dependencies: 256
-- Name: download_entry_dwe_id_seq1; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.download_entry_dwe_id_seq1 OWNED BY control.download_entry.dwe_id;


--
-- TOC entry 257 (class 1259 OID 30427)
-- Name: download_plan; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.download_plan (
    dwp_id integer NOT NULL,
    dwp_activation_date date NOT NULL,
    dwp_upload_date_time timestamp with time zone NOT NULL,
    dwp_target control.download_target NOT NULL,
    dwp_enabled boolean DEFAULT true NOT NULL,
    dwp_name character varying(255),
    dwp_note character varying(255),
    dwp_area_id integer NOT NULL,
    dwp_sw_desc_id integer NOT NULL,
    dwp_visible boolean DEFAULT true NOT NULL,
    dwp_modified_by integer,
    dwp_modified_at timestamp with time zone
);


--
-- TOC entry 3976 (class 0 OID 0)
-- Dependencies: 257
-- Name: COLUMN download_plan.dwp_modified_by; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.download_plan.dwp_modified_by IS 'User who edited this plan as last one.';


--
-- TOC entry 3977 (class 0 OID 0)
-- Dependencies: 257
-- Name: COLUMN download_plan.dwp_modified_at; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.download_plan.dwp_modified_at IS 'Timestamp of last edit of this plan.';


--
-- TOC entry 258 (class 1259 OID 30434)
-- Name: download_plan_dwp_id_seq1; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.download_plan_dwp_id_seq1
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3978 (class 0 OID 0)
-- Dependencies: 258
-- Name: download_plan_dwp_id_seq1; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.download_plan_dwp_id_seq1 OWNED BY control.download_plan.dwp_id;


--
-- TOC entry 259 (class 1259 OID 30435)
-- Name: forwarding_rule; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.forwarding_rule (
    fwr_id integer NOT NULL,
    fwr_name character varying(255),
    fwr_receiver character varying(255),
    fwr_is_active boolean NOT NULL,
    fwr_area_id integer NOT NULL,
    fwr_user_id integer NOT NULL,
    fwr_locale character varying DEFAULT 'en'::character varying,
    fwr_msg_numbers integer[],
    fwr_pdm_numbers integer[],
    fwr_alert_types control.status_message_alert[],
    fwr_days_of_week control.day_of_week[],
    fwr_time_start time without time zone NOT NULL,
    fwr_time_end time without time zone NOT NULL
);


--
-- TOC entry 260 (class 1259 OID 30441)
-- Name: forwarding_rule_fwr_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.forwarding_rule_fwr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3979 (class 0 OID 0)
-- Dependencies: 260
-- Name: forwarding_rule_fwr_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.forwarding_rule_fwr_id_seq OWNED BY control.forwarding_rule.fwr_id;


--
-- TOC entry 261 (class 1259 OID 30442)
-- Name: hw_device; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.hw_device (
    id integer NOT NULL,
    pdm_id integer NOT NULL,
    device_name character varying NOT NULL,
    target control.download_target,
    part control.device_part NOT NULL,
    part_model character varying,
    part_version character varying,
    part_sn character varying,
    properties jsonb,
    allow_update boolean DEFAULT true NOT NULL,
    received timestamp with time zone NOT NULL
);


--
-- TOC entry 262 (class 1259 OID 30448)
-- Name: hw_device_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.hw_device_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3980 (class 0 OID 0)
-- Dependencies: 262
-- Name: hw_device_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.hw_device_id_seq OWNED BY control.hw_device.id;


--
-- TOC entry 263 (class 1259 OID 30449)
-- Name: hw_status; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.hw_status (
    hwr_id integer NOT NULL,
    hwr_pdm integer NOT NULL,
    hwr_status jsonb
);


--
-- TOC entry 264 (class 1259 OID 30454)
-- Name: hw_status_hwr_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.hw_status_hwr_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3981 (class 0 OID 0)
-- Dependencies: 264
-- Name: hw_status_hwr_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.hw_status_hwr_id_seq OWNED BY control.hw_status.hwr_id;


--
-- TOC entry 265 (class 1259 OID 30455)
-- Name: logbook; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.logbook (
    log_id bigint NOT NULL,
    log_tracer integer,
    log_date_pdm timestamp with time zone,
    log_date_pc timestamp with time zone NOT NULL,
    log_pdm_id integer,
    log_reason character varying,
    log_msg_nr smallint NOT NULL
);


--
-- TOC entry 266 (class 1259 OID 30460)
-- Name: logbook_log_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.logbook_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3982 (class 0 OID 0)
-- Dependencies: 266
-- Name: logbook_log_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.logbook_log_id_seq OWNED BY control.logbook.log_id;


--
-- TOC entry 267 (class 1259 OID 30461)
-- Name: message_config_default; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.message_config_default (
    mcd_number smallint NOT NULL,
    mcd_solve smallint,
    mcd_alert control.status_message_alert NOT NULL,
    mcd_impact control.status_message_impact NOT NULL,
    mcd_manual boolean NOT NULL,
    mcd_important boolean NOT NULL
);


--
-- TOC entry 3983 (class 0 OID 0)
-- Dependencies: 267
-- Name: TABLE message_config_default; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON TABLE control.message_config_default IS 'Default configuration of status messages valid for the whole application.
Do not change anything here unless you are very sure.';


--
-- TOC entry 268 (class 1259 OID 30464)
-- Name: message_config_user; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.message_config_user (
    msu_id integer NOT NULL,
    msu_message_number smallint NOT NULL,
    msu_manual_clearing boolean DEFAULT false NOT NULL,
    msu_area_id integer NOT NULL
);


--
-- TOC entry 3984 (class 0 OID 0)
-- Dependencies: 268
-- Name: COLUMN message_config_user.msu_manual_clearing; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.message_config_user.msu_manual_clearing IS 'Indicates that user has to confirm this message manually.';


--
-- TOC entry 269 (class 1259 OID 30468)
-- Name: message_config_msc_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.message_config_msc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3985 (class 0 OID 0)
-- Dependencies: 269
-- Name: message_config_msc_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.message_config_msc_id_seq OWNED BY control.message_config_user.msu_id;


--
-- TOC entry 270 (class 1259 OID 30469)
-- Name: modem_login; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.modem_login (
    mlg_id integer NOT NULL,
    mlg_pdm_id integer NOT NULL,
    mlg_pdm_time timestamp with time zone NOT NULL,
    mlg_signal smallint NOT NULL,
    mlg_net_type control.network_type NOT NULL
);


--
-- TOC entry 271 (class 1259 OID 30472)
-- Name: modem_login_mlg_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.modem_login_mlg_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3986 (class 0 OID 0)
-- Dependencies: 271
-- Name: modem_login_mlg_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.modem_login_mlg_id_seq OWNED BY control.modem_login.mlg_id;


--
-- TOC entry 272 (class 1259 OID 30473)
-- Name: paper_role; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.paper_role (
    id integer NOT NULL,
    pdm_id integer NOT NULL,
    time_in timestamp with time zone NOT NULL,
    time_out timestamp with time zone,
    length real NOT NULL,
    used real NOT NULL,
    tickets integer NOT NULL
);


--
-- TOC entry 273 (class 1259 OID 30476)
-- Name: paper_role_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.paper_role_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3987 (class 0 OID 0)
-- Dependencies: 273
-- Name: paper_role_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.paper_role_id_seq OWNED BY control.paper_role.id;


--
-- TOC entry 274 (class 1259 OID 30477)
-- Name: paper_usage; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.paper_usage (
    id integer NOT NULL,
    pdm_id integer NOT NULL,
    period timestamp with time zone NOT NULL,
    used real NOT NULL
);


--
-- TOC entry 275 (class 1259 OID 30480)
-- Name: paper_usage_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.paper_usage_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3988 (class 0 OID 0)
-- Dependencies: 275
-- Name: paper_usage_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.paper_usage_id_seq OWNED BY control.paper_usage.id;


--
-- TOC entry 276 (class 1259 OID 30481)
-- Name: pdm; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.pdm (
    pdm_id integer NOT NULL,
    pdm_number integer,
    pdm_name character varying(255),
    pdm_area_id integer NOT NULL,
    pdm_phone_number character varying(255),
    pdm_lat double precision,
    pdm_lon double precision,
    pdm_zone_id integer
);


--
-- TOC entry 277 (class 1259 OID 30486)
-- Name: pdm_log_catalog; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.pdm_log_catalog (
    id smallint NOT NULL,
    title character varying NOT NULL
);


--
-- TOC entry 278 (class 1259 OID 30491)
-- Name: pdm_log_catalog_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.pdm_log_catalog_id_seq
    AS smallint
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3989 (class 0 OID 0)
-- Dependencies: 278
-- Name: pdm_log_catalog_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.pdm_log_catalog_id_seq OWNED BY control.pdm_log_catalog.id;


--
-- TOC entry 279 (class 1259 OID 30492)
-- Name: pdm_log_message; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.pdm_log_message (
    log_id integer NOT NULL,
    log_pdm_id integer NOT NULL,
    log_pdm_time timestamp with time zone NOT NULL,
    log_server_time timestamp with time zone NOT NULL,
    log_level smallint NOT NULL,
    log_catalog smallint NOT NULL,
    log_text text NOT NULL
);


--
-- TOC entry 280 (class 1259 OID 30497)
-- Name: pdm_log_log_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.pdm_log_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3990 (class 0 OID 0)
-- Dependencies: 280
-- Name: pdm_log_log_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.pdm_log_log_id_seq OWNED BY control.pdm_log_message.log_id;


--
-- TOC entry 281 (class 1259 OID 30498)
-- Name: pdm_pdm_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.pdm_pdm_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3991 (class 0 OID 0)
-- Dependencies: 281
-- Name: pdm_pdm_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.pdm_pdm_id_seq OWNED BY control.pdm.pdm_id;


--
-- TOC entry 282 (class 1259 OID 30499)
-- Name: pdm_runtime; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.pdm_runtime (
    pdm_id integer NOT NULL,
    online boolean DEFAULT true,
    kal_inerval integer,
    id integer NOT NULL,
    kal_time timestamp with time zone,
    pay_time timestamp with time zone,
    pay_tracer integer,
    sta_time timestamp with time zone,
    sta_tracer integer,
    sys_time timestamp with time zone,
    sys_tracer integer,
    clr_time timestamp with time zone,
    clr_tracer integer,
    service timestamp with time zone,
    net_signal integer,
    net_login timestamp with time zone,
    net_type control.network_type,
    pow_time timestamp with time zone,
    pow_voltage real,
    pow_mcs_sol real,
    pow_sven_bat real,
    pow_sven_in real
);


--
-- TOC entry 3992 (class 0 OID 0)
-- Dependencies: 282
-- Name: COLUMN pdm_runtime.net_login; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.pdm_runtime.net_login IS 'Strenght of mobile signal in percents.';


--
-- TOC entry 311 (class 1259 OID 31205)
-- Name: pdm_runtime_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.pdm_runtime_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3993 (class 0 OID 0)
-- Dependencies: 311
-- Name: pdm_runtime_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.pdm_runtime_id_seq OWNED BY control.pdm_runtime.id;


--
-- TOC entry 283 (class 1259 OID 30503)
-- Name: pdm_status; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.pdm_status (
    pds_id bigint NOT NULL,
    pds_pdm_id integer NOT NULL,
    pds_log_id bigint NOT NULL,
    pds_acquirer_id integer,
    pds_msg_nr smallint NOT NULL
);


--
-- TOC entry 3994 (class 0 OID 0)
-- Dependencies: 283
-- Name: TABLE pdm_status; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON TABLE control.pdm_status IS 'Keeps status (active (negative) messages) sent by a PDM. When a PDM sends a positive message, the negative status is removed';


--
-- TOC entry 284 (class 1259 OID 30506)
-- Name: pdm_status_pds_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.pdm_status_pds_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3995 (class 0 OID 0)
-- Dependencies: 284
-- Name: pdm_status_pds_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.pdm_status_pds_id_seq OWNED BY control.pdm_status.pds_id;


--
-- TOC entry 285 (class 1259 OID 30507)
-- Name: pdm_x_tariff_info; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.pdm_x_tariff_info (
    pti_pdm_id integer NOT NULL,
    pti_tariff_info_id integer NOT NULL,
    pti_tariff_order integer NOT NULL
);


--
-- TOC entry 286 (class 1259 OID 30510)
-- Name: remote_action; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.remote_action (
    id integer NOT NULL,
    code integer NOT NULL,
    state integer NOT NULL,
    submit timestamp with time zone NOT NULL,
    pdm_id integer NOT NULL,
    user_id integer NOT NULL,
    status_id bigint,
    parameters character varying
);


--
-- TOC entry 287 (class 1259 OID 30515)
-- Name: remote_action_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.remote_action_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3996 (class 0 OID 0)
-- Dependencies: 287
-- Name: remote_action_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.remote_action_id_seq OWNED BY control.remote_action.id;


--
-- TOC entry 288 (class 1259 OID 30516)
-- Name: software_description; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.software_description (
    swd_id integer NOT NULL,
    swd_created timestamp with time zone,
    swd_note character varying(255),
    swd_device_type control.device_type NOT NULL,
    swd_file_name character varying,
    swd_model character varying,
    swd_version character varying,
    swd_visible boolean NOT NULL,
    swd_area_id integer,
    swd_name character varying,
    swd_author_id integer
);


--
-- TOC entry 289 (class 1259 OID 30521)
-- Name: software_description_swd_id_seq1; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.software_description_swd_id_seq1
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3997 (class 0 OID 0)
-- Dependencies: 289
-- Name: software_description_swd_id_seq1; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.software_description_swd_id_seq1 OWNED BY control.software_description.swd_id;


--
-- TOC entry 290 (class 1259 OID 30522)
-- Name: software_item; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.software_item (
    sws_id integer NOT NULL,
    sws_compressed boolean NOT NULL,
    sws_crc character varying(4) NOT NULL,
    sws_data oid NOT NULL,
    sws_length integer NOT NULL,
    sws_sha character varying(255)
);


--
-- TOC entry 291 (class 1259 OID 30525)
-- Name: software_path; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.software_path (
    swp_id integer NOT NULL,
    swp_swd_id integer NOT NULL,
    swp_path character varying,
    swp_sws_id integer NOT NULL
);


--
-- TOC entry 292 (class 1259 OID 30530)
-- Name: software_path_swp_id_seq1; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.software_path_swp_id_seq1
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3998 (class 0 OID 0)
-- Dependencies: 292
-- Name: software_path_swp_id_seq1; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.software_path_swp_id_seq1 OWNED BY control.software_path.swp_id;


--
-- TOC entry 293 (class 1259 OID 30531)
-- Name: software_store_sws_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.software_store_sws_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 3999 (class 0 OID 0)
-- Dependencies: 293
-- Name: software_store_sws_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.software_store_sws_id_seq OWNED BY control.software_item.sws_id;


--
-- TOC entry 294 (class 1259 OID 30532)
-- Name: static_bonus_type_sbt_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.static_bonus_type_sbt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 4000 (class 0 OID 0)
-- Dependencies: 294
-- Name: static_bonus_type_sbt_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.static_bonus_type_sbt_id_seq OWNED BY control.bonus_card_type.sbt_id;


--
-- TOC entry 295 (class 1259 OID 30537)
-- Name: tariff_info; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.tariff_info (
    tai_id integer NOT NULL,
    tai_name character varying NOT NULL,
    tai_visible boolean NOT NULL,
    tai_epos boolean NOT NULL
);


--
-- TOC entry 296 (class 1259 OID 30542)
-- Name: tariff_info_tai_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.tariff_info_tai_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 4001 (class 0 OID 0)
-- Dependencies: 296
-- Name: tariff_info_tai_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.tariff_info_tai_id_seq OWNED BY control.tariff_info.tai_id;


--
-- TOC entry 297 (class 1259 OID 30543)
-- Name: translog; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.translog (
    tl_id bigint NOT NULL,
    tl_tracer integer,
    tl_date_pc timestamp with time zone,
    tl_pay_reason control.payment_reason,
    tl_pay_type control.payment_type,
    tl_pay_date_time timestamp with time zone,
    tl_amount numeric(8,2),
    tl_exp_date_time timestamp with time zone,
    tl_ticket_no integer,
    tl_card_nr character varying(255),
    tl_currency character varying(3),
    tl_license_no character varying(255),
    tl_card_code integer,
    tl_parking_space_no integer,
    tl_pdm_id integer,
    tl_card_type smallint,
    tl_authorization_code character varying,
    tl_tariff_info_id integer,
    tl_rtp_session integer,
    tl_custom_data jsonb
);


--
-- TOC entry 298 (class 1259 OID 30548)
-- Name: translog_bonus; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.translog_bonus (
    id integer NOT NULL,
    duration integer,
    price numeric(8,2),
    payment bigint NOT NULL,
    origin control.applied_bonus_origin NOT NULL,
    kind control.applied_bonus_kind NOT NULL
);


--
-- TOC entry 4002 (class 0 OID 0)
-- Dependencies: 298
-- Name: TABLE translog_bonus; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON TABLE control.translog_bonus IS 'The bonusees from PControl applied to a payment transactons.';


--
-- TOC entry 4003 (class 0 OID 0)
-- Dependencies: 298
-- Name: COLUMN translog_bonus.duration; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.translog_bonus.duration IS 'Applyed time in minutes.';


--
-- TOC entry 299 (class 1259 OID 30551)
-- Name: translog_bonus_trb_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.translog_bonus_trb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 4004 (class 0 OID 0)
-- Dependencies: 299
-- Name: translog_bonus_trb_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.translog_bonus_trb_id_seq OWNED BY control.translog_bonus.id;


--
-- TOC entry 300 (class 1259 OID 30552)
-- Name: translog_ext; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.translog_ext (
    permit_ext bigint NOT NULL,
    permit_base bigint
);


--
-- TOC entry 4005 (class 0 OID 0)
-- Dependencies: 300
-- Name: TABLE translog_ext; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON TABLE control.translog_ext IS 'Parking ticket extension. Flowing SQL lists extended tickets with base ticket:
SELECT tl_id, tl_pay_date_time, tl_exp_date_time, translog.tl_pay_reason, translog.tl_amount, permit_ext, permit_base
FROM translog
JOIN translog_ext ON permit_ext = translog.tl_id
ORDER BY tl_id desc
LIMIT 10 ';


--
-- TOC entry 301 (class 1259 OID 30555)
-- Name: translog_rtp; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.translog_rtp (
    id integer NOT NULL,
    session_name character varying
);


--
-- TOC entry 302 (class 1259 OID 30560)
-- Name: translog_rtp_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.translog_rtp_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 4006 (class 0 OID 0)
-- Dependencies: 302
-- Name: translog_rtp_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.translog_rtp_id_seq OWNED BY control.translog_rtp.id;


--
-- TOC entry 303 (class 1259 OID 30561)
-- Name: translog_tl_record_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.translog_tl_record_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 4007 (class 0 OID 0)
-- Dependencies: 303
-- Name: translog_tl_record_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.translog_tl_record_id_seq OWNED BY control.translog.tl_id;


--
-- TOC entry 308 (class 1259 OID 30572)
-- Name: zone; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.zone (
    zon_id integer NOT NULL,
    zon_name character varying NOT NULL,
    zon_color character varying DEFAULT 'darkorange'::character varying,
    zon_description character varying,
    zon_area_id integer NOT NULL,
    zon_enforcement integer DEFAULT 0 NOT NULL
);


--
-- TOC entry 309 (class 1259 OID 30579)
-- Name: zone__perm_ext; Type: TABLE; Schema: control; Owner: -
--

CREATE TABLE control.zone__perm_ext (
    pex_tolerance_time integer NOT NULL,
    pex_peanlty_time integer NOT NULL,
    pex_peanlty_value numeric NOT NULL,
    pex_max_permits integer DEFAULT 999 NOT NULL,
    pex_max_duration integer DEFAULT 43200 NOT NULL,
    pex_max_price numeric(8,2) DEFAULT 99999 NOT NULL,
    pex_id integer NOT NULL,
    pex_enabled boolean DEFAULT true NOT NULL
);


--
-- TOC entry 4008 (class 0 OID 0)
-- Dependencies: 309
-- Name: COLUMN zone__perm_ext.pex_tolerance_time; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.zone__perm_ext.pex_tolerance_time IS 'In minues';


--
-- TOC entry 4009 (class 0 OID 0)
-- Dependencies: 309
-- Name: COLUMN zone__perm_ext.pex_peanlty_time; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.zone__perm_ext.pex_peanlty_time IS 'In minues';


--
-- TOC entry 4010 (class 0 OID 0)
-- Dependencies: 309
-- Name: COLUMN zone__perm_ext.pex_peanlty_value; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.zone__perm_ext.pex_peanlty_value IS 'In PDM currency';


--
-- TOC entry 4011 (class 0 OID 0)
-- Dependencies: 309
-- Name: COLUMN zone__perm_ext.pex_max_duration; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON COLUMN control.zone__perm_ext.pex_max_duration IS 'Permits longer then this duration (in minutes) will not be extended. Default value 30 days.';


--
-- TOC entry 310 (class 1259 OID 30588)
-- Name: zone_zon_id_seq; Type: SEQUENCE; Schema: control; Owner: -
--

CREATE SEQUENCE control.zone_zon_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 4012 (class 0 OID 0)
-- Dependencies: 310
-- Name: zone_zon_id_seq; Type: SEQUENCE OWNED BY; Schema: control; Owner: -
--

ALTER SEQUENCE control.zone_zon_id_seq OWNED BY control.zone.zon_id;


--
-- TOC entry 304 (class 1259 OID 30562)
-- Name: user_authentication; Type: TABLE; Schema: auth; Owner: -
--

CREATE TABLE control.user_authentication (
    usa_id integer NOT NULL,
    usa_login character varying(255),
    usa_password character varying,
    usa_enabled boolean,
    usa_firstname character varying(255),
    usa_lastname character varying(255),
    usa_email character varying(255),
    usa_timezone character varying(255)
);


--
-- TOC entry 305 (class 1259 OID 30567)
-- Name: user_authentication_usa_id_seq; Type: SEQUENCE; Schema: auth; Owner: -
--

CREATE SEQUENCE control.user_authentication_usa_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 4013 (class 0 OID 0)
-- Dependencies: 305
-- Name: user_authentication_usa_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE control.user_authentication_usa_id_seq OWNED BY control.user_authentication.usa_id;


--
-- TOC entry 306 (class 1259 OID 30568)
-- Name: user_role; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE control.user_role (
    usr_id bigint NOT NULL,
    usr_user_id integer NOT NULL,
    usr_role character varying(255) NOT NULL
);


--
-- TOC entry 307 (class 1259 OID 30571)
-- Name: user_role_usr_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE control.user_role_usr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- TOC entry 4014 (class 0 OID 0)
-- Dependencies: 307
-- Name: user_role_usr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE control.user_role_usr_id_seq OWNED BY control.user_role.usr_id;


--
-- TOC entry 3471 (class 2604 OID 30589)
-- Name: accu_level al_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.accu_level ALTER COLUMN al_id SET DEFAULT nextval('control.accu_level_al_id_seq'::regclass);


--
-- TOC entry 3472 (class 2604 OID 30590)
-- Name: area_partner id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.area_partner ALTER COLUMN id SET DEFAULT nextval('control.area_service_id_seq'::regclass);


--
-- TOC entry 3473 (class 2604 OID 30591)
-- Name: area_partner area_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.area_partner ALTER COLUMN area_id SET DEFAULT nextval('control.area_service_area_id_seq'::regclass);


--
-- TOC entry 3478 (class 2604 OID 30592)
-- Name: bonus_card_type sbt_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_card_type ALTER COLUMN sbt_id SET DEFAULT nextval('control.static_bonus_type_sbt_id_seq'::regclass);


--
-- TOC entry 3479 (class 2604 OID 30593)
-- Name: bonus_counting_rule id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_counting_rule ALTER COLUMN id SET DEFAULT nextval('control.bonus_counting_rule_id_seq'::regclass);


--
-- TOC entry 3480 (class 2604 OID 30594)
-- Name: bonus_counting_usage id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_counting_usage ALTER COLUMN id SET DEFAULT nextval('control.bonus_counting_usage_id_seq'::regclass);


--
-- TOC entry 3481 (class 2604 OID 30595)
-- Name: bonus_disposable id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_disposable ALTER COLUMN id SET DEFAULT nextval('control.bonus_disposable_id_seq'::regclass);


--
-- TOC entry 3476 (class 2604 OID 30596)
-- Name: bonus_lpn_basic1_config id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_basic1_config ALTER COLUMN id SET DEFAULT nextval('control.bonus_bon_id_seq'::regclass);


--
-- TOC entry 3482 (class 2604 OID 30597)
-- Name: bonus_lpn_basic1_exception id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_basic1_exception ALTER COLUMN id SET DEFAULT nextval('control.bonus_exception_boe_id_seq'::regclass);


--
-- TOC entry 3484 (class 2604 OID 30598)
-- Name: bonus_lpn_basic1_rule id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_basic1_rule ALTER COLUMN id SET DEFAULT nextval('control.bonus_rule_bor_id_seq'::regclass);


--
-- TOC entry 3486 (class 2604 OID 30599)
-- Name: bonus_lpn_basic2_config id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_basic2_config ALTER COLUMN id SET DEFAULT nextval('control.bonus_lpn_individual_id_seq'::regclass);


--
-- TOC entry 3487 (class 2604 OID 30600)
-- Name: bonus_lpn_mt1_rule id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_mt1_rule ALTER COLUMN id SET DEFAULT nextval('control.bonus_mt_entry_bmte_id_seq'::regclass);


--
-- TOC entry 3488 (class 2604 OID 30601)
-- Name: bonus_lpn_mt2_rule id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_mt2_rule ALTER COLUMN id SET DEFAULT nextval('control.bonus_lpn_mt2_rule_id_seq'::regclass);


--
-- TOC entry 3489 (class 2604 OID 30602)
-- Name: bonus_lpn_mt2_usage id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_mt2_usage ALTER COLUMN id SET DEFAULT nextval('control.bonus_lpn_mt2_usage_id_seq'::regclass);


--
-- TOC entry 3490 (class 2604 OID 30603)
-- Name: bonus_psn_mt1_rule id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_psn_mt1_rule ALTER COLUMN id SET DEFAULT nextval('control.bonus_psn_mt_entry_id_seq'::regclass);


--
-- TOC entry 3492 (class 2604 OID 30605)
-- Name: cache_permanent id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.cache_permanent ALTER COLUMN id SET DEFAULT nextval('control.cache_permanent_id_seq'::regclass);


--
-- TOC entry 3493 (class 2604 OID 30606)
-- Name: cash_box_item cbi_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.cash_box_item ALTER COLUMN cbi_id SET DEFAULT nextval('control.cash_box_item_cbi_id_seq'::regclass);


--
-- TOC entry 3491 (class 2604 OID 30604)
-- Name: cash_box_level id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.cash_box_level ALTER COLUMN id SET DEFAULT nextval('control.cache_cash_box_level_id_seq'::regclass);


--
-- TOC entry 3494 (class 2604 OID 30607)
-- Name: cash_kind csk_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.cash_kind ALTER COLUMN csk_id SET DEFAULT nextval('control.cash_kind_csk_id_seq'::regclass);


--
-- TOC entry 3495 (class 2604 OID 30608)
-- Name: clearing clr_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.clearing ALTER COLUMN clr_id SET DEFAULT nextval('control.clearing_clr_id_seq'::regclass);


--
-- TOC entry 3496 (class 2604 OID 30609)
-- Name: download_entry dwe_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.download_entry ALTER COLUMN dwe_id SET DEFAULT nextval('control.download_entry_dwe_id_seq1'::regclass);


--
-- TOC entry 3499 (class 2604 OID 30610)
-- Name: download_plan dwp_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.download_plan ALTER COLUMN dwp_id SET DEFAULT nextval('control.download_plan_dwp_id_seq1'::regclass);


--
-- TOC entry 3501 (class 2604 OID 30611)
-- Name: forwarding_rule fwr_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.forwarding_rule ALTER COLUMN fwr_id SET DEFAULT nextval('control.forwarding_rule_fwr_id_seq'::regclass);


--
-- TOC entry 3503 (class 2604 OID 30612)
-- Name: hw_device id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.hw_device ALTER COLUMN id SET DEFAULT nextval('control.hw_device_id_seq'::regclass);


--
-- TOC entry 3504 (class 2604 OID 30613)
-- Name: hw_status hwr_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.hw_status ALTER COLUMN hwr_id SET DEFAULT nextval('control.hw_status_hwr_id_seq'::regclass);


--
-- TOC entry 3505 (class 2604 OID 30614)
-- Name: logbook log_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.logbook ALTER COLUMN log_id SET DEFAULT nextval('control.logbook_log_id_seq'::regclass);


--
-- TOC entry 3507 (class 2604 OID 30615)
-- Name: message_config_user msu_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.message_config_user ALTER COLUMN msu_id SET DEFAULT nextval('control.message_config_msc_id_seq'::regclass);


--
-- TOC entry 3508 (class 2604 OID 30616)
-- Name: modem_login mlg_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.modem_login ALTER COLUMN mlg_id SET DEFAULT nextval('control.modem_login_mlg_id_seq'::regclass);


--
-- TOC entry 3509 (class 2604 OID 30617)
-- Name: paper_role id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.paper_role ALTER COLUMN id SET DEFAULT nextval('control.paper_role_id_seq'::regclass);


--
-- TOC entry 3510 (class 2604 OID 30618)
-- Name: paper_usage id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.paper_usage ALTER COLUMN id SET DEFAULT nextval('control.paper_usage_id_seq'::regclass);


--
-- TOC entry 3511 (class 2604 OID 30619)
-- Name: pdm pdm_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm ALTER COLUMN pdm_id SET DEFAULT nextval('control.pdm_pdm_id_seq'::regclass);


--
-- TOC entry 3512 (class 2604 OID 30620)
-- Name: pdm_log_catalog id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_log_catalog ALTER COLUMN id SET DEFAULT nextval('control.pdm_log_catalog_id_seq'::regclass);


--
-- TOC entry 3513 (class 2604 OID 30621)
-- Name: pdm_log_message log_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_log_message ALTER COLUMN log_id SET DEFAULT nextval('control.pdm_log_log_id_seq'::regclass);


--
-- TOC entry 3515 (class 2604 OID 31206)
-- Name: pdm_runtime id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_runtime ALTER COLUMN id SET DEFAULT nextval('control.pdm_runtime_id_seq'::regclass);


--
-- TOC entry 3516 (class 2604 OID 30622)
-- Name: pdm_status pds_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_status ALTER COLUMN pds_id SET DEFAULT nextval('control.pdm_status_pds_id_seq'::regclass);


--
-- TOC entry 3517 (class 2604 OID 30623)
-- Name: remote_action id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.remote_action ALTER COLUMN id SET DEFAULT nextval('control.remote_action_id_seq'::regclass);


--
-- TOC entry 3518 (class 2604 OID 30624)
-- Name: software_description swd_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.software_description ALTER COLUMN swd_id SET DEFAULT nextval('control.software_description_swd_id_seq1'::regclass);


--
-- TOC entry 3519 (class 2604 OID 30625)
-- Name: software_item sws_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.software_item ALTER COLUMN sws_id SET DEFAULT nextval('control.software_store_sws_id_seq'::regclass);


--
-- TOC entry 3520 (class 2604 OID 30626)
-- Name: software_path swp_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.software_path ALTER COLUMN swp_id SET DEFAULT nextval('control.software_path_swp_id_seq1'::regclass);


--
-- TOC entry 3521 (class 2604 OID 30628)
-- Name: tariff_info tai_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.tariff_info ALTER COLUMN tai_id SET DEFAULT nextval('control.tariff_info_tai_id_seq'::regclass);


--
-- TOC entry 3522 (class 2604 OID 30629)
-- Name: translog tl_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog ALTER COLUMN tl_id SET DEFAULT nextval('control.translog_tl_record_id_seq'::regclass);


--
-- TOC entry 3523 (class 2604 OID 30630)
-- Name: translog_bonus id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog_bonus ALTER COLUMN id SET DEFAULT nextval('control.translog_bonus_trb_id_seq'::regclass);


--
-- TOC entry 3524 (class 2604 OID 30631)
-- Name: translog_rtp id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog_rtp ALTER COLUMN id SET DEFAULT nextval('control.translog_rtp_id_seq'::regclass);


--
-- TOC entry 3529 (class 2604 OID 30634)
-- Name: zone zon_id; Type: DEFAULT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.zone ALTER COLUMN zon_id SET DEFAULT nextval('control.zone_zon_id_seq'::regclass);


--
-- TOC entry 3525 (class 2604 OID 30632)
-- Name: user_authentication usa_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY control.user_authentication ALTER COLUMN usa_id SET DEFAULT nextval('control.user_authentication_usa_id_seq'::regclass);


--
-- TOC entry 3526 (class 2604 OID 30633)
-- Name: user_role usr_id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY control.user_role ALTER COLUMN usr_id SET DEFAULT nextval('control.user_role_usr_id_seq'::regclass);


--
-- TOC entry 3587 (class 2606 OID 30654)
-- Name: bonus_lpn_mt1_rule bonus_mt_entry_bmte_lpn_bmte_zone_id_key; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_mt1_rule
    ADD CONSTRAINT bonus_mt_entry_bmte_lpn_bmte_zone_id_key UNIQUE (lpn, zone_id);


--
-- TOC entry 3601 (class 2606 OID 30656)
-- Name: bonus_psn_mt1_rule bonus_psn_mt_entry_bmte_lpn_bmte_zone_id_key; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_psn_mt1_rule
    ADD CONSTRAINT bonus_psn_mt_entry_bmte_lpn_bmte_zone_id_key UNIQUE (psn, zone_id);


--
-- TOC entry 3537 (class 2606 OID 30660)
-- Name: accu_level pk_accu_level; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.accu_level
    ADD CONSTRAINT pk_accu_level PRIMARY KEY (al_id);


--
-- TOC entry 3542 (class 2606 OID 30662)
-- Name: area_partner pk_area_service; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.area_partner
    ADD CONSTRAINT pk_area_service PRIMARY KEY (id);


--
-- TOC entry 3548 (class 2606 OID 30664)
-- Name: area_x_user pk_area_x_user; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.area_x_user
    ADD CONSTRAINT pk_area_x_user PRIMARY KEY (user_id, area_id);


--
-- TOC entry 3539 (class 2606 OID 30666)
-- Name: area pk_areacode; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.area
    ADD CONSTRAINT pk_areacode PRIMARY KEY (ac_id);


--
-- TOC entry 3554 (class 2606 OID 30668)
-- Name: bonus_card_rule pk_bonus_card_rule; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_card_rule
    ADD CONSTRAINT pk_bonus_card_rule PRIMARY KEY (sbd_id);


--
-- TOC entry 3562 (class 2606 OID 30670)
-- Name: bonus_counting_rule pk_bonus_counting_rule; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_counting_rule
    ADD CONSTRAINT pk_bonus_counting_rule PRIMARY KEY (id);


--
-- TOC entry 3567 (class 2606 OID 30672)
-- Name: bonus_counting_usage pk_bonus_counting_usage; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_counting_usage
    ADD CONSTRAINT pk_bonus_counting_usage PRIMARY KEY (id);


--
-- TOC entry 3574 (class 2606 OID 30674)
-- Name: bonus_disposable pk_bonus_disposable; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_disposable
    ADD CONSTRAINT pk_bonus_disposable PRIMARY KEY (id);


--
-- TOC entry 3550 (class 2606 OID 30676)
-- Name: bonus_lpn_basic1_config pk_bonus_lpn_common; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_basic1_config
    ADD CONSTRAINT pk_bonus_lpn_common PRIMARY KEY (id);


--
-- TOC entry 3579 (class 2606 OID 30678)
-- Name: bonus_lpn_basic1_exception pk_bonus_lpn_common_exception; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_basic1_exception
    ADD CONSTRAINT pk_bonus_lpn_common_exception PRIMARY KEY (id);


--
-- TOC entry 3582 (class 2606 OID 30680)
-- Name: bonus_lpn_basic1_rule pk_bonus_lpn_common_rule; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_basic1_rule
    ADD CONSTRAINT pk_bonus_lpn_common_rule PRIMARY KEY (id);


--
-- TOC entry 3585 (class 2606 OID 30682)
-- Name: bonus_lpn_basic2_config pk_bonus_lpn_individual; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_basic2_config
    ADD CONSTRAINT pk_bonus_lpn_individual PRIMARY KEY (id);


--
-- TOC entry 3595 (class 2606 OID 30684)
-- Name: bonus_lpn_mt2_rule pk_bonus_lpn_mt2_rule; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_mt2_rule
    ADD CONSTRAINT pk_bonus_lpn_mt2_rule PRIMARY KEY (id);


--
-- TOC entry 3599 (class 2606 OID 30686)
-- Name: bonus_lpn_mt2_usage pk_bonus_lpn_mt2_usage; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_mt2_usage
    ADD CONSTRAINT pk_bonus_lpn_mt2_usage PRIMARY KEY (id);


--
-- TOC entry 3591 (class 2606 OID 30688)
-- Name: bonus_lpn_mt1_rule pk_bonus_lpn_mt_entry; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_mt1_rule
    ADD CONSTRAINT pk_bonus_lpn_mt_entry PRIMARY KEY (id);


--
-- TOC entry 3604 (class 2606 OID 30690)
-- Name: bonus_psn_mt1_rule pk_bonus_psn_mt_entry; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_psn_mt1_rule
    ADD CONSTRAINT pk_bonus_psn_mt_entry PRIMARY KEY (id);


--
-- TOC entry 3557 (class 2606 OID 30692)
-- Name: bonus_card_type pk_bonus_type; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_card_type
    ADD CONSTRAINT pk_bonus_type PRIMARY KEY (sbt_id);


--
-- TOC entry 3607 (class 2606 OID 30694)
-- Name: cash_box_level pk_cache_cash_box_level; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.cash_box_level
    ADD CONSTRAINT pk_cache_cash_box_level PRIMARY KEY (id);


--
-- TOC entry 3611 (class 2606 OID 30696)
-- Name: cache_permanent pk_cache_permanent; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.cache_permanent
    ADD CONSTRAINT pk_cache_permanent PRIMARY KEY (id);


--
-- TOC entry 3614 (class 2606 OID 30698)
-- Name: cash_box_item pk_cash_box_item; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.cash_box_item
    ADD CONSTRAINT pk_cash_box_item PRIMARY KEY (cbi_id);


--
-- TOC entry 3616 (class 2606 OID 30700)
-- Name: cash_kind pk_cash_kind; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.cash_kind
    ADD CONSTRAINT pk_cash_kind PRIMARY KEY (csk_id);


--
-- TOC entry 3669 (class 2606 OID 30702)
-- Name: pdm_log_catalog pk_catalog_name; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_log_catalog
    ADD CONSTRAINT pk_catalog_name PRIMARY KEY (id);


--
-- TOC entry 3621 (class 2606 OID 30704)
-- Name: clearing pk_clearing; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.clearing
    ADD CONSTRAINT pk_clearing PRIMARY KEY (clr_id);


--
-- TOC entry 3627 (class 2606 OID 30708)
-- Name: download_entry pk_download_entry; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.download_entry
    ADD CONSTRAINT pk_download_entry PRIMARY KEY (dwe_id);


--
-- TOC entry 3630 (class 2606 OID 30710)
-- Name: download_plan pk_download_plan; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.download_plan
    ADD CONSTRAINT pk_download_plan PRIMARY KEY (dwp_id);


--
-- TOC entry 3716 (class 2606 OID 30712)
-- Name: translog_ext pk_fk_tarnslog_ext; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog_ext
    ADD CONSTRAINT pk_fk_tarnslog_ext PRIMARY KEY (permit_ext);


--
-- TOC entry 3632 (class 2606 OID 30714)
-- Name: forwarding_rule pk_forward_rule; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.forwarding_rule
    ADD CONSTRAINT pk_forward_rule PRIMARY KEY (fwr_id);


--
-- TOC entry 3637 (class 2606 OID 30716)
-- Name: hw_device pk_hw_device; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.hw_device
    ADD CONSTRAINT pk_hw_device PRIMARY KEY (id);


--
-- TOC entry 3639 (class 2606 OID 30718)
-- Name: hw_status pk_hw_status; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.hw_status
    ADD CONSTRAINT pk_hw_status PRIMARY KEY (hwr_id);


--
-- TOC entry 3644 (class 2606 OID 30720)
-- Name: logbook pk_logbook; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.logbook
    ADD CONSTRAINT pk_logbook PRIMARY KEY (log_id);


--
-- TOC entry 3648 (class 2606 OID 30722)
-- Name: message_config_user pk_message_config; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.message_config_user
    ADD CONSTRAINT pk_message_config PRIMARY KEY (msu_id);


--
-- TOC entry 3646 (class 2606 OID 30724)
-- Name: message_config_default pk_message_config_defaults; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.message_config_default
    ADD CONSTRAINT pk_message_config_defaults PRIMARY KEY (mcd_number);


--
-- TOC entry 3654 (class 2606 OID 30726)
-- Name: modem_login pk_modem_login; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.modem_login
    ADD CONSTRAINT pk_modem_login PRIMARY KEY (mlg_id);


--
-- TOC entry 3657 (class 2606 OID 30728)
-- Name: paper_role pk_paper_role; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.paper_role
    ADD CONSTRAINT pk_paper_role PRIMARY KEY (id);


--
-- TOC entry 3660 (class 2606 OID 30730)
-- Name: paper_usage pk_paper_usage; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.paper_usage
    ADD CONSTRAINT pk_paper_usage PRIMARY KEY (id);


--
-- TOC entry 3665 (class 2606 OID 30732)
-- Name: pdm pk_pdm; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm
    ADD CONSTRAINT pk_pdm PRIMARY KEY (pdm_id);


--
-- TOC entry 3689 (class 2606 OID 30734)
-- Name: pdm_x_tariff_info pk_pdm__tariff_info; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_x_tariff_info
    ADD CONSTRAINT pk_pdm__tariff_info PRIMARY KEY (pti_pdm_id, pti_tariff_info_id, pti_tariff_order);


--
-- TOC entry 3676 (class 2606 OID 30736)
-- Name: pdm_log_message pk_pdm_log; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_log_message
    ADD CONSTRAINT pk_pdm_log PRIMARY KEY (log_id);


--
-- TOC entry 3679 (class 2606 OID 31211)
-- Name: pdm_runtime pk_pdm_runtime; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_runtime
    ADD CONSTRAINT pk_pdm_runtime PRIMARY KEY (id);


--
-- TOC entry 3683 (class 2606 OID 30745)
-- Name: pdm_status pk_pdm_status; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_status
    ADD CONSTRAINT pk_pdm_status PRIMARY KEY (pds_id);


--
-- TOC entry 3691 (class 2606 OID 30747)
-- Name: remote_action pk_remote_action; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.remote_action
    ADD CONSTRAINT pk_remote_action PRIMARY KEY (id);


--
-- TOC entry 3695 (class 2606 OID 30749)
-- Name: software_description pk_software_description; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.software_description
    ADD CONSTRAINT pk_software_description PRIMARY KEY (swd_id);


--
-- TOC entry 3699 (class 2606 OID 30751)
-- Name: software_path pk_software_path; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.software_path
    ADD CONSTRAINT pk_software_path PRIMARY KEY (swp_id);


--
-- TOC entry 3697 (class 2606 OID 30753)
-- Name: software_item pk_software_store; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.software_item
    ADD CONSTRAINT pk_software_store PRIMARY KEY (sws_id);


--
-- TOC entry 3703 (class 2606 OID 30757)
-- Name: tariff_info pk_tariff_info; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.tariff_info
    ADD CONSTRAINT pk_tariff_info PRIMARY KEY (tai_id);


--
-- TOC entry 3710 (class 2606 OID 30759)
-- Name: translog pk_translog; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog
    ADD CONSTRAINT pk_translog PRIMARY KEY (tl_id);


--
-- TOC entry 3713 (class 2606 OID 30764)
-- Name: translog_bonus pk_translog_bonus; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog_bonus
    ADD CONSTRAINT pk_translog_bonus PRIMARY KEY (id);


--
-- TOC entry 3718 (class 2606 OID 30766)
-- Name: translog_rtp pk_translog_rtp; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog_rtp
    ADD CONSTRAINT pk_translog_rtp PRIMARY KEY (id);


--
-- TOC entry 3730 (class 2606 OID 30772)
-- Name: zone pk_zone; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.zone
    ADD CONSTRAINT pk_zone PRIMARY KEY (zon_id);


--
-- TOC entry 3732 (class 2606 OID 30774)
-- Name: zone__perm_ext pk_zone__perm_ext; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.zone__perm_ext
    ADD CONSTRAINT pk_zone__perm_ext PRIMARY KEY (pex_id);


--
-- TOC entry 3544 (class 2606 OID 30776)
-- Name: area_partner uc_area_config; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.area_partner
    ADD CONSTRAINT uc_area_config UNIQUE (area_id, cfg_type);


--
-- TOC entry 3720 (class 2606 OID 30778)
-- Name: translog_rtp uc_translog_rtp__session_name; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog_rtp
    ADD CONSTRAINT uc_translog_rtp__session_name UNIQUE (session_name);


--
-- TOC entry 3667 (class 2606 OID 30780)
-- Name: pdm uix_pdm_areacode_id__pdm_number; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm
    ADD CONSTRAINT uix_pdm_areacode_id__pdm_number UNIQUE (pdm_area_id, pdm_number);


--
-- TOC entry 3559 (class 2606 OID 30782)
-- Name: bonus_card_type uk_bonus_card_type__key_zone; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_card_type
    ADD CONSTRAINT uk_bonus_card_type__key_zone UNIQUE (sbt_key, sbt_zone_id);


--
-- TOC entry 4015 (class 0 OID 0)
-- Dependencies: 3559
-- Name: CONSTRAINT uk_bonus_card_type__key_zone ON bonus_card_type; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON CONSTRAINT uk_bonus_card_type__key_zone ON control.bonus_card_type IS 'Card name must be unique within a zone.';


--
-- TOC entry 3564 (class 2606 OID 30784)
-- Name: bonus_counting_rule uk_bonus_conuting_rule__name; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_counting_rule
    ADD CONSTRAINT uk_bonus_conuting_rule__name UNIQUE (name, zone_id);


--
-- TOC entry 4016 (class 0 OID 0)
-- Dependencies: 3564
-- Name: CONSTRAINT uk_bonus_conuting_rule__name ON bonus_counting_rule; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON CONSTRAINT uk_bonus_conuting_rule__name ON control.bonus_counting_rule IS 'Every name can by only once in each zone.';


--
-- TOC entry 3569 (class 2606 OID 30786)
-- Name: bonus_counting_usage uk_bonus_counting_usage__config_day; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_counting_usage
    ADD CONSTRAINT uk_bonus_counting_usage__config_day UNIQUE (config_id, day);


--
-- TOC entry 4017 (class 0 OID 0)
-- Dependencies: 3569
-- Name: CONSTRAINT uk_bonus_counting_usage__config_day ON bonus_counting_usage; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON CONSTRAINT uk_bonus_counting_usage__config_day ON control.bonus_counting_usage IS 'There can be only one couter entry within one day.';


--
-- TOC entry 3597 (class 2606 OID 30788)
-- Name: bonus_lpn_mt2_rule uk_bonus_lpn_mt2__lpn_zone; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_mt2_rule
    ADD CONSTRAINT uk_bonus_lpn_mt2__lpn_zone UNIQUE (lpn, zone_id);


--
-- TOC entry 3609 (class 2606 OID 31204)
-- Name: cash_box_level uk_cash_box_level; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.cash_box_level
    ADD CONSTRAINT uk_cash_box_level UNIQUE (pdm_id, payment_type, currency);


--
-- TOC entry 3618 (class 2606 OID 30790)
-- Name: cash_kind uk_cash_kind; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.cash_kind
    ADD CONSTRAINT uk_cash_kind UNIQUE (csk_code, csk_value);


--
-- TOC entry 3671 (class 2606 OID 30792)
-- Name: pdm_log_catalog uk_catalog_name; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_log_catalog
    ADD CONSTRAINT uk_catalog_name UNIQUE (title);


--
-- TOC entry 3576 (class 2606 OID 30794)
-- Name: bonus_disposable uk_code; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_disposable
    ADD CONSTRAINT uk_code UNIQUE (code, zone_id);


--
-- TOC entry 3650 (class 2606 OID 30796)
-- Name: message_config_user uk_message_number__area_code; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.message_config_user
    ADD CONSTRAINT uk_message_number__area_code UNIQUE (msu_message_number, msu_area_id);


--
-- TOC entry 3685 (class 2606 OID 30798)
-- Name: pdm_status uk_pdm__msg_nr; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_status
    ADD CONSTRAINT uk_pdm__msg_nr UNIQUE (pds_pdm_id, pds_msg_nr);


--
-- TOC entry 3701 (class 2606 OID 30800)
-- Name: software_path uk_software_path_in_sw_plan; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.software_path
    ADD CONSTRAINT uk_software_path_in_sw_plan UNIQUE (swp_swd_id, swp_path);


--
-- TOC entry 3705 (class 2606 OID 30802)
-- Name: tariff_info uk_tariff_name; Type: CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.tariff_info
    ADD CONSTRAINT uk_tariff_name UNIQUE (tai_name);


--
-- TOC entry 3722 (class 2606 OID 30768)
-- Name: user_authentication pk_user_authentication; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY control.user_authentication
    ADD CONSTRAINT pk_user_authentication PRIMARY KEY (usa_id);


--
-- TOC entry 3728 (class 2606 OID 30770)
-- Name: user_role pk_user_role; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY control.user_role
    ADD CONSTRAINT pk_user_role PRIMARY KEY (usr_id);


--
-- TOC entry 3725 (class 2606 OID 30804)
-- Name: user_authentication uk_user_name; Type: CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY control.user_authentication
    ADD CONSTRAINT uk_user_name UNIQUE (usa_login);


--
-- TOC entry 3580 (class 1259 OID 30805)
-- Name: fk_bonus_lpn_common_rule__bonus_lpn_common; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fk_bonus_lpn_common_rule__bonus_lpn_common ON control.bonus_lpn_basic1_rule USING btree (bonus_id);


--
-- TOC entry 3534 (class 1259 OID 30806)
-- Name: fki_accu_level__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_accu_level__pdm ON control.accu_level USING btree (al_pdm_id);


--
-- TOC entry 3680 (class 1259 OID 30807)
-- Name: fki_acquirer; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_acquirer ON control.pdm_status USING btree (pds_acquirer_id);


--
-- TOC entry 3540 (class 1259 OID 30808)
-- Name: fki_area_service__area; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_area_service__area ON control.area_partner USING btree (area_id);


--
-- TOC entry 3551 (class 1259 OID 30809)
-- Name: fki_bonus_card_rule__type; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_bonus_card_rule__type ON control.bonus_card_rule USING btree (sbd_type_id);


--
-- TOC entry 3555 (class 1259 OID 30810)
-- Name: fki_bonus_card_type__zone; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_bonus_card_type__zone ON control.bonus_card_type USING btree (sbt_zone_id);


--
-- TOC entry 3565 (class 1259 OID 30811)
-- Name: fki_bonus_counting_usage__rule; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_bonus_counting_usage__rule ON control.bonus_counting_usage USING btree (config_id);


--
-- TOC entry 3570 (class 1259 OID 30812)
-- Name: fki_bonus_disposable__payment; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_bonus_disposable__payment ON control.bonus_disposable USING btree (payment_id);


--
-- TOC entry 3571 (class 1259 OID 30813)
-- Name: fki_bonus_disposable__user; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_bonus_disposable__user ON control.bonus_disposable USING btree (creator_id);


--
-- TOC entry 3572 (class 1259 OID 30814)
-- Name: fki_bonus_disposable__zone; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_bonus_disposable__zone ON control.bonus_disposable USING btree (zone_id);


--
-- TOC entry 3577 (class 1259 OID 30815)
-- Name: fki_bonus_lpn_common_exception__bonus_lpn_common; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_bonus_lpn_common_exception__bonus_lpn_common ON control.bonus_lpn_basic1_exception USING btree (bonus_id);


--
-- TOC entry 3583 (class 1259 OID 30816)
-- Name: fki_bonus_lpn_individual__zone; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_bonus_lpn_individual__zone ON control.bonus_lpn_basic2_config USING btree (id);


--
-- TOC entry 3592 (class 1259 OID 30817)
-- Name: fki_bonus_lpn_mt2_rule__zone_id; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_bonus_lpn_mt2_rule__zone_id ON control.bonus_lpn_mt2_rule USING btree (zone_id);


--
-- TOC entry 3588 (class 1259 OID 30818)
-- Name: fki_bonus_lpn_mt_entry__zone; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_bonus_lpn_mt_entry__zone ON control.bonus_lpn_mt1_rule USING btree (zone_id);


--
-- TOC entry 3602 (class 1259 OID 30819)
-- Name: fki_bonus_psn_mt__zone; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_bonus_psn_mt__zone ON control.bonus_psn_mt1_rule USING btree (zone_id);


--
-- TOC entry 3605 (class 1259 OID 30820)
-- Name: fki_cache_cash_box_level__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_cache_cash_box_level__pdm ON control.cash_box_level USING btree (pdm_id);


--
-- TOC entry 3612 (class 1259 OID 30821)
-- Name: fki_cash_box_item__cash_kind; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_cash_box_item__cash_kind ON control.cash_box_item USING btree (cbi_clearing_id);


--
-- TOC entry 3619 (class 1259 OID 30822)
-- Name: fki_clearing__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_clearing__pdm ON control.clearing USING btree (clr_pdm_id);


--
-- TOC entry 3545 (class 1259 OID 30823)
-- Name: fki_fk_area_x_user__area; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_fk_area_x_user__area ON control.area_x_user USING btree (area_id);


--
-- TOC entry 3546 (class 1259 OID 30824)
-- Name: fki_fk_area_x_user__user; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_fk_area_x_user__user ON control.area_x_user USING btree (user_id);


--
-- TOC entry 3628 (class 1259 OID 30825)
-- Name: fki_fk_download_plan__user; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_fk_download_plan__user ON control.download_plan USING btree (dwp_modified_by);


--
-- TOC entry 3633 (class 1259 OID 30826)
-- Name: fki_hw_device__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_hw_device__pdm ON control.hw_device USING btree (pdm_id);


--
-- TOC entry 3634 (class 1259 OID 30827)
-- Name: fki_hw_status__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_hw_status__pdm ON control.hw_device USING btree (pdm_id);


--
-- TOC entry 3640 (class 1259 OID 30828)
-- Name: fki_logbook__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_logbook__pdm ON control.logbook USING btree (log_pdm_id);


--
-- TOC entry 3651 (class 1259 OID 30829)
-- Name: fki_modem_login__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_modem_login__pdm ON control.modem_login USING btree (mlg_pdm_id);


--
-- TOC entry 3655 (class 1259 OID 30830)
-- Name: fki_paper_role__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_paper_role__pdm ON control.paper_role USING btree (pdm_id);


--
-- TOC entry 3658 (class 1259 OID 30831)
-- Name: fki_paper_usage__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_paper_usage__pdm ON control.paper_usage USING btree (pdm_id);


--
-- TOC entry 3706 (class 1259 OID 30832)
-- Name: fki_payment__rtp; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_payment__rtp ON control.translog USING btree (tl_rtp_session);


--
-- TOC entry 3661 (class 1259 OID 30833)
-- Name: fki_pdm__area; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_pdm__area ON control.pdm USING btree (pdm_area_id);


--
-- TOC entry 3662 (class 1259 OID 30834)
-- Name: fki_pdm__zone; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_pdm__zone ON control.pdm USING btree (pdm_zone_id);


--
-- TOC entry 3672 (class 1259 OID 30835)
-- Name: fki_pdm_log_message__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_pdm_log_message__pdm ON control.pdm_log_message USING btree (log_pdm_id);


--
-- TOC entry 3673 (class 1259 OID 30836)
-- Name: fki_pdm_log_message__pdm_log_catalog; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_pdm_log_message__pdm_log_catalog ON control.pdm_log_message USING btree (log_catalog);


--
-- TOC entry 3677 (class 1259 OID 31212)
-- Name: fki_pdm_runtime__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE UNIQUE INDEX fki_pdm_runtime__pdm ON control.pdm_runtime USING btree (pdm_id);


--
-- TOC entry 3681 (class 1259 OID 30837)
-- Name: fki_pdm_status__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_pdm_status__pdm ON control.pdm_status USING btree (pds_log_id);


--
-- TOC entry 3686 (class 1259 OID 30838)
-- Name: fki_pdm_x_tariff_info__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_pdm_x_tariff_info__pdm ON control.pdm_x_tariff_info USING btree (pti_tariff_info_id);


--
-- TOC entry 3687 (class 1259 OID 30839)
-- Name: fki_pdm_x_tariff_info__tariff_info; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_pdm_x_tariff_info__tariff_info ON control.pdm_x_tariff_info USING btree (pti_tariff_info_id);


--
-- TOC entry 3692 (class 1259 OID 30840)
-- Name: fki_sw_description__area; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_sw_description__area ON control.software_description USING btree (swd_area_id);


--
-- TOC entry 3693 (class 1259 OID 30841)
-- Name: fki_sw_description__user; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_sw_description__user ON control.software_description USING btree (swd_author_id);


--
-- TOC entry 3714 (class 1259 OID 30843)
-- Name: fki_tarnslog_ext__translog-base; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX "fki_tarnslog_ext__translog-base" ON control.translog_ext USING btree (permit_base);


--
-- TOC entry 3707 (class 1259 OID 30844)
-- Name: fki_translog__pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_translog__pdm ON control.translog USING btree (tl_pdm_id);


--
-- TOC entry 3711 (class 1259 OID 30845)
-- Name: fki_translog_bonus__translog; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX fki_translog_bonus__translog ON control.translog_bonus USING btree (payment);


--
-- TOC entry 3535 (class 1259 OID 31214)
-- Name: idx_accu_level__al_date_time; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX idx_accu_level__al_date_time ON control.accu_level USING brin (al_date_time);


--
-- TOC entry 3552 (class 1259 OID 30847)
-- Name: idx_bonus_card__card_nr; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX idx_bonus_card__card_nr ON control.bonus_card_rule USING btree (sbd_card_nr);


--
-- TOC entry 3560 (class 1259 OID 30848)
-- Name: idx_bonus_counting_rule__zone_id; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX idx_bonus_counting_rule__zone_id ON control.bonus_counting_rule USING btree (zone_id);


--
-- TOC entry 3593 (class 1259 OID 30849)
-- Name: idx_bonus_lpn_mt2_rule__lpn_area; Type: INDEX; Schema: control; Owner: -
--

CREATE UNIQUE INDEX idx_bonus_lpn_mt2_rule__lpn_area ON control.bonus_lpn_mt2_rule USING btree (lpn, zone_id);


--
-- TOC entry 4018 (class 0 OID 0)
-- Dependencies: 3593
-- Name: INDEX idx_bonus_lpn_mt2_rule__lpn_area; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON INDEX control.idx_bonus_lpn_mt2_rule__lpn_area IS 'License plate number can be defined only once within a Zone.';


--
-- TOC entry 3589 (class 1259 OID 30850)
-- Name: idx_bonus_lpn_mt_entry_lpn; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX idx_bonus_lpn_mt_entry_lpn ON control.bonus_lpn_mt1_rule USING btree (lpn);


--
-- TOC entry 3635 (class 1259 OID 30851)
-- Name: idx_hw_device__part_sn; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX idx_hw_device__part_sn ON control.hw_device USING btree (part_sn);


--
-- TOC entry 3641 (class 1259 OID 30852)
-- Name: idx_logbook__date_pc; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX idx_logbook__date_pc ON control.logbook USING btree (log_date_pc);


--
-- TOC entry 3642 (class 1259 OID 30853)
-- Name: idx_logbook__date_pdm; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX idx_logbook__date_pdm ON control.logbook USING btree (log_date_pdm);


--
-- TOC entry 3652 (class 1259 OID 31213)
-- Name: idx_modem_login__pdm_time; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX idx_modem_login__pdm_time ON control.modem_login USING brin (mlg_pdm_time);


--
-- TOC entry 3663 (class 1259 OID 30855)
-- Name: idx_pdm_number; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX idx_pdm_number ON control.pdm USING btree (pdm_number);


--
-- TOC entry 3674 (class 1259 OID 30856)
-- Name: idx_pmd_log_message__log_pdm_time; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX idx_pmd_log_message__log_pdm_time ON control.pdm_log_message USING btree (log_pdm_time);


--
-- TOC entry 3708 (class 1259 OID 30857)
-- Name: idx_translog__pay_date_time; Type: INDEX; Schema: control; Owner: -
--

CREATE INDEX idx_translog__pay_date_time ON control.translog USING btree (tl_pay_date_time);


--
-- TOC entry 3726 (class 1259 OID 30858)
-- Name: idx_usr_user_id; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX idx_usr_user_id ON control.user_role USING btree (usr_user_id);


--
-- TOC entry 3723 (class 1259 OID 30859)
-- Name: uix_usa_login__pg_catalog; Type: INDEX; Schema: public; Owner: -
--

CREATE INDEX uix_usa_login__pg_catalog ON control.user_authentication USING btree (usa_login);


--
-- TOC entry 3733 (class 2606 OID 30860)
-- Name: accu_level fk_accu_level__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.accu_level
    ADD CONSTRAINT fk_accu_level__pdm FOREIGN KEY (al_pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3734 (class 2606 OID 30865)
-- Name: area_partner fk_area_service__area; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.area_partner
    ADD CONSTRAINT fk_area_service__area FOREIGN KEY (area_id) REFERENCES control.area(ac_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3735 (class 2606 OID 30870)
-- Name: area_x_user fk_area_x_user__area; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.area_x_user
    ADD CONSTRAINT fk_area_x_user__area FOREIGN KEY (area_id) REFERENCES control.area(ac_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3736 (class 2606 OID 30875)
-- Name: area_x_user fk_area_x_user__user; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.area_x_user
    ADD CONSTRAINT fk_area_x_user__user FOREIGN KEY (user_id) REFERENCES control.user_authentication(usa_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3738 (class 2606 OID 30880)
-- Name: bonus_card_rule fk_bonus_card_rule__type; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_card_rule
    ADD CONSTRAINT fk_bonus_card_rule__type FOREIGN KEY (sbd_type_id) REFERENCES control.bonus_card_type(sbt_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3739 (class 2606 OID 30885)
-- Name: bonus_card_type fk_bonus_card_type__zone; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_card_type
    ADD CONSTRAINT fk_bonus_card_type__zone FOREIGN KEY (sbt_zone_id) REFERENCES control.zone(zon_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3740 (class 2606 OID 30890)
-- Name: bonus_counting_rule fk_bonus_counting_rule__zone; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_counting_rule
    ADD CONSTRAINT fk_bonus_counting_rule__zone FOREIGN KEY (zone_id) REFERENCES control.zone(zon_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3741 (class 2606 OID 30895)
-- Name: bonus_counting_usage fk_bonus_counting_usage__rule; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_counting_usage
    ADD CONSTRAINT fk_bonus_counting_usage__rule FOREIGN KEY (config_id) REFERENCES control.bonus_counting_rule(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3742 (class 2606 OID 30900)
-- Name: bonus_disposable fk_bonus_disposable__payment; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_disposable
    ADD CONSTRAINT fk_bonus_disposable__payment FOREIGN KEY (payment_id) REFERENCES control.translog(tl_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3743 (class 2606 OID 30905)
-- Name: bonus_disposable fk_bonus_disposable__user; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_disposable
    ADD CONSTRAINT fk_bonus_disposable__user FOREIGN KEY (creator_id) REFERENCES control.user_authentication(usa_id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 3744 (class 2606 OID 30910)
-- Name: bonus_disposable fk_bonus_disposable__zone; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_disposable
    ADD CONSTRAINT fk_bonus_disposable__zone FOREIGN KEY (zone_id) REFERENCES control.zone(zon_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3737 (class 2606 OID 30915)
-- Name: bonus_lpn_basic1_config fk_bonus_lpn_common__zone; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_basic1_config
    ADD CONSTRAINT fk_bonus_lpn_common__zone FOREIGN KEY (id) REFERENCES control.zone(zon_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3745 (class 2606 OID 30920)
-- Name: bonus_lpn_basic1_exception fk_bonus_lpn_common_exception__bonus_lpn_common; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_basic1_exception
    ADD CONSTRAINT fk_bonus_lpn_common_exception__bonus_lpn_common FOREIGN KEY (bonus_id) REFERENCES control.bonus_lpn_basic1_config(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3746 (class 2606 OID 30925)
-- Name: bonus_lpn_basic1_rule fk_bonus_lpn_common_rule__bonus_lpn_common; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_basic1_rule
    ADD CONSTRAINT fk_bonus_lpn_common_rule__bonus_lpn_common FOREIGN KEY (bonus_id) REFERENCES control.bonus_lpn_basic1_config(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3747 (class 2606 OID 30930)
-- Name: bonus_lpn_basic2_config fk_bonus_lpn_individual__zone; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_basic2_config
    ADD CONSTRAINT fk_bonus_lpn_individual__zone FOREIGN KEY (id) REFERENCES control.zone(zon_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3750 (class 2606 OID 30935)
-- Name: bonus_lpn_mt2_rule fk_bonus_lpn_mt2_rule__zone; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_mt2_rule
    ADD CONSTRAINT fk_bonus_lpn_mt2_rule__zone FOREIGN KEY (zone_id) REFERENCES control.zone(zon_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3751 (class 2606 OID 30940)
-- Name: bonus_lpn_mt2_usage fk_bonus_lpn_mt2_usage__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_mt2_usage
    ADD CONSTRAINT fk_bonus_lpn_mt2_usage__pdm FOREIGN KEY (pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3748 (class 2606 OID 30945)
-- Name: bonus_lpn_mt1_rule fk_bonus_lpn_mt_entry__tariff_info; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_mt1_rule
    ADD CONSTRAINT fk_bonus_lpn_mt_entry__tariff_info FOREIGN KEY (tariff_info_id) REFERENCES control.tariff_info(tai_id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 3749 (class 2606 OID 30950)
-- Name: bonus_lpn_mt1_rule fk_bonus_lpn_mt_entry__zone; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_lpn_mt1_rule
    ADD CONSTRAINT fk_bonus_lpn_mt_entry__zone FOREIGN KEY (zone_id) REFERENCES control.zone(zon_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3752 (class 2606 OID 30955)
-- Name: bonus_psn_mt1_rule fk_bonus_psn_mt__zone; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_psn_mt1_rule
    ADD CONSTRAINT fk_bonus_psn_mt__zone FOREIGN KEY (zone_id) REFERENCES control.zone(zon_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3753 (class 2606 OID 30960)
-- Name: bonus_psn_mt1_rule fk_bonus_psn_mt_entry__tariff_info; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.bonus_psn_mt1_rule
    ADD CONSTRAINT fk_bonus_psn_mt_entry__tariff_info FOREIGN KEY (tariff_info_id) REFERENCES control.tariff_info(tai_id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 3754 (class 2606 OID 30965)
-- Name: cash_box_level fk_cache_cash_box_level__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.cash_box_level
    ADD CONSTRAINT fk_cache_cash_box_level__pdm FOREIGN KEY (pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3755 (class 2606 OID 30970)
-- Name: cash_box_item fk_cash_box_item__cash_kind; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.cash_box_item
    ADD CONSTRAINT fk_cash_box_item__cash_kind FOREIGN KEY (cbi_cash_kind_id) REFERENCES control.cash_kind(csk_id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 3756 (class 2606 OID 30975)
-- Name: clearing fk_clearing__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.clearing
    ADD CONSTRAINT fk_clearing__pdm FOREIGN KEY (clr_pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3757 (class 2606 OID 30980)
-- Name: download_entry fk_download_entry__download_plan; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.download_entry
    ADD CONSTRAINT fk_download_entry__download_plan FOREIGN KEY (dwe_plan_id) REFERENCES control.download_plan(dwp_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3758 (class 2606 OID 30985)
-- Name: download_entry fk_download_entry__logbook_act; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.download_entry
    ADD CONSTRAINT fk_download_entry__logbook_act FOREIGN KEY (dwe_file_activation_msg_id) REFERENCES control.logbook(log_id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- TOC entry 3759 (class 2606 OID 30990)
-- Name: download_entry fk_download_entry__logbook_dwn; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.download_entry
    ADD CONSTRAINT fk_download_entry__logbook_dwn FOREIGN KEY (dwe_file_download_msg_id) REFERENCES control.logbook(log_id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- TOC entry 3760 (class 2606 OID 30995)
-- Name: download_entry fk_download_entry__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.download_entry
    ADD CONSTRAINT fk_download_entry__pdm FOREIGN KEY (dwe_pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3761 (class 2606 OID 31000)
-- Name: download_plan fk_download_plan__area; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.download_plan
    ADD CONSTRAINT fk_download_plan__area FOREIGN KEY (dwp_area_id) REFERENCES control.area(ac_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3762 (class 2606 OID 31005)
-- Name: download_plan fk_download_plan__sw_description; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.download_plan
    ADD CONSTRAINT fk_download_plan__sw_description FOREIGN KEY (dwp_sw_desc_id) REFERENCES control.software_description(swd_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3763 (class 2606 OID 31010)
-- Name: download_plan fk_download_plan__user; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.download_plan
    ADD CONSTRAINT fk_download_plan__user FOREIGN KEY (dwp_modified_by) REFERENCES control.user_authentication(usa_id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 3764 (class 2606 OID 31015)
-- Name: forwarding_rule fk_forwarding_rule__areacode; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.forwarding_rule
    ADD CONSTRAINT fk_forwarding_rule__areacode FOREIGN KEY (fwr_area_id) REFERENCES control.area(ac_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3766 (class 2606 OID 31020)
-- Name: hw_device fk_hw_device__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.hw_device
    ADD CONSTRAINT fk_hw_device__pdm FOREIGN KEY (pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3767 (class 2606 OID 31025)
-- Name: hw_status fk_hw_status__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.hw_status
    ADD CONSTRAINT fk_hw_status__pdm FOREIGN KEY (hwr_pdm) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3768 (class 2606 OID 31030)
-- Name: logbook fk_logbook_pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.logbook
    ADD CONSTRAINT fk_logbook_pdm FOREIGN KEY (log_pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3769 (class 2606 OID 31035)
-- Name: message_config_user fk_message_config__area_code; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.message_config_user
    ADD CONSTRAINT fk_message_config__area_code FOREIGN KEY (msu_area_id) REFERENCES control.area(ac_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3770 (class 2606 OID 31040)
-- Name: modem_login fk_modem_login__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.modem_login
    ADD CONSTRAINT fk_modem_login__pdm FOREIGN KEY (mlg_pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3771 (class 2606 OID 31045)
-- Name: paper_role fk_paper_role__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.paper_role
    ADD CONSTRAINT fk_paper_role__pdm FOREIGN KEY (pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3772 (class 2606 OID 31050)
-- Name: paper_usage fk_paper_usage__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.paper_usage
    ADD CONSTRAINT fk_paper_usage__pdm FOREIGN KEY (pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3773 (class 2606 OID 31055)
-- Name: pdm fk_pdm__area; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm
    ADD CONSTRAINT fk_pdm__area FOREIGN KEY (pdm_area_id) REFERENCES control.area(ac_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3774 (class 2606 OID 31060)
-- Name: pdm fk_pdm__zone; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm
    ADD CONSTRAINT fk_pdm__zone FOREIGN KEY (pdm_zone_id) REFERENCES control.zone(zon_id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- TOC entry 3775 (class 2606 OID 31065)
-- Name: pdm_log_message fk_pdm_log_message__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_log_message
    ADD CONSTRAINT fk_pdm_log_message__pdm FOREIGN KEY (log_pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3776 (class 2606 OID 31070)
-- Name: pdm_log_message fk_pdm_log_message__pdm_log_catalog; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_log_message
    ADD CONSTRAINT fk_pdm_log_message__pdm_log_catalog FOREIGN KEY (log_catalog) REFERENCES control.pdm_log_catalog(id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 3777 (class 2606 OID 31075)
-- Name: pdm_runtime fk_pdm_runtime__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_runtime
    ADD CONSTRAINT fk_pdm_runtime__pdm FOREIGN KEY (pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3778 (class 2606 OID 31080)
-- Name: pdm_status fk_pdm_status__logbook; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_status
    ADD CONSTRAINT fk_pdm_status__logbook FOREIGN KEY (pds_log_id) REFERENCES control.logbook(log_id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 3779 (class 2606 OID 31085)
-- Name: pdm_status fk_pdm_status__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_status
    ADD CONSTRAINT fk_pdm_status__pdm FOREIGN KEY (pds_pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3780 (class 2606 OID 31090)
-- Name: pdm_status fk_pdm_status__user; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_status
    ADD CONSTRAINT fk_pdm_status__user FOREIGN KEY (pds_acquirer_id) REFERENCES control.user_authentication(usa_id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 3781 (class 2606 OID 31095)
-- Name: pdm_x_tariff_info fk_pdm_x_tariff_info__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_x_tariff_info
    ADD CONSTRAINT fk_pdm_x_tariff_info__pdm FOREIGN KEY (pti_pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3782 (class 2606 OID 31100)
-- Name: pdm_x_tariff_info fk_pdm_x_tariff_info__tariff_info; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.pdm_x_tariff_info
    ADD CONSTRAINT fk_pdm_x_tariff_info__tariff_info FOREIGN KEY (pti_tariff_info_id) REFERENCES control.tariff_info(tai_id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 3783 (class 2606 OID 31105)
-- Name: remote_action fk_remote_action__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.remote_action
    ADD CONSTRAINT fk_remote_action__pdm FOREIGN KEY (pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3784 (class 2606 OID 31110)
-- Name: remote_action fk_remote_action__status; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.remote_action
    ADD CONSTRAINT fk_remote_action__status FOREIGN KEY (status_id) REFERENCES control.logbook(log_id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- TOC entry 3785 (class 2606 OID 31115)
-- Name: remote_action fk_remote_action__user; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.remote_action
    ADD CONSTRAINT fk_remote_action__user FOREIGN KEY (user_id) REFERENCES control.user_authentication(usa_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3765 (class 2606 OID 31120)
-- Name: forwarding_rule fk_rule__user; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.forwarding_rule
    ADD CONSTRAINT fk_rule__user FOREIGN KEY (fwr_user_id) REFERENCES control.user_authentication(usa_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3788 (class 2606 OID 31125)
-- Name: software_path fk_software_item; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.software_path
    ADD CONSTRAINT fk_software_item FOREIGN KEY (swp_sws_id) REFERENCES control.software_item(sws_id) ON DELETE CASCADE;


--
-- TOC entry 3789 (class 2606 OID 31130)
-- Name: software_path fk_software_path__software_description; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.software_path
    ADD CONSTRAINT fk_software_path__software_description FOREIGN KEY (swp_swd_id) REFERENCES control.software_description(swd_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3786 (class 2606 OID 31135)
-- Name: software_description fk_sw_description__area; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.software_description
    ADD CONSTRAINT fk_sw_description__area FOREIGN KEY (swd_area_id) REFERENCES control.area(ac_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3787 (class 2606 OID 31140)
-- Name: software_description fk_sw_description__user; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.software_description
    ADD CONSTRAINT fk_sw_description__user FOREIGN KEY (swd_author_id) REFERENCES control.user_authentication(usa_id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 3794 (class 2606 OID 31150)
-- Name: translog_ext fk_tarnslog_ext__translog-base; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog_ext
    ADD CONSTRAINT "fk_tarnslog_ext__translog-base" FOREIGN KEY (permit_base) REFERENCES control.translog(tl_id) ON UPDATE CASCADE ON DELETE SET NULL;


--
-- TOC entry 4019 (class 0 OID 0)
-- Dependencies: 3794
-- Name: CONSTRAINT "fk_tarnslog_ext__translog-base" ON translog_ext; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON CONSTRAINT "fk_tarnslog_ext__translog-base" ON control.translog_ext IS 'Permit which is continued';


--
-- TOC entry 3795 (class 2606 OID 31155)
-- Name: translog_ext fk_tarnslog_ext__translog-ext; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog_ext
    ADD CONSTRAINT "fk_tarnslog_ext__translog-ext" FOREIGN KEY (permit_ext) REFERENCES control.translog(tl_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 4020 (class 0 OID 0)
-- Dependencies: 3795
-- Name: CONSTRAINT "fk_tarnslog_ext__translog-ext" ON translog_ext; Type: COMMENT; Schema: control; Owner: -
--

COMMENT ON CONSTRAINT "fk_tarnslog_ext__translog-ext" ON control.translog_ext IS 'Permit which is continues base permit';


--
-- TOC entry 3790 (class 2606 OID 31160)
-- Name: translog fk_translog__pdm; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog
    ADD CONSTRAINT fk_translog__pdm FOREIGN KEY (tl_pdm_id) REFERENCES control.pdm(pdm_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3791 (class 2606 OID 31165)
-- Name: translog fk_translog__tariff_info; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog
    ADD CONSTRAINT fk_translog__tariff_info FOREIGN KEY (tl_tariff_info_id) REFERENCES control.tariff_info(tai_id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 3792 (class 2606 OID 31170)
-- Name: translog fk_translog__translog_rtp; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog
    ADD CONSTRAINT fk_translog__translog_rtp FOREIGN KEY (tl_rtp_session) REFERENCES control.translog_rtp(id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 3793 (class 2606 OID 31175)
-- Name: translog_bonus fk_translog_bonus__payment; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.translog_bonus
    ADD CONSTRAINT fk_translog_bonus__payment FOREIGN KEY (payment) REFERENCES control.translog(tl_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3797 (class 2606 OID 31185)
-- Name: zone fk_zone__area; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.zone
    ADD CONSTRAINT fk_zone__area FOREIGN KEY (zon_area_id) REFERENCES control.area(ac_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3798 (class 2606 OID 31190)
-- Name: zone__perm_ext perm_ext__zone; Type: FK CONSTRAINT; Schema: control; Owner: -
--

ALTER TABLE ONLY control.zone__perm_ext
    ADD CONSTRAINT perm_ext__zone FOREIGN KEY (pex_id) REFERENCES control.zone(zon_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 3796 (class 2606 OID 31180)
-- Name: user_role fk_user_role__user_authentication; Type: FK CONSTRAINT; Schema: public; Owner: -
--

ALTER TABLE ONLY control.user_role
    ADD CONSTRAINT fk_user_role__user_authentication FOREIGN KEY (usr_user_id) REFERENCES control.user_authentication(usa_id) ON DELETE CASCADE;


--
-- PostgreSQL database dump complete
--


-- Initial data.

-- Administrator's account. User: 'admin', Password: 'admin'
INSERT INTO control.user_authentication (usa_login, usa_password, usa_enabled, usa_firstname, usa_lastname, usa_email, usa_timezone) VALUES ('admin', '{bcrypt}$2a$10$9zQsUgGnX2oyJSLs4lnegO9eq1gqpCCFuhfnx.FWiCJvP.hzocaYC', true, 'admin', '', '', 'Europe/Berlin');
-- Let the admin be administrator
INSERT INTO control.user_role (usr_user_id, usr_role)
VALUES
((SELECT MAX(usa_id) FROM control.user_authentication), 'ROLE_ADMIN_USERS'),
((SELECT MAX(usa_id) FROM control.user_authentication), 'ROLE_PCON_VIEW')
;

-- Create default area.
INSERT INTO control.area(ac_id, ac_description, ac_time_zone) VALUES (0, 'Default', 'Europe/Berlin');
-- Let admin access it.
INSERT INTO control.area_x_user(user_id, area_id) VALUES ((SELECT MAX(usa_id) FROM control.user_authentication), 0);
-- Add default message forwarding configuration
INSERT INTO control.message_config_default
(mcd_number, mcd_solve, mcd_alert, mcd_impact, mcd_manual, mcd_important)
VALUES
(0, NULL, 'NONE', 'POSITIVE', false, false),
(1, NULL, 'NONE', 'POSITIVE', false, false),
(2, NULL, 'NONE', 'POSITIVE', false, false),
(3, NULL, 'NONE', 'POSITIVE', false, false),
(4, NULL, 'NONE', 'POSITIVE', false, false),
(5, NULL, 'NONE', 'POSITIVE', false, false),
(6, NULL, 'NONE', 'POSITIVE', false, true),
(7, NULL, 'NONE', 'POSITIVE', false, false),
(8, 0, 'WARNING', 'NEGATIVE', false, false),
(9, 1, 'WARNING', 'NEGATIVE', false, false),
(10, 2, 'WARNING', 'NEGATIVE', false, false),
(11, 3, 'ERROR', 'NEGATIVE', false, false),
(12, 4, 'ERROR', 'NEGATIVE', false, false),
(13, 5, 'ERROR', 'NEGATIVE', false, false),
(14, 6, 'INFO', 'NEGATIVE', false, true),
(15, 7, 'ERROR', 'NEGATIVE', false, false),
(17, 4, 'ERROR', 'NEGATIVE', false, false),
(18, 1, 'ERROR', 'NEGATIVE', false, false),
(19, 4, 'ERROR', 'NEGATIVE', false, false),
(20, 1, 'ERROR', 'NEGATIVE', false, false),
(21, 1, 'ERROR', 'NEGATIVE', false, false),
(22, NULL, 'INFO', 'TRANSIENT', false, false),
(24, 5, 'ERROR', 'NEGATIVE', false, false),
(25, 5, 'ERROR', 'NEGATIVE', false, false),
(26, 5, 'ERROR', 'NEGATIVE', false, false),
(27, 5, 'ERROR', 'NEGATIVE', false, false),
(28, 5, 'ERROR', 'NEGATIVE', false, false),
(29, 5, 'ERROR', 'NEGATIVE', false, false),
(30, 5, 'ERROR', 'NEGATIVE', false, false),
(31, 5, 'ERROR', 'NEGATIVE', false, false),
(32, 4, 'ERROR', 'NEGATIVE', false, false),
(33, 4, 'ERROR', 'NEGATIVE', false, false),
(36, 5, 'ERROR', 'NEGATIVE', false, false),
(39, 4, 'ERROR', 'NEGATIVE', false, false),
(40, 4, 'ERROR', 'NEGATIVE', false, false),
(41, 5, 'ERROR', 'NEGATIVE', false, false),
(42, 5, 'WARNING', 'NEGATIVE', false, false),
(43, 0, 'WARNING', 'NEGATIVE', false, false),
(44, 5, 'ERROR', 'NEGATIVE', false, false),
(45, 5, 'WARNING', 'NEGATIVE', false, false),
(46, 7, 'ERROR', 'NEGATIVE', false, false),
(47, 7, 'ERROR', 'NEGATIVE', false, false),
(48, 5, 'WARNING', 'NEGATIVE', false, false),
(49, 4, 'WARNING', 'NEGATIVE', false, false),
(50, 3, 'ERROR', 'NEGATIVE', false, false),
(51, 3, 'ERROR', 'NEGATIVE', false, false),
(52, NULL, 'NONE', 'TRANSIENT', false, false),
(55, 56, 'CRITICAL', 'NEGATIVE', false, true),
(56, NULL, 'NONE', 'POSITIVE', false, true),
(58, NULL, 'NONE', 'POSITIVE', false, true),
(59, 60, 'ERROR', 'NEGATIVE', false, false),
(60, NULL, 'NONE', 'POSITIVE', false, false),
(61, 62, 'ERROR', 'NEGATIVE', false, true),
(62, NULL, 'NONE', 'POSITIVE', false, true),
(64, 67, 'CRITICAL', 'NEGATIVE', false, true),
(65, NULL, 'NONE', 'TRANSIENT', false, true),
(66, 67, 'CRITICAL', 'NEGATIVE', false, true),
(67, NULL, 'NONE', 'POSITIVE', false, true),
(68, 70, 'WARNING', 'NEGATIVE', false, true),
(69, 70, 'CRITICAL', 'NEGATIVE', false, true),
(70, NULL, 'NONE', 'POSITIVE', false, true),
(71, 72, 'ERROR', 'NEGATIVE', false, false),
(72, NULL, 'NONE', 'POSITIVE', false, false),
(73, 75, 'WARNING', 'NEGATIVE', false, true),
(74, 75, 'ERROR', 'NEGATIVE', false, true),
(75, NULL, 'NONE', 'POSITIVE', false, true),
(76, 77, 'ERROR', 'NEGATIVE', false, true),
(77, NULL, 'NONE', 'POSITIVE', false, true),
(78, 79, 'ERROR', 'NEGATIVE', false, true),
(79, NULL, 'NONE', 'POSITIVE', false, true),
(80, 81, 'ERROR', 'NEGATIVE', false, false),
(81, NULL, 'NONE', 'POSITIVE', false, false),
(82, 83, 'ERROR', 'NEGATIVE', false, true),
(83, NULL, 'NONE', 'POSITIVE', false, true),
(84, 85, 'ERROR', 'NEGATIVE', false, false),
(85, NULL, 'NONE', 'POSITIVE', false, false),
(86, 87, 'ERROR', 'NEGATIVE', false, false),
(87, NULL, 'NONE', 'POSITIVE', false, false),
(88, NULL, 'NONE', 'POSITIVE', false, false),
(89, NULL, 'NONE', 'POSITIVE', false, true),
(90, 93, 'INFO', 'NEGATIVE', false, false),
(91, NULL, 'NONE', 'POSITIVE', false, false),
(92, 93, 'WARNING', 'NEGATIVE', false, false),
(93, NULL, 'NONE', 'POSITIVE', false, false),
(95, 96, 'ERROR', 'NEGATIVE', false, false),
(96, NULL, 'NONE', 'POSITIVE', false, true),
(97, 67, 'WARNING', 'NEGATIVE', false, false),
(98, 7, 'INFO', 'NEGATIVE', false, false),
(99, 7, 'INFO', 'NEGATIVE', false, true),
(100, 105, 'ERROR', 'NEGATIVE', false, false),
(101, 96, 'WARNING', 'NEGATIVE', false, true),
(102, 107, 'WARNING', 'NEGATIVE', false, true),
(103, 107, 'ERROR', 'NEGATIVE', false, true),
(104, 105, 'ERROR', 'NEGATIVE', false, true),
(105, NULL, 'NONE', 'POSITIVE', false, true),
(106, 107, 'ERROR', 'NEGATIVE', false, true),
(107, NULL, 'NONE', 'POSITIVE', false, true),
(108, 93, 'WARNING', 'NEGATIVE', false, false),
(109, 110, 'WARNING', 'NEGATIVE', false, false),
(110, NULL, 'NONE', 'POSITIVE', false, false),
(111, NULL, 'INFO', 'TRANSIENT', false, false),
(113, 114, 'INFO', 'NEGATIVE', false, false),
(114, NULL, 'NONE', 'POSITIVE', false, false),
(115, 56, 'WARNING', 'NEGATIVE', false, false),
(116, 117, 'ERROR', 'NEGATIVE', false, false),
(117, NULL, 'NONE', 'POSITIVE', false, false),
(118, NULL, 'INFO', 'TRANSIENT', false, false),
(119, NULL, 'ERROR', 'TRANSIENT', false, false),
(120, 56, 'ERROR', 'NEGATIVE', false, false),
(121, 122, 'INFO', 'NEGATIVE', false, true),
(122, NULL, 'NONE', 'POSITIVE', false, true),
(123, NULL, 'INFO', 'TRANSIENT', false, false),
(124, NULL, 'NONE', 'TRANSIENT', false, false),
(125, NULL, 'NONE', 'TRANSIENT', false, false),
(126, 127, 'WARNING', 'NEGATIVE', false, true),
(127, NULL, 'NONE', 'POSITIVE', false, true),
(128, 129, 'WARNING', 'NEGATIVE', false, true),
(129, NULL, 'NONE', 'POSITIVE', false, true),
(130, 131, 'ERROR', 'NEGATIVE', false, true),
(131, NULL, 'NONE', 'POSITIVE', false, true),
(132, NULL, 'ERROR', 'TRANSIENT', false, true),
(133, NULL, 'INFO', 'TRANSIENT', false, true),
(134, NULL, 'NONE', 'POSITIVE', false, true),
(135, 134, 'ERROR', 'NEGATIVE', false, true),
(136, NULL, 'ERROR', 'TRANSIENT', false, true),
(137, NULL, 'INFO', 'TRANSIENT', false, true),
(138, NULL, 'INFO', 'TRANSIENT', false, true),
(139, 140, 'WARNING', 'NEGATIVE', true, true),
(140, NULL, 'NONE', 'POSITIVE', false, true),
(141, NULL, 'NONE', 'POSITIVE', false, true),
(142, 141, 'ERROR', 'NEGATIVE', false, true),
(143, 141, 'ERROR', 'NEGATIVE', false, true),
(144, NULL, 'INFO', 'TRANSIENT', false, true),
(145, 141, 'ERROR', 'NEGATIVE', false, true),
(147, 148, 'ERROR', 'NEGATIVE', false, false),
(148, NULL, 'NONE', 'POSITIVE', false, false),
(149, 150, 'WARNING', 'NEGATIVE', false, false),
(150, NULL, 'NONE', 'POSITIVE', false, false),
(151, NULL, 'INFO', 'TRANSIENT', false, false),
(152, 150, 'ERROR', 'NEGATIVE', false, false),
(153, NULL, 'INFO', 'TRANSIENT', false, false),
(154, NULL, 'INFO', 'TRANSIENT', false, false),
(155, 156, 'ERROR', 'NEGATIVE', false, false),
(156, NULL, 'NONE', 'POSITIVE', false, false),
(157, 234, 'WARNING', 'NEGATIVE', false, false),
(158, NULL, 'NONE', 'TRANSIENT', false, false),
(160, 162, 'ERROR', 'NEGATIVE', false, false),
(161, 162, 'WARNING', 'NEGATIVE', false, false),
(162, NULL, 'NONE', 'POSITIVE', false, false),
(163, 165, 'ERROR', 'NEGATIVE', false, true),
(164, 165, 'INFO', 'NEGATIVE', false, true),
(165, NULL, 'NONE', 'POSITIVE', false, true),
(166, NULL, 'NONE', 'POSITIVE', false, true),
(167, 166, 'ERROR', 'NEGATIVE', false, true),
(168, NULL, 'ERROR', 'TRANSIENT', false, true),
(169, NULL, 'INFO', 'TRANSIENT', false, false),
(170, NULL, 'INFO', 'TRANSIENT', false, false),
(171, NULL, 'INFO', 'TRANSIENT', false, true),
(172, NULL, 'INFO', 'TRANSIENT', false, true),
(173, 67, 'ERROR', 'NEGATIVE', false, true),
(174, 67, 'ERROR', 'NEGATIVE', false, true),
(175, 67, 'ERROR', 'NEGATIVE', false, true),
(176, 67, 'ERROR', 'NEGATIVE', false, true),
(178, NULL, 'INFO', 'TRANSIENT', false, false),
(180, NULL, 'INFO', 'TRANSIENT', false, false),
(185, NULL, 'INFO', 'TRANSIENT', false, false),
(188, NULL, 'WARNING', 'TRANSIENT', false, false),
(190, NULL, 'INFO', 'TRANSIENT', false, false),
(191, NULL, 'NONE', 'TRANSIENT', false, false),
(193, NULL, 'INFO', 'TRANSIENT', false, false),
(194, NULL, 'INFO', 'TRANSIENT', false, true),
(195, NULL, 'INFO', 'TRANSIENT', false, true),
(196, NULL, 'INFO', 'TRANSIENT', false, true),
(197, 198, 'ERROR', 'NEGATIVE', false, true),
(198, NULL, 'NONE', 'POSITIVE', false, true),
(199, NULL, 'INFO', 'TRANSIENT', false, true),
(200, 201, 'WARNING', 'NEGATIVE', false, true),
(201, NULL, 'NONE', 'POSITIVE', false, true),
(202, 203, 'INFO', 'NEGATIVE', false, true),
(192, NULL, 'ERROR', 'TRANSIENT', false, true),
(203, NULL, 'NONE', 'POSITIVE', false, true),
(63, 67, 'WARNING', 'NEGATIVE', false, true),
(57, 58, 'CRITICAL', 'NEGATIVE', false, true),
(204, 205, 'CRITICAL', 'NEGATIVE', false, true),
(205, NULL, 'NONE', 'POSITIVE', false, true),
(206, NULL, 'INFO', 'TRANSIENT', false, true),
(207, NULL, 'INFO', 'TRANSIENT', false, true),
(208, NULL, 'INFO', 'TRANSIENT', false, true),
(209, NULL, 'INFO', 'TRANSIENT', false, true),
(210, NULL, 'INFO', 'TRANSIENT', false, true),
(211, NULL, 'INFO', 'TRANSIENT', false, true),
(212, NULL, 'INFO', 'TRANSIENT', false, true),
(213, NULL, 'INFO', 'TRANSIENT', false, true),
(214, NULL, 'INFO', 'TRANSIENT', false, true),
(215, NULL, 'INFO', 'TRANSIENT', false, true),
(216, NULL, 'INFO', 'TRANSIENT', false, true),
(219, NULL, 'INFO', 'TRANSIENT', true, true),
(220, 222, 'WARNING', 'NEGATIVE', false, true),
(221, 114, 'WARNING', 'NEGATIVE', false, false),
(222, NULL, 'NONE', 'POSITIVE', false, true),
(223, 224, 'WARNING', 'NEGATIVE', false, true),
(224, NULL, 'NONE', 'POSITIVE', false, true),
(225, 226, 'INFO', 'NEGATIVE', false, true),
(226, NULL, 'NONE', 'POSITIVE', false, true),
(227, NULL, 'INFO', 'TRANSIENT', false, true),
(228, NULL, 'INFO', 'TRANSIENT', false, false),
(229, NULL, 'INFO', 'TRANSIENT', false, false),
(230, NULL, 'INFO', 'TRANSIENT', false, false),
(231, 56, 'ERROR', 'NEGATIVE', false, false),
(232, 156, 'WARNING', 'NEGATIVE', false, false),
(233, NULL, 'INFO', 'TRANSIENT', false, false),
(234, NULL, 'NONE', 'POSITIVE', false, false),
(235, 91, 'WARNING', 'NEGATIVE', false, false),
(236, 249, 'INFO', 'NEGATIVE', false, false),
(237, 114, 'WARNING', 'NEGATIVE', false, false),
(238, 114, 'WARNING', 'NEGATIVE', false, false),
(239, NULL, 'NONE', 'TRANSIENT', false, false),
(240, 241, 'WARNING', 'NEGATIVE', false, false),
(241, NULL, 'NONE', 'POSITIVE', false, false),
(242, NULL, 'INFO', 'TRANSIENT', false, false),
(243, NULL, 'NONE', 'TRANSIENT', false, false),
(244, NULL, 'INFO', 'TRANSIENT', false, false),
(245, NULL, 'NONE', 'TRANSIENT', false, false),
(246, 88, 'WARNING', 'NEGATIVE', false, false),
(247, 88, 'ERROR', 'NEGATIVE', false, false),
(248, 249, 'WARNING', 'NEGATIVE', false, false),
(249, NULL, 'NONE', 'POSITIVE', false, false),
(250, NULL, 'NONE', 'POSITIVE', false, false),
(251, 250, 'ERROR', 'NEGATIVE', false, false),
(252, NULL, 'INFO', 'TRANSIENT', false, false),
(253, NULL, 'INFO', 'TRANSIENT', false, false),
(254, NULL, 'NONE', 'POSITIVE', false, false),
(255, 254, 'WARNING', 'NEGATIVE', false, false),
(256, 257, 'ERROR', 'NEGATIVE', true, true),
(257, NULL, 'NONE', 'POSITIVE', false, false),
(258, NULL, 'ERROR', 'NEGATIVE', true, true),
(259, NULL, 'NONE', 'TRANSIENT', false, false),
(260, 257, 'WARNING', 'NEGATIVE', false, false),
(261, 56, 'WARNING', 'NEGATIVE', false, true),
(270, 272, 'ERROR', 'NEGATIVE', true, true),
(271, 272, 'WARNING', 'NEGATIVE', true, true),
(272, NULL, 'NONE', 'POSITIVE', false, true),
(280, 282, 'WARNING', 'NEGATIVE', false, false),
(282, NULL, 'NONE', 'POSITIVE', false, false),
(300, 7, 'WARNING', 'NEGATIVE', false, false),
(301, 7, 'WARNING', 'NEGATIVE', false, false),
(302, 7, 'WARNING', 'NEGATIVE', false, false),
(303, 7, 'WARNING', 'NEGATIVE', false, false),
(304, 7, 'WARNING', 'NEGATIVE', false, false),
(305, 7, 'WARNING', 'NEGATIVE', false, false),
(306, 7, 'WARNING', 'NEGATIVE', false, false),
(307, 7, 'WARNING', 'NEGATIVE', false, false),
(308, 7, 'WARNING', 'NEGATIVE', false, false),
(309, 7, 'WARNING', 'NEGATIVE', false, false),
(310, 7, 'WARNING', 'NEGATIVE', false, false),
(311, 7, 'WARNING', 'NEGATIVE', false, false),
(312, 7, 'WARNING', 'NEGATIVE', false, false),
(313, 7, 'WARNING', 'NEGATIVE', false, false),
(314, 7, 'WARNING', 'NEGATIVE', false, false),
(315, 7, 'WARNING', 'NEGATIVE', false, false),
(316, 7, 'WARNING', 'NEGATIVE', false, false),
(317, 7, 'WARNING', 'NEGATIVE', false, false),
(318, 7, 'WARNING', 'NEGATIVE', false, false),
(319, 7, 'WARNING', 'NEGATIVE', false, false),
(320, 56, 'WARNING', 'NEGATIVE', false, false),
(321, 56, 'WARNING', 'NEGATIVE', false, false),
(322, 56, 'WARNING', 'NEGATIVE', false, false),
(325, NULL, 'INFO', 'TRANSIENT', false, false),
(328, 56, 'WARNING', 'NEGATIVE', false, false),
(329, 56, 'WARNING', 'NEGATIVE', false, false),
(338, 56, 'WARNING', 'NEGATIVE', false, false),
(339, 56, 'WARNING', 'NEGATIVE', false, false),
(340, 58, 'WARNING', 'NEGATIVE', false, false),
(341, 58, 'WARNING', 'NEGATIVE', false, false),
(342, 58, 'WARNING', 'NEGATIVE', false, false),
(345, NULL, 'ERROR', 'TRANSIENT', false, false),
(358, 58, 'WARNING', 'NEGATIVE', false, false),
(359, 58, 'WARNING', 'NEGATIVE', false, false),
(401, 93, 'WARNING', 'NEGATIVE', false, false),
(402, 93, 'WARNING', 'NEGATIVE', false, false),
(403, 93, 'WARNING', 'NEGATIVE', false, false),
(404, 93, 'WARNING', 'NEGATIVE', false, false),
(405, 93, 'WARNING', 'NEGATIVE', false, false),
(406, 93, 'WARNING', 'NEGATIVE', false, false),
(407, 93, 'WARNING', 'NEGATIVE', false, false),
(408, 93, 'WARNING', 'NEGATIVE', false, false),
(409, 93, 'WARNING', 'NEGATIVE', false, false),
(410, 93, 'WARNING', 'NEGATIVE', false, false),
(411, 93, 'WARNING', 'NEGATIVE', false, false),
(412, 93, 'WARNING', 'NEGATIVE', false, false),
(413, 93, 'WARNING', 'NEGATIVE', false, false),
(414, 93, 'WARNING', 'NEGATIVE', false, false),
(499, 93, 'WARNING', 'NEGATIVE', false, false),
(500, 501, 'WARNING', 'NEGATIVE', false, false),
(501, NULL, 'NONE', 'POSITIVE', false, false),
(511, 512, 'INFO', 'NEGATIVE', false, false),
(512, NULL, 'NONE', 'POSITIVE', false, false),
(513, 514, 'WARNING', 'NEGATIVE', false, false),
(514, NULL, 'NONE', 'POSITIVE', false, false),
(515, 516, 'WARNING', 'NEGATIVE', false, false),
(516, NULL, 'NONE', 'POSITIVE', false, false),
(517, 518, 'WARNING', 'NEGATIVE', false, false),
(518, NULL, 'NONE', 'POSITIVE', false, false),
(519, 520, 'WARNING', 'NEGATIVE', false, false),
(520, NULL, 'NONE', 'POSITIVE', false, false),
(521, 522, 'INFO', 'NEGATIVE', false, false),
(522, NULL, 'NONE', 'POSITIVE', false, false),
(664, 665, 'WARNING', 'NEGATIVE', false, true),
(665, NULL, 'NONE', 'POSITIVE', false, true),
(667, NULL, 'WARNING', 'TRANSIENT', false, false),
(668, 669, 'WARNING', 'NEGATIVE', false, false),
(669, NULL, 'NONE', 'POSITIVE', false, false),
(670, NULL, 'ERROR', 'TRANSIENT', false, false),
(672, NULL, 'NONE', 'POSITIVE', false, false),
(900, NULL, 'INFO', 'TRANSIENT', false, false),
(995, NULL, 'NONE', 'POSITIVE', false, true),
(996, 89, 'WARNING', 'NEGATIVE', false, true),
(997, NULL, 'NONE', 'POSITIVE', false, true),
(998, 997, 'ERROR', 'NEGATIVE', false, true),
(999, NULL, 'NONE', 'TRANSIENT', false, false),
(1000, 1001, 'WARNING', 'NEGATIVE', true, false),
(1001, NULL, 'NONE', 'POSITIVE', false, false),
(1002, 1005, 'WARNING', 'NEGATIVE', true, false),
(1003, NULL, 'NONE', 'TRANSIENT', false, false),
(1004, 1005, 'WARNING', 'NEGATIVE', true, false),
(1005, NULL, 'NONE', 'POSITIVE', false, false),
(1006, 1007, 'WARNING', 'NEGATIVE', true, false),
(1007, NULL, 'NONE', 'POSITIVE', false, false),
(1008, 1009, 'WARNING', 'NEGATIVE', true, false),
(1009, NULL, 'NONE', 'POSITIVE', false, false),
(1010, 1011, 'WARNING', 'NEGATIVE', true, false),
(1011, NULL, 'NONE', 'POSITIVE', false, false),
(1098, 1099, 'WARNING', 'NEGATIVE', true, false),
(1099, NULL, 'NONE', 'POSITIVE', false, false),
(1100, 1198, 'WARNING', 'NEGATIVE', false, false),
(1110, 1198, 'WARNING', 'NEGATIVE', false, false),
(1111, NULL, 'NONE', 'TRANSIENT', false, false),
(1112, NULL, 'NONE', 'TRANSIENT', false, false),
(1113, NULL, 'WARNING', 'TRANSIENT', false, false),
(1114, NULL, 'WARNING', 'TRANSIENT', false, false),
(1115, NULL, 'WARNING', 'TRANSIENT', false, false),
(1116, NULL, 'WARNING', 'TRANSIENT', false, false),
(1117, NULL, 'WARNING', 'TRANSIENT', false, false),
(1118, NULL, 'WARNING', 'TRANSIENT', false, false),
(1119, NULL, 'WARNING', 'TRANSIENT', false, false),
(1120, 1198, 'WARNING', 'NEGATIVE', false, false),
(1121, NULL, 'WARNING', 'TRANSIENT', false, false),
(1122, NULL, 'WARNING', 'TRANSIENT', false, false),
(1123, NULL, 'WARNING', 'TRANSIENT', false, false),
(1130, 1198, 'INFO', 'NEGATIVE', false, false),
(1198, NULL, 'NONE', 'POSITIVE', false, false),
(1199, NULL, 'NONE', 'TRANSIENT', false, false),
(1200, NULL, 'ERROR', 'TRANSIENT', false, false),
(1201, NULL, 'ERROR', 'TRANSIENT', false, false),
(5000, 5001, 'ERROR', 'NEGATIVE', false, false),
(5001, NULL, 'NONE', 'POSITIVE', false, false),
(5002, NULL, 'INFO', 'TRANSIENT', false, false),
(5003, NULL, 'INFO', 'TRANSIENT', false, false),
(5004, NULL, 'INFO', 'TRANSIENT', false, false),
(5005, NULL, 'INFO', 'TRANSIENT', false, false),
(5006, NULL, 'INFO', 'TRANSIENT', false, false),
(5007, NULL, 'INFO', 'TRANSIENT', false, false),
(5008, NULL, 'INFO', 'TRANSIENT', false, false),
(5009, NULL, 'INFO', 'TRANSIENT', false, false),
(5010, NULL, 'INFO', 'TRANSIENT', false, false),
(5011, NULL, 'INFO', 'TRANSIENT', false, false),
(217, 96, 'ERROR', 'NEGATIVE', false, true),
(671, 672, 'WARNING', 'NEGATIVE', false, false),
(5012, NULL, 'INFO', 'TRANSIENT', false, false),
(5013, NULL, 'INFO', 'TRANSIENT', false, false),
(5014, NULL, 'INFO', 'TRANSIENT', false, false),
(5015, NULL, 'INFO', 'TRANSIENT', false, false),
(5016, NULL, 'INFO', 'TRANSIENT', false, false),
(5017, NULL, 'INFO', 'TRANSIENT', false, false),
(5018, NULL, 'INFO', 'TRANSIENT', false, false),
(5019, NULL, 'INFO', 'TRANSIENT', false, false),
(5020, NULL, 'INFO', 'TRANSIENT', false, false),
(5021, NULL, 'INFO', 'TRANSIENT', false, false),
(5022, NULL, 'INFO', 'TRANSIENT', false, false),
(5023, NULL, 'INFO', 'TRANSIENT', false, false),
(5024, NULL, 'INFO', 'TRANSIENT', false, false),
(5025, NULL, 'INFO', 'TRANSIENT', false, false),
(5026, NULL, 'INFO', 'TRANSIENT', false, false),
(5027, NULL, 'INFO', 'TRANSIENT', false, false),
(5028, NULL, 'INFO', 'TRANSIENT', false, false),
(5029, NULL, 'INFO', 'TRANSIENT', false, false),
(5030, NULL, 'INFO', 'TRANSIENT', false, false),
(5031, NULL, 'INFO', 'TRANSIENT', false, false),
(5032, NULL, 'INFO', 'TRANSIENT', false, false),
(5033, NULL, 'INFO', 'TRANSIENT', false, false),
(5034, NULL, 'INFO', 'TRANSIENT', false, false),
(6000, NULL, 'INFO', 'TRANSIENT', false, false),
(6001, 203, 'ERROR', 'NEGATIVE', false, false),
(6002, 203, 'ERROR', 'NEGATIVE', false, false),
(6100, NULL, 'INFO', 'TRANSIENT', false, false),
(6101, NULL, 'INFO', 'TRANSIENT', false, false),
(6102, NULL, 'INFO', 'TRANSIENT', false, false),
(6200, NULL, 'INFO', 'TRANSIENT', false, false),
(6201, NULL, 'INFO', 'TRANSIENT', false, false),
(112, 159, 'INFO', 'NEGATIVE', false, false),
(159, NULL, 'NONE', 'POSITIVE', false, false),
(218, 995, 'ERROR', 'NEGATIVE', true, true),
(94, 96, 'ERROR', 'NEGATIVE', false, true),
(361, NULL, 'NEW', 'TRANSIENT', false, false),
(362, NULL, 'NEW', 'TRANSIENT', false, false),
(673, 674, 'INFO', 'NEGATIVE', false, false),
(674, NULL, 'NONE', 'POSITIVE', false, false),
(656, NULL, 'INFO', 'TRANSIENT', false, false),
(675, 676, 'INFO', 'NEGATIVE', false, false),
(676, NULL, 'NONE', 'POSITIVE', false, false),
(677, NULL, 'INFO', 'TRANSIENT', false, false),
(678, 272, 'ERROR', 'NEGATIVE', false, false),
(680, NULL, 'ERROR', 'TRANSIENT', false, false),
(700, NULL, 'ERROR', 'TRANSIENT', false, false),
(701, NULL, 'NONE', 'TRANSIENT', false, false),
(702, NULL, 'NONE', 'TRANSIENT', false, false),
(703, NULL, 'NONE', 'TRANSIENT', false, false),
(704, NULL, 'NONE', 'TRANSIENT', false, false),
(705, NULL, 'NONE', 'TRANSIENT', false, false),
(706, NULL, 'NONE', 'TRANSIENT', false, false),
(707, NULL, 'NONE', 'TRANSIENT', false, false),
(708, NULL, 'NONE', 'TRANSIENT', false, false),
(681, NULL, 'NONE', 'POSITIVE', false, false),
(679, 681, 'ERROR', 'NEGATIVE', false, false),
(682, NULL, 'NONE', 'POSITIVE', false, false),
(683, 682, 'ERROR', 'NEGATIVE', false, false),
(687, NULL, 'NONE', 'POSITIVE', false, false),
(686, 687, 'ERROR', 'NEGATIVE', false, false),
(688, NULL, 'INFO', 'TRANSIENT', false, false),
(1301, NULL, 'NONE', 'POSITIVE', false, true),
(1300, 1301, 'WARNING', 'NEGATIVE', false, true),
(690, NULL, 'NONE', 'POSITIVE', false, false),
(689, 690, 'WARNING', 'NEGATIVE', false, false),
(692, NULL, 'NONE', 'POSITIVE', false, false),
(691, 692, 'WARNING', 'NEGATIVE', false, false),
(901, NULL, 'WARNING', 'TRANSIENT', false, false),
(902, NULL, 'WARNING', 'TRANSIENT', false, false),
(903, NULL, 'WARNING', 'TRANSIENT', false, false),
(905, NULL, 'WARNING', 'TRANSIENT', false, false),
(262, 96, 'ERROR', 'NEGATIVE', false, false),
(904, NULL, 'WARNING', 'TRANSIENT', false, false),
(693, NULL, 'INFO', 'TRANSIENT', false, false),
(694, NULL, 'WARNING', 'TRANSIENT', false, false),
(781, NULL, 'NONE', 'TRANSIENT', false, false),
(275, NULL, 'NONE', 'POSITIVE', false, false),
(273, 275, 'WARNING', 'NEGATIVE', false, false),
(274, 275, 'INFO', 'NEGATIVE', false, false),
(278, NULL, 'NONE', 'POSITIVE', false, false),
(276, 278, 'WARNING', 'NEGATIVE', false, false),
(277, 278, 'INFO', 'NEGATIVE', false, false),
(502, 134, 'ERROR', 'NEGATIVE', false, false),
(264, NULL, 'NONE', 'POSITIVE', false, false),
(263, 264, 'WARNING', 'NEGATIVE', false, false),
(906, NULL, 'INFO', 'TRANSIENT', false, false),
(661, 67, 'ERROR', 'NEGATIVE', false, false),
(666, NULL, 'NEW', 'TRANSIENT', false, false),
(737, NULL, 'NONE', 'TRANSIENT', false, false),
(782, NULL, 'NONE', 'TRANSIENT', false, false),
(783, NULL, 'NONE', 'TRANSIENT', false, false),
(784, NULL, 'NONE', 'TRANSIENT', false, false),
(785, NULL, 'NONE', 'TRANSIENT', false, false),
(786, NULL, 'NONE', 'TRANSIENT', false, false),
(179, NULL, 'INFO', 'TRANSIENT', false, false),
(733, NULL, 'NONE', 'TRANSIENT', false, false),
(695, NULL, 'ERROR', 'TRANSIENT', false, false),
(732, NULL, 'NEW', 'TRANSIENT', false, false),
(760, NULL, 'NEW', 'TRANSIENT', false, false),
(761, NULL, 'NEW', 'TRANSIENT', false, false),
(762, NULL, 'NEW', 'TRANSIENT', false, false),
(530, NULL, 'INFO', 'TRANSIENT', false, false),
(531, NULL, 'INFO', 'TRANSIENT', false, false),
(532, NULL, 'INFO', 'TRANSIENT', false, false),
(741, NULL, 'NONE', 'TRANSIENT', false, false),
(742, NULL, 'INFO', 'TRANSIENT', false, false),
(743, NULL, 'INFO', 'TRANSIENT', false, false),
(744, NULL, 'INFO', 'TRANSIENT', false, false),
(745, NULL, 'INFO', 'TRANSIENT', false, false),
(746, NULL, 'INFO', 'TRANSIENT', false, false),
(787, NULL, 'INFO', 'TRANSIENT', false, false),
(763, NULL, 'NEW', 'TRANSIENT', false, false),
(764, NULL, 'NEW', 'TRANSIENT', false, false),
(684, NULL, 'ERROR', 'TRANSIENT', false, false),
(685, NULL, 'ERROR', 'TRANSIENT', false, false),
(747, NULL, 'NONE', 'TRANSIENT', false, false),
(748, NULL, 'NONE', 'TRANSIENT', false, false),
(364, 141, 'ERROR', 'NEGATIVE', false, false),
(365, 141, 'ERROR', 'NEGATIVE', false, false);
