/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcontrol.utils;

import de.rtb.pcontrol.utils.StopWatch;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.iterators.ArrayIterator;
import org.springframework.util.StopWatch;

public class StopWatch
extends org.springframework.util.StopWatch {
    private List<TimingHeader> aditionalTimingHeaders = new LinkedList();

    public StopWatch() {
        super("");
    }

    public StopWatch(String id) {
        super(id);
    }

    public String shortSummaryNs() {
        return super.shortSummary();
    }

    public String shortSummary() {
        return "StopWatch '" + this.getId() + "': running time = " + this.getTotalTimeMillis() + " ms";
    }

    public String prettyPrintNs() {
        return super.prettyPrint();
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder(this.shortSummary());
        sb.append('\n');
        sb.append("---------------------------------------------\n");
        sb.append("ms         %     Task name\n");
        sb.append("---------------------------------------------\n");
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumIntegerDigits(9);
        nf.setGroupingUsed(false);
        NumberFormat pf = NumberFormat.getPercentInstance();
        pf.setMinimumIntegerDigits(3);
        pf.setGroupingUsed(false);
        for (StopWatch.TaskInfo task : this.getTaskInfo()) {
            sb.append(nf.format(task.getTimeMillis())).append("  ");
            sb.append(pf.format((double)task.getTimeNanos() / (double)this.getTotalTimeNanos())).append("  ");
            sb.append(task.getTaskName()).append("\n");
        }
        return sb.toString();
    }

    public String toServerTiming() {
        StringBuilder sb = new StringBuilder();
        ArrayIterator tasks = new ArrayIterator((Object)this.getTaskInfo());
        while (tasks.hasNext()) {
            StopWatch.TaskInfo task = (StopWatch.TaskInfo)tasks.next();
            String metric = new TimingHeader(task.getTaskName(), Long.valueOf(task.getTimeNanos())).toString();
            sb.append(metric);
            if (!tasks.hasNext()) continue;
            sb.append(", ");
        }
        if (!this.aditionalTimingHeaders.isEmpty()) {
            sb.append(", ");
            Iterator custom = this.aditionalTimingHeaders.iterator();
            while (custom.hasNext()) {
                sb.append(custom.next());
                if (!custom.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    public void addTimingInfo(String name) {
        this.aditionalTimingHeaders.add(new TimingHeader(name));
    }

    public void switchTask(String taskName) {
        this.stop();
        this.start(taskName);
    }
}

