/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcontrol.utils;

import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.node.DiffNode;
import de.rtb.pcon.features.bonus.BonusValue;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.download.DownloadPlan;
import de.rtb.pcon.model.msgfw.MessageForwardingRule;
import de.rtb.pcon.model.zone.Zone;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoggerUtils {
    private LoggerUtils() {
    }

    public static final String log(Zone z) {
        return LoggerUtils.log((Zone)z, null);
    }

    public static final String log(Zone z, Integer id) {
        if (z != null) {
            return "zone {#" + z.getId() + " '" + z.getName() + "'}";
        }
        return "zone {#" + id + "}";
    }

    public static final String log(Pdm p) {
        return LoggerUtils.log((Pdm)p, null);
    }

    public static final String log(Area a, Integer id) {
        if (a != null) {
            return "area {#" + a.getId() + " (" + a.getName() + ")}";
        }
        return "area {#" + id + "}";
    }

    public static final String log(Area a) {
        return LoggerUtils.log((Area)a, null);
    }

    public static final String log(Pdm p, Integer id) {
        if (p != null) {
            return "pdm {#" + p.getId() + " '" + p.getNumber() + "' (" + p.getName() + ")}";
        }
        return "pdm {#" + id + "}";
    }

    public static final String logPdmAndArea(Pdm pdm) {
        if (pdm == null) {
            return "?@?";
        }
        if (pdm.getZone().getArea() == null) {
            return pdm.getNumber() + "@?";
        }
        return pdm.getNumber() + "@" + pdm.getZone().getArea().getId();
    }

    public static final String log(User u) {
        return LoggerUtils.log((User)u, null);
    }

    public static final Supplier<String> logUserArg(User user) {
        return () -> LoggerUtils.log((User)user);
    }

    public static final String log(User u, Long id) {
        if (u != null) {
            return "user {#" + u.getId() + " '" + u.getLogin() + "' (" + u.getFirstName() + " " + u.getLastName() + ")}";
        }
        return "user {#" + id + "}";
    }

    public static final String log(MessageForwardingRule r) {
        return LoggerUtils.log((MessageForwardingRule)r, null);
    }

    public static final String log(MessageForwardingRule r, Long id) {
        if (r != null) {
            return "msgfw rule {#" + r.getId() + " '" + r.getName() + "'}";
        }
        return "msgfw rule {#" + id + "}";
    }

    public static final String log(DownloadPlan dp, Integer id) {
        if (dp != null) {
            return "download plan {#" + dp.getId() + " '" + dp.getName() + "'}";
        }
        return "download plan {#" + id + "}";
    }

    public static final String log(DownloadPlan dp) {
        return LoggerUtils.log((DownloadPlan)dp, null);
    }

    public static final String log(BonusValue val) {
        StringBuilder result = new StringBuilder();
        if (val.getDuration() != null && val.getDuration().compareTo(Duration.ZERO) > 0) {
            result.append(val.getDuration());
        }
        if (val.getPrice() != null && val.getPrice().compareTo(BigDecimal.ZERO) > 0 && result.length() > 0) {
            result.append(" + ");
            result.append(val.getPrice());
        }
        return result.toString();
    }

    public static final <T> String makeObjectDiff(T working, T base) {
        DiffNode diff = ObjectDifferBuilder.buildDefault().compare(working, base);
        if (diff.hasChanges()) {
            StringBuilder changeLog = new StringBuilder();
            MutableBoolean firstLoop = new MutableBoolean(true);
            diff.visit((DiffNode.Visitor)new /* Unavailable Anonymous Inner Class!! */);
            changeLog.append(".");
            return changeLog.toString();
        }
        return "";
    }

    public static final String formatObjectDiff(User user, String objDescription, String changes) {
        StringBuilder logBuilder = new StringBuilder();
        logBuilder.append(StringUtils.capitalize((String)LoggerUtils.log((User)user)));
        logBuilder.append(" has changed the properties of ");
        logBuilder.append(objDescription);
        logBuilder.append(". ");
        logBuilder.append("Changes:");
        logBuilder.append(changes);
        return logBuilder.toString();
    }

    public static final <T> String logCollectionDiffVerbose(Collection<T> oldCol, Collection<T> newCol, Function<T, String> toStringFunction) {
        return LoggerUtils.logCollectionDiffIntern(oldCol, newCol, toStringFunction, (boolean)true);
    }

    public static final <T> String logCollectionDiffBrief(Collection<T> oldCol, Collection<T> newCol, Function<T, String> toStringFunction) {
        return LoggerUtils.logCollectionDiffIntern(oldCol, newCol, toStringFunction, (boolean)false);
    }

    private static final <T> String logCollectionDiffIntern(Collection<T> oldCol, Collection<T> newCol, Function<T, String> toStringFunction, boolean listAllElements) {
        HashSet newStateSet = new HashSet(newCol == null ? Collections.emptySet() : newCol);
        HashSet oldStateSet = new HashSet(oldCol == null ? Collections.emptySet() : oldCol);
        HashSet allElements = new HashSet();
        allElements.addAll(newStateSet);
        allElements.addAll(oldStateSet);
        List newElements = CollectionUtils.subtract(newStateSet, oldStateSet).stream().map(toStringFunction).sorted().collect(Collectors.toList());
        List delElements = CollectionUtils.subtract(oldStateSet, newStateSet).stream().map(toStringFunction).sorted().collect(Collectors.toList());
        List allStringElements = allElements.stream().map(toStringFunction).sorted().collect(Collectors.toList());
        String logDiff = allStringElements.stream().filter(r -> newElements.contains(r) || delElements.contains(r)).map(r -> {
            if (newElements.contains(r)) {
                return "+'" + r + "'";
            }
            if (delElements.contains(r)) {
                return "-'" + r + "'";
            }
            return "'" + r + "'";
        }).collect(Collectors.joining(", "));
        if (listAllElements) {
            String logNew = newStateSet.stream().map(toStringFunction).sorted().collect(Collectors.joining(", "));
            return logDiff + " -> {" + logNew + "}";
        }
        return logDiff;
    }
}

