/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.services.cloud_sync;

import de.rtb.pcon.ui.services.cloud_sync.ObjectStorageProperties;
import io.awspring.cloud.s3.ObjectMetadata;
import io.awspring.cloud.s3.S3Template;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.retry.support.RetrySynchronizationManager;
import org.springframework.stereotype.Service;

@Service
public class S3ObjectUploader {
    private static final Logger log = LoggerFactory.getLogger(S3ObjectUploader.class);
    private final Optional<S3Template> s3Template;
    private final ObjectStorageProperties objectStorageProps;

    public S3ObjectUploader(Optional<S3Template> s3Template, ObjectStorageProperties objectStorageProps) {
        this.s3Template = s3Template;
        this.objectStorageProps = objectStorageProps;
    }

    @Retryable(maxAttempts=3, backoff=@Backoff(delay=1000L))
    public void writeConfigDatabase(Path dbFilePath) {
        log.atDebug().setMessage("Storing to S3, try {}.").addArgument(() -> RetrySynchronizationManager.getContext().getRetryCount()).log();
        try (FileInputStream cfgInput = new FileInputStream(dbFilePath.toFile());){
            ObjectMetadata objMeta = ObjectMetadata.builder().contentType("application/octet-stream").build();
            this.s3Template.ifPresentOrElse(s3t -> s3t.upload(this.objectStorageProps.getBucketName(), "configuration/project.mv.db", (InputStream)cfgInput, objMeta), () -> log.info("Project configuration was not uploaded, because S3 is disabled in configuration."));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

