/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.services.cloud_sync;

import de.rtb.pcon.core.events.AreaDeletedEvent;
import de.rtb.pcon.core.events.AreaUpdatedEvent;
import de.rtb.pcon.core.events.PartnerDeletedEvent;
import de.rtb.pcon.core.events.PartnerUpdatedEvent;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.repositories.AreaPartnerRepository;
import de.rtb.pcon.repositories.AreaRepository;
import de.rtb.pcon.repositories.ZoneRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcon.ui.services.cloud_sync.S3ObjectUploader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.event.EventListener;
import org.springframework.jdbc.core.simple.JdbcClient;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;
import org.springframework.util.StopWatch;

@Service
public class S3ConfigExporterH2 {
    private static final Logger log = LoggerFactory.getLogger(S3ConfigExporterH2.class);
    private static final String SQL_SCHEMA = "CREATE TABLE AREA (\n    ID INTEGER NOT NULL,\n    NAME CHARACTER VARYING,\n    TIME_ZONE CHARACTER VARYING,\n    CONSTRAINT PK_AREA PRIMARY KEY (ID)\n);\n\nCREATE TABLE ZONE (\n    ID INTEGER NOT NULL,\n    NAME CHARACTER VARYING,\n    AREA_ID INTEGER NOT NULL,\n    CONSTRAINT PK_ZONE PRIMARY KEY (ID),\n    CONSTRAINT FK_ZONE_AREA FOREIGN KEY (AREA_ID) REFERENCES AREA (ID) ON UPDATE CASCADE ON DELETE CASCADE\n);\n\n-- Add an index on ZONE.AREA_ID\nCREATE INDEX FKI_ZONE_AREA_ID ON ZONE (AREA_ID);\n\nCREATE TABLE PDM (\n    ID INTEGER NOT NULL,\n    NR INTEGER NOT NULL,\n    NAME CHARACTER VARYING,\n    LAT DOUBLE PRECISION,\n    LON DOUBLE PRECISION,\n    ZONE_ID INTEGER NOT NULL,\n    CONSTRAINT PK_PDM PRIMARY KEY (ID),\n    CONSTRAINT FK_PDM_ZONE FOREIGN KEY (ZONE_ID) REFERENCES ZONE (ID) ON UPDATE CASCADE ON DELETE CASCADE\n);\n\n-- Add an index on PDM.ZONE_ID\nCREATE INDEX FKI_PDM_ZONE_ID ON PDM (ZONE_ID);\n\nCREATE TABLE AREA_PARTNER (\n    ID INTEGER NOT NULL,\n    AREA_ID INTEGER NOT NULL,\n    CFG_TYPE CHARACTER VARYING NOT NULL,\n    CONFIG CHARACTER VARYING,\n    CONSTRAINT PK_AREA_PARTNER PRIMARY KEY (ID),\n    CONSTRAINT UC_AREA_PARTNER UNIQUE (AREA_ID, CFG_TYPE),\n    CONSTRAINT FK_AREA_PARTNER_AREA FOREIGN KEY (AREA_ID) REFERENCES AREA (ID) ON UPDATE CASCADE ON DELETE CASCADE\n);\n\n-- Add an index on AREA_PARTNER.AREA_ID\nCREATE INDEX FKI_AREA_PARTNER_AREA ON AREA_PARTNER (AREA_ID);\n";
    private final AreaRepository areaRepo;
    private final ZoneRepository zoneRepo;
    private final PdmRepository pdmRepo;
    private final AreaPartnerRepository partnerRepo;
    private final S3ObjectUploader s3objectUploader;

    public S3ConfigExporterH2(AreaRepository areaRepo, ZoneRepository zoneRepo, PdmRepository pdmRepo, AreaPartnerRepository partnerRepo, S3ObjectUploader s3objectUploader) {
        this.areaRepo = areaRepo;
        this.zoneRepo = zoneRepo;
        this.pdmRepo = pdmRepo;
        this.partnerRepo = partnerRepo;
        this.s3objectUploader = s3objectUploader;
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION)
    @Async(value="taskExecutorAsync")
    public void areaUpdatedTransactional(AreaUpdatedEvent evt) {
        this.exportConfiguration();
    }

    @EventListener
    @Async(value="taskExecutorAsync")
    public void areaUpdatedNormal(AreaUpdatedEvent evt) {
        this.exportConfiguration();
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION)
    @Async(value="taskExecutorAsync")
    public void areaDeleted(AreaDeletedEvent evt) {
        this.exportConfiguration();
    }

    @EventListener
    @Async(value="taskExecutorAsync")
    public void partnerUpdatedNormal(PartnerUpdatedEvent evt) {
        this.exportConfiguration();
    }

    @EventListener
    @Async(value="taskExecutorAsync")
    public void partnerDeleteddNormal(PartnerDeletedEvent evt) {
        this.exportConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportConfiguration() {
        Path dbFilePath = null;
        StopWatch sw = new StopWatch("Configuration export");
        try {
            dbFilePath = Files.createTempFile("pdm_control_project_", ".mv.db", new FileAttribute[0]);
            this.exportData(dbFilePath, sw);
            sw.start("S3 upload");
            this.s3objectUploader.writeConfigDatabase(dbFilePath);
            sw.stop();
        }
        catch (IOException e) {
            log.error("Can't create temporary file to store configuration database into.", (Throwable)e);
        }
        finally {
            if (dbFilePath != null) {
                try {
                    Files.delete(dbFilePath);
                }
                catch (IOException e) {
                    log.atWarn().setMessage("Failed to delete database temporary file.").setCause((Throwable)e).log();
                }
            }
        }
        log.info("Configuration database was stored to S3.");
        log.atTrace().log(() -> sw.prettyPrint(TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportData(Path dbFilePath, StopWatch sw) {
        sw.start("Create data source");
        DataSource dataSource = this.createDataSource(dbFilePath);
        sw.stop();
        try {
            JdbcClient cli = JdbcClient.create((DataSource)dataSource);
            sw.start("Create schema");
            cli.sql(SQL_SCHEMA).update();
            sw.stop();
            sw.start("Export Areas");
            for (Area a : this.areaRepo.findAll()) {
                cli.sql("INSERT INTO area (id, name, time_zone) VALUES (?1, ?2, ?3)").param(1, (Object)a.getId()).param(2, (Object)a.getName()).param(3, (Object)a.getTimeZoneName()).update();
            }
            sw.stop();
            sw.start("Export Zones");
            for (Zone z : this.zoneRepo.findAll()) {
                cli.sql("INSERT INTO zone (id, name, area_id) VALUES (?1, ?2, ?3)").param(1, (Object)z.getId()).param(2, (Object)z.getName()).param(3, (Object)z.getArea().getId()).update();
            }
            sw.stop();
            sw.start("Export PDMs");
            for (Pdm p : this.pdmRepo.findAll()) {
                cli.sql("INSERT INTO pdm (id, nr, name, lat, lon, zone_id) VALUES (?1, ?2, ?3, ?4, ?5, ?6)").param(1, (Object)p.getId()).param(2, (Object)p.getNumber()).param(3, (Object)p.getName()).param(4, (Object)p.getLatitude()).param(5, (Object)p.getLongitude()).param(6, (Object)p.getZone().getId()).update();
            }
            sw.stop();
            sw.start("Export Partners");
            for (Pdm p : this.partnerRepo.findAll()) {
                cli.sql("INSERT INTO area_partner (id, area_id, cfg_type, config) VALUES (?1, ?2, ?3, ?4)").param(1, (Object)p.getId()).param(2, (Object)p.getArea().getId()).param(3, (Object)p.getType().toString()).param(4, (Object)p.getConfig()).update();
            }
            sw.stop();
            sw.start("DB shutdown");
            this.shutDownDatabase(dataSource);
            sw.stop();
        }
        finally {
            if (dataSource instanceof SingleConnectionDataSource) {
                SingleConnectionDataSource scds = (SingleConnectionDataSource)dataSource;
                scds.destroy();
            }
        }
    }

    void shutDownDatabase(DataSource datasource) {
        try (Connection conn = datasource.getConnection();
             Statement statement = conn.createStatement();){
            statement.execute("SHUTDOWN");
            log.debug("Configuration database closed.");
        }
        catch (Exception e) {
            log.error("Can't close H2 database", (Throwable)e);
        }
    }

    public DataSource createDataSource(Path dbFilePath) {
        String dbName = StringUtils.substringBefore((String)dbFilePath.toAbsolutePath().toString(), (String)".mv.db");
        DataSourceProperties dp = new DataSourceProperties();
        dp.setUsername("sa");
        dp.setPassword("");
        dp.setDriverClassName("org.h2.Driver");
        dp.setUrl("jdbc:h2:" + dbName);
        return dp.initializeDataSourceBuilder().type(SingleConnectionDataSource.class).build();
    }
}

