/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.services;

import com.fasterxml.jackson.databind.JsonNode;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.ui.services.I18nMessageSourceService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.Collator;
import java.text.DateFormatSymbols;
import java.text.NumberFormat;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class I18nService {
    private static final Logger logger = LoggerFactory.getLogger(I18nService.class);
    private static final String[] LETTER_COUNTRIES = new String[]{"US", "CA"};
    @Autowired
    private SecurityService securityService;
    @Autowired
    private I18nMessageSourceService msgSource;
    private Map<Locale, Locale> resolvedLocales = Collections.synchronizedMap(new HashMap());

    public I18nService() {
    }

    I18nService(I18nMessageSourceService msgSource) {
        this.msgSource = msgSource;
    }

    public Locale getUserLocale() {
        Locale locale = LocaleContextHolder.getLocale();
        Locale resolvedLocale = (Locale)this.resolvedLocales.get(locale);
        if (resolvedLocale == null) {
            if (locale.getCountry().isEmpty()) {
                ArrayList<Locale> localeCandidates = new ArrayList<Locale>();
                Locale[] availableLocales = Locale.getAvailableLocales();
                for (int i = 0; i < availableLocales.length; ++i) {
                    Locale l = availableLocales[i];
                    if (!l.getLanguage().equals(locale.getLanguage()) || l.getCountry().isEmpty()) continue;
                    if (l.getLanguage().equalsIgnoreCase(l.getCountry())) {
                        resolvedLocale = l;
                        localeCandidates.clear();
                        break;
                    }
                    localeCandidates.add(l);
                }
                if (!localeCandidates.isEmpty()) {
                    resolvedLocale = (Locale)localeCandidates.get(0);
                }
                this.resolvedLocales.put(locale, resolvedLocale);
            } else {
                resolvedLocale = locale;
                this.resolvedLocales.put(locale, resolvedLocale);
            }
        }
        if (resolvedLocale == null) {
            logger.error("User locale '{}' was not resolved. Using '{}' instead.", (Object)locale, (Object)Locale.ENGLISH);
            resolvedLocale = Locale.ENGLISH;
        }
        return resolvedLocale;
    }

    public ZoneId userTimeZoneId() {
        ZoneId result;
        User u = this.securityService.getCurrentUser();
        if (u.getTimeZoneName() == null || u.getTimeZoneName().isEmpty()) {
            result = ZoneId.systemDefault();
        } else {
            try {
                result = ZoneId.of(u.getTimeZoneName());
            }
            catch (DateTimeException e) {
                result = ZoneId.systemDefault();
            }
        }
        return result;
    }

    @Deprecated
    private String getStatusMessageText(int mnr, Locale locale) {
        String displayText;
        String key = String.format("mnr.%04d", mnr);
        try {
            String text = this.msgSource.getMessage(key, null, locale);
            displayText = String.format("%s", text);
        }
        catch (NoSuchMessageException e) {
            displayText = Integer.toString(mnr);
        }
        return displayText;
    }

    public String getStatusMessageFullText(int mnr, JsonNode extendedInfo, Locale locale) {
        if (extendedInfo == null) {
            return this.getStatusMessageText(mnr, locale);
        }
        LinkedList<String> statusMsgArgs = new LinkedList<String>();
        if (extendedInfo.isArray()) {
            for (JsonNode arrayElementNode : extendedInfo) {
                String result = this.processReasonNode(mnr, arrayElementNode, locale);
                statusMsgArgs.add(result);
            }
        } else {
            String result = this.processReasonNode(mnr, extendedInfo, locale);
            statusMsgArgs.add(result);
        }
        Object[] textArgs = statusMsgArgs.toArray();
        return this.msgSource.getMessageO(String.format("mnr.%04d.templ", mnr), textArgs, locale).or(() -> this.msgSource.getMessageO(String.format("mnr.%04d", mnr), ArrayUtils.EMPTY_OBJECT_ARRAY, locale)).orElseGet(() -> Integer.toString(mnr));
    }

    private String processReasonNode(int mnr, JsonNode node, Locale locale) {
        LinkedList<String> argList = new LinkedList<String>();
        int reason = node.get("r").asInt();
        JsonNode argNode = node.get("a");
        if (argNode != null) {
            for (JsonNode args : argNode) {
                if (args.isObject()) {
                    argList.add(this.processReasonNode(mnr, args, locale));
                    continue;
                }
                if (args.isNumber()) {
                    argList.add(this.formatNumber((Number)args.asInt()));
                    continue;
                }
                argList.add(args.asText());
            }
        }
        String textKey = String.format("mnr.%04d.%02d", mnr, reason);
        try {
            return this.msgSource.getMessage(textKey, argList.toArray(), locale);
        }
        catch (NoSuchMessageException e) {
            return Integer.toString(reason);
        }
    }

    public String getLocalizedMessageWithLocale(String key, Locale locale, Object ... args) {
        try {
            return this.msgSource.getMessage(key, args, locale);
        }
        catch (NoSuchMessageException e) {
            return key;
        }
    }

    public String getLocalizedMessage(String key, Object ... args) {
        try {
            return this.msgSource.getMessage(key, args, this.getUserLocale());
        }
        catch (NoSuchMessageException e) {
            return key;
        }
    }

    private static String formatCurrency(double value, String currency, Locale locale) {
        String result;
        NumberFormat format = NumberFormat.getCurrencyInstance(locale);
        try {
            format.setCurrency(Currency.getInstance(currency));
            result = format.format(value);
        }
        catch (IllegalArgumentException e) {
            format.setCurrency(Currency.getInstance("XXX"));
            result = format.format(value);
            result = result.replace("XXX", I18nService.getCustomCurrencySymbol((String)currency));
        }
        return result;
    }

    public String formatCurrency(BigDecimal value, String currency) {
        return I18nService.formatCurrency((double)(value != null ? value.doubleValue() : 0.0), (String)currency, (Locale)this.getUserLocale());
    }

    public String formatCurrency(double value, String currency) {
        return I18nService.formatCurrency((double)value, (String)currency, (Locale)this.getUserLocale());
    }

    public String formatCurrencyWithoutSymbol(double value, Locale locale) {
        String result = I18nService.formatCurrency((double)value, (String)"XXX", (Locale)locale);
        result = result.replace("XXX", "").trim();
        return result;
    }

    public String formatCurrencyWithoutSymbol(double value) {
        return this.formatCurrencyWithoutSymbol(value, this.getUserLocale());
    }

    private static String getCurrencySymbol(String currency, Locale locale) {
        try {
            Currency c = Currency.getInstance(currency);
            return c.getSymbol(locale);
        }
        catch (IllegalArgumentException e) {
            return I18nService.getCustomCurrencySymbol((String)currency);
        }
    }

    public String getCurrencySymbol(String currency) {
        return I18nService.getCurrencySymbol((String)currency, (Locale)this.getUserLocale());
    }

    public static String getCustomCurrencySymbol(String currency) {
        return switch (currency) {
            case "XJA" -> "P";
            default -> currency.trim();
        };
    }

    public String formatTime(FormatStyle formatStyle, LocalDateTime dateTime) {
        if (dateTime != null) {
            DateTimeFormatter localDateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(formatStyle).withLocale(this.getUserLocale());
            return dateTime.format(localDateTimeFormatter);
        }
        return "";
    }

    public String formatTime(FormatStyle formatStyle, OffsetDateTime dateTime) {
        return this.formatTime(formatStyle, this.toUserLocalDateTime(dateTime));
    }

    public String formatTime(OffsetDateTime dateTime) {
        return this.formatTime(FormatStyle.SHORT, this.toUserLocalDateTime(dateTime));
    }

    public String formatTime(FormatStyle formatStyle, OffsetDateTime dateTime, ZoneId timeZone, Locale locale) {
        ZonedDateTime zdt = dateTime.atZoneSameInstant(timeZone);
        return this.formatTime(formatStyle, zdt.toLocalDateTime(), locale);
    }

    public String formatTime(FormatStyle formatStyle, LocalDateTime dateTime, Locale locale) {
        if (dateTime != null) {
            DateTimeFormatter localDateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(formatStyle).withLocale(locale);
            return dateTime.format(localDateTimeFormatter);
        }
        return "";
    }

    public LocalDateTime toUserLocalDateTime(OffsetDateTime dateTime) {
        return DateTimeUtils.toLocalDateTime((OffsetDateTime)dateTime, (ZoneId)this.userTimeZoneId());
    }

    public String formatZonedTime(ZonedDateTime zonedDateTime, FormatStyle formatStyle) {
        if (zonedDateTime != null) {
            ZonedDateTime userZonedDateTime = zonedDateTime.withZoneSameInstant(this.userTimeZoneId());
            DateTimeFormatter localDateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(formatStyle).withLocale(this.getUserLocale());
            return userZonedDateTime.format(localDateTimeFormatter);
        }
        return "";
    }

    public String formatDate(FormatStyle formatStyle, LocalDate date) {
        if (date != null) {
            DateTimeFormatter localDateTimeFormatter = DateTimeFormatter.ofLocalizedDate(formatStyle).withLocale(this.getUserLocale());
            return date.format(localDateTimeFormatter);
        }
        return "";
    }

    public String formatNumber(Number number) {
        if (number != null) {
            NumberFormat formatter = NumberFormat.getInstance(this.getUserLocale());
            return formatter.format(number);
        }
        return "";
    }

    public String formatNumber(Number number, int minFracDigits, int maxFracDigits, boolean grouping) {
        if (number != null) {
            NumberFormat formatter = NumberFormat.getInstance(this.getUserLocale());
            formatter.setMinimumFractionDigits(minFracDigits);
            formatter.setMaximumFractionDigits(maxFracDigits);
            formatter.setGroupingUsed(grouping);
            return formatter.format(number);
        }
        return "";
    }

    public Collator getCollator() {
        return Collator.getInstance(this.getUserLocale());
    }

    public <T, U extends Comparable<? super U>> Comparator<T> comparingString(Function<? super T, ? extends U> keyExtractor) {
        return (Comparator & Serializable)(c1, c2) -> this.getCollator().compare(keyExtractor.apply(c1), keyExtractor.apply(c2));
    }

    public DayOfWeek firstDayOfWeek() {
        DayOfWeek firstDayOfWeek;
        DateFormatSymbols dfs = new DateFormatSymbols(Locale.US);
        String[] weekdays = dfs.getWeekdays();
        Calendar cal = Calendar.getInstance(this.getUserLocale());
        int firstDayOfWeekIndex = cal.getFirstDayOfWeek();
        String firstDayOfWeekName = weekdays[firstDayOfWeekIndex].toUpperCase(Locale.ROOT);
        try {
            firstDayOfWeek = DayOfWeek.valueOf(firstDayOfWeekName);
        }
        catch (IllegalArgumentException e) {
            logger.warn("The first day of week cannot be resolved. Assuming monday.", (Throwable)e);
            firstDayOfWeek = DayOfWeek.MONDAY;
        }
        return firstDayOfWeek;
    }

    public String getEnumNlsKey(Enum<?> e) {
        String className = e.getDeclaringClass().getName();
        className = StringUtils.substringAfterLast((String)className, (String)".");
        className = StringUtils.uncapitalize((String)className);
        return "global.enum." + className + "." + e.name().toLowerCase();
    }

    public String getEnumLocalText(Enum<?> e, Locale locale) {
        String nlsKey = this.getEnumNlsKey(e);
        return this.getLocalizedMessageWithLocale(nlsKey, locale, new Object[0]);
    }

    public String getEnumLocalText(Enum<?> e) {
        return this.getEnumLocalText(e, this.getUserLocale());
    }

    public String getPaperSize() {
        String country = this.getUserLocale().getCountry().toUpperCase(Locale.US);
        if (ArrayUtils.contains((Object[])LETTER_COUNTRIES, (Object)country)) {
            return "Letter";
        }
        return "A4";
    }

    public Set<String> availableTimeZoneNames() {
        return ZoneId.getAvailableZoneIds().stream().filter(z -> !z.startsWith("SystemV")).collect(Collectors.toCollection(() -> new TreeSet<Object>(this.getCollator())));
    }
}

