/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.data_tables.export;

import de.rtb.pcon.core.gdpr.GdprService;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.ui.controllers.PdmFilterRepository;
import de.rtb.pcon.ui.controllers.logbooks.LogbookPaymentRepository;
import de.rtb.pcon.ui.data_tables.PaymentRequest;
import de.rtb.pcon.ui.data_tables.export.UserBackgroundJob;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcontrol.utils.ExcelOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExportPaymentsToExcelTask
extends UserBackgroundJob {
    private static final Logger log = LoggerFactory.getLogger(ExportPaymentsToExcelTask.class);
    private static final int REPORT_GROUP_SIZE = 10000;
    private PaymentRequest dtRequest;

    public ExportPaymentsToExcelTask(User user, Locale locale, PaymentRequest request) {
        super(user, locale);
        this.dtRequest = request;
    }

    public void export() {
        LogbookPaymentRepository logbookPaymentReopository = (LogbookPaymentRepository)this.getApplicationContext().getBean(LogbookPaymentRepository.class);
        PdmFilterRepository pdmFilterRepo = (PdmFilterRepository)this.getApplicationContext().getBean(PdmFilterRepository.class);
        I18nService i18nService = (I18nService)this.getApplicationContext().getBean(I18nService.class);
        PlatformTransactionManager platformTransactionManager = (PlatformTransactionManager)this.getApplicationContext().getBean(PlatformTransactionManager.class);
        GdprService gdprService = (GdprService)this.getApplicationContext().getBean(GdprService.class);
        ZoneId userTimeZone = ZoneId.of(this.getRequester().getTimeZoneName());
        this.setOutLocation(new File(this.getOutLocation(), this.generateRandomFileName("pay", ".xlsx")));
        try (ExcelOutputStream eos = new ExcelOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.getOutLocation())), true);){
            eos.registerDateTimeStyle("dateTimeMin", i18nService.getLocalizedMessageWithLocale("excel.format.datetime.short.minutes", this.getLocale(), new Object[0]));
            eos.registerDateTimeStyle("dateTimeSec", i18nService.getLocalizedMessageWithLocale("excel.format.datetime.short.seconds", this.getLocale(), new Object[0]));
            eos.registerDateTimeStyle("duration", i18nService.getLocalizedMessageWithLocale("excel.format.duration.hours", this.getLocale(), new Object[0]));
            eos.addSheet(i18nService.getLocalizedMessageWithLocale("excel.emptySheetName", this.getLocale(), new Object[0]));
            eos.writeHeaderRow(this.makeHeaderLabels());
            TransactionTemplate transactionTemplate = new TransactionTemplate(platformTransactionManager);
            transactionTemplate.setReadOnly(true);
            log.debug("Exporting payments for user {}", (Object)this.getRequester());
            transactionTemplate.executeWithoutResult(transactionStatus -> {
                log.trace("Initializing data stream ...");
                List pdms = pdmFilterRepo.findBySelector(this.dtRequest.getPdmSelector(), this.getRequester());
                try (Stream paymentStream = logbookPaymentReopository.streamPayments((Collection)pdms, this.dtRequest);){
                    MutableInt loopNr = new MutableInt();
                    MutableLong totalDurationMs = new MutableLong();
                    MutableLong exportGroupStart = new MutableLong(System.currentTimeMillis());
                    log.trace("Processing data...");
                    boolean isLpnProtected = gdprService.isLpnProtected(this.getRequester().getLogin());
                    paymentStream.forEach(payment -> {
                        eos.addRow();
                        eos.writeCell((Number)payment.getId().getPdm().getZone().getArea().getId());
                        eos.writeCell(payment.getId().getPdm().getZone().getArea().getName());
                        eos.writeCell((Number)payment.getId().getPdm().getNumber());
                        eos.writeCell(payment.getId().getPdm().getName());
                        eos.writeCell(i18nService.getEnumLocalText((Enum)payment.getPaymentType(), this.getLocale()));
                        eos.writeCell(i18nService.getEnumLocalText((Enum)payment.getPaymentReason(), this.getLocale()));
                        eos.writeCell((Number)payment.getId().getTrc());
                        eos.writeCell((Number)payment.getAmount());
                        eos.writeCell(payment.getCurrency());
                        eos.writeCell(payment.getPaymentCode());
                        eos.writeCell(isLpnProtected ? "" : payment.getLpn());
                        eos.writeOffsetlDateTime(payment.getParkEndTime(), userTimeZone, "dateTimeMin");
                        eos.writeCell((Number)payment.getTicketNumber());
                        eos.writeCell((Number)payment.getPsn());
                        eos.writeCell(payment.getAuthode());
                        eos.writeOffsetlDateTime(payment.getId().getPdmTime(), userTimeZone, "dateTimeMin");
                        eos.writeOffsetlDateTime(payment.getServerTime(), userTimeZone, "dateTimeSec");
                        eos.writeZoneName(payment.getId().getPdm());
                        eos.writeTariffName(payment.getTariffInfo());
                        eos.writeTariffName(null);
                        eos.writeCell(payment.getData());
                        this.getEntityManager().detach(payment);
                        if (log.isTraceEnabled()) {
                            loopNr.increment();
                            if (loopNr.getValue() % 10000 == 0) {
                                long loopGroupDurationMs = System.currentTimeMillis() - exportGroupStart.getValue();
                                totalDurationMs.add(loopGroupDurationMs);
                                log.trace(ExportPaymentsToExcelTask.generateExportGroupLoopStatistic((MutableInt)loopNr, (MutableLong)totalDurationMs, (long)loopGroupDurationMs));
                                exportGroupStart.setValue(System.currentTimeMillis());
                            }
                        }
                    });
                }
                log.trace("All data processed.");
            });
        }
        catch (IOException e) {
            log.error("Error by exporting payments to excel.", (Throwable)e);
        }
        log.debug("Export finished.");
    }

    private String[] makeHeaderLabels() {
        I18nService i18nService = (I18nService)this.getApplicationContext().getBean(I18nService.class);
        return new String[]{i18nService.getLocalizedMessageWithLocale("comp.table.header.label.gacNumber", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.gac", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.pdmNumber", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.pdm", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.paymentType", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.paymentReason", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.transId", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.amount", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("global.label.currency", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.cardNumber", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.licensePlate", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.parkEnd", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.ticketId", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.spaceNumber", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.authorizationCode", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.datePdm", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.dateServer", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("global.label.zone", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.tariff", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.data", this.getLocale(), new Object[0])};
    }

    private static String generateExportGroupLoopStatistic(MutableInt loopNr, MutableLong totalDurationMs, long loopGroupDurationMs) {
        return String.format("Payment export: chunk %7d - %7d; duration %5.2f s, speed %5d rows/s, avg %5.2f s, total %.2f s", loopNr.getValue() - 9999, loopNr.getValue(), (double)loopGroupDurationMs / 1000.0, (int)(10000.0 / (double)loopGroupDurationMs * 1000.0), (double)totalDurationMs.getValue().longValue() / (loopNr.doubleValue() / 10000.0) / 1000.0, Float.valueOf((float)totalDurationMs.getValue().longValue() / 1000.0f));
    }
}

