/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.data_tables;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.ui.data_tables.DataTableRequest;
import de.rtb.pcontrol.ui.controller.UiConvertHelper;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;

public abstract class LogbookDataTableRequest
extends DataTableRequest {
    @JsonProperty(value="timeFilterFrom")
    private LocalDateTime timeFrom;
    @JsonProperty(value="timeFilterTo")
    private LocalDateTime timeTo;
    @JsonProperty(value="pdm", required=false)
    private List<Integer> pdmIds;
    @JsonProperty(value="pdms", required=false)
    private String pdmSelector;
    @JsonProperty(value="countRows")
    private Boolean countRows;
    @JsonIgnore
    private ZoneId userTimeZone;

    public LocalDateTime getTimeFrom() {
        return this.timeFrom;
    }

    public void setTimeFrom(LocalDateTime timeFrom) {
        this.timeFrom = timeFrom;
    }

    public LocalDateTime getTimeTo() {
        return this.timeTo;
    }

    public void setTimeTo(LocalDateTime timeTo) {
        this.timeTo = timeTo;
    }

    public List<Integer> getPdmIds() {
        return this.pdmIds;
    }

    public void setPdmIds(List<Integer> pdmIds) {
        this.pdmIds = pdmIds;
    }

    public String getPdmSelector() {
        return this.pdmSelector;
    }

    public void setPdmSelector(String pdmSelector) {
        this.pdmSelector = pdmSelector;
    }

    public ZoneId getUserTimeZone() {
        return this.userTimeZone;
    }

    public void setUserTimeZone(ZoneId userTimeZone) {
        this.userTimeZone = userTimeZone;
    }

    public Boolean getCountRows() {
        return this.countRows;
    }

    public void setCountRows(Boolean countRows) {
        this.countRows = countRows;
    }

    @JsonIgnore
    public OffsetDateTime makeOffsetTimeFrom() {
        return UiConvertHelper.from((LocalDateTime)this.timeFrom, (ZoneId)this.userTimeZone);
    }

    @JsonIgnore
    public OffsetDateTime makeOffsetTimeTo() {
        return UiConvertHelper.to((LocalDateTime)this.timeTo, (ZoneId)this.userTimeZone);
    }

    @JsonIgnore
    public abstract String cacheKeyCount();
}

