/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.data_tables;

import de.rtb.pcon.ui.data_tables.DataTableColumn;
import de.rtb.pcon.ui.data_tables.DataTableOrder;
import de.rtb.pcon.ui.data_tables.DataTableSearch;
import java.util.List;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class DataTableRequest {
    private int draw;
    private int start;
    private int length;
    private List<DataTableColumn> columns;
    private List<DataTableOrder> order;
    private DataTableSearch search;

    public Pageable getPageable() {
        int page = this.getStart() / this.getLength();
        List<Sort.Order> orders = this.getOrder().stream().map(o -> {
            DataTableColumn column = (DataTableColumn)this.getColumns().get(o.getColumn());
            return switch (o.getDirection()) {
                case "asc" -> Sort.Order.asc((String)column.getName());
                case "desc" -> Sort.Order.desc((String)column.getName());
                default -> Sort.Order.by((String)column.getName());
            };
        }).toList();
        return PageRequest.of((int)page, (int)this.getLength(), (Sort)Sort.by(orders));
    }

    public int getDraw() {
        return this.draw;
    }

    public void setDraw(int draw) {
        this.draw = draw;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public List<DataTableColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(List<DataTableColumn> columns) {
        this.columns = columns;
    }

    public List<DataTableOrder> getOrder() {
        return this.order;
    }

    public void setOrder(List<DataTableOrder> order) {
        this.order = order;
    }

    public DataTableSearch getSearch() {
        return this.search;
    }

    public void setSearch(DataTableSearch search) {
        this.search = search;
    }
}

