/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.technical;

import de.rtb.pcon.model.AccuLevel;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.ui.controllers.reports.technical.EnergyEntryProjection;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.Param;

interface EnergyReportRepository
extends Repository<AccuLevel, Long> {
    @Query(value="SELECT\np AS pdm,\nyear(a.pdmTime) AS year, month(a.pdmTime) AS month, day(a.pdmTime) AS day,\nSUM(a.powMcsSol) AS powMcsSol, SUM(a.powSvenIn) AS powSvenIn, SUM(a.powSvenBat) AS powSvenBat,\nAVG(a.voltageAvg) AS volAvg, MIN(a.voltageAvg) AS volMin, MAX(a.voltageAvg) AS volMax, MIN(a.voltageMin) AS volDrop\nFROM #{#entityName} a\nJOIN a.pdm p\nWHERE p IN(:pdms) AND a.pdmTime >= :startDate AND a.pdmTime < :endDate\nGROUP BY year(a.pdmTime), month(a.pdmTime), day(a.pdmTime), p\nORDER BY year(a.pdmTime), month(a.pdmTime), day(a.pdmTime), p\n")
    public List<EnergyEntryProjection> energyReportByDay(@Param(value="pdms") Collection<Pdm> var1, @Param(value="startDate") OffsetDateTime var2, @Param(value="endDate") OffsetDateTime var3);

    @Query(value="SELECT\np AS pdm,\nyear(a.pdmTime) AS year, month(a.pdmTime) AS month, 1 AS day,\nSUM(a.powMcsSol) AS powMcsSol, SUM(a.powSvenIn) AS powSvenIn, SUM(a.powSvenBat) AS powSvenBat,\nAVG(a.voltageAvg) AS volAvg, MIN(a.voltageAvg) AS volMin, MAX(a.voltageAvg) AS volMax, MIN(a.voltageMin) AS volDrop\nFROM #{#entityName} a\nJOIN a.pdm p\nWHERE p IN(:pdms) AND a.pdmTime >= :startDate AND a.pdmTime < :endDate\nGROUP BY year(a.pdmTime), month(a.pdmTime), p\nORDER BY year(a.pdmTime), month(a.pdmTime), p\n")
    public List<EnergyEntryProjection> energyReportByMonth(@Param(value="pdms") Collection<Pdm> var1, @Param(value="startDate") OffsetDateTime var2, @Param(value="endDate") OffsetDateTime var3);

    @Query(value="SELECT\np AS pdm,\nyear(a.pdmTime) AS year, 1 AS month, 1 AS day,\nSUM(a.powMcsSol) AS powMcsSol, SUM(a.powSvenIn) AS powSvenIn, SUM(a.powSvenBat) AS powSvenBat,\nAVG(a.voltageAvg) AS volAvg, MIN(a.voltageAvg) AS volMin, MAX(a.voltageAvg) AS volMax, MIN(a.voltageMin) AS volDrop\nFROM #{#entityName} a\nJOIN a.pdm p\nWHERE p IN(:pdms) AND a.pdmTime >= :startDate AND a.pdmTime < :endDate\nGROUP BY year(a.pdmTime), p\nORDER BY year(a.pdmTime), p\n")
    public List<EnergyEntryProjection> energyReportByYear(@Param(value="pdms") Collection<Pdm> var1, @Param(value="startDate") OffsetDateTime var2, @Param(value="endDate") OffsetDateTime var3);
}

