/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.revenue;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.ui.controllers.reports.revenue.UiAmountCount;
import de.rtb.pcon.ui.controllers.reports.revenue.UiSummaryReport;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

class UiSummaryRow {
    private UiSummaryReport report;
    private long pdmId;
    @JsonIgnore
    private String pdmName;
    @JsonIgnore
    private int pdmNumber;
    private String currency;
    private Map<PaymentType, UiAmountCount> items;

    UiSummaryRow(UiSummaryReport report) {
        this.report = report;
        this.items = new LinkedHashMap();
    }

    public Integer getTotalCount() {
        return this.items.values().stream().map(UiAmountCount::getCount).reduce(0, Integer::sum);
    }

    public BigDecimal getTotalAmount() {
        return this.items.values().stream().map(UiAmountCount::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @JsonGetter(value="items")
    public List<UiAmountCount> getAllItems() {
        return this.report.getPaymentTypes().stream().map(pt -> this.items.computeIfAbsent(pt, k -> new UiAmountCount())).toList();
    }

    public UiAmountCount createItem(PaymentType pt) {
        UiAmountCount item = new UiAmountCount();
        this.items.put(pt, item);
        return item;
    }

    public UiAmountCount getItem(PaymentType pt) {
        return this.items.getOrDefault(pt, new UiAmountCount());
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE);
        tsb.append("pdm", (Object)("#" + Long.toString(this.pdmId)));
        tsb.append("curr", (Object)this.currency);
        this.items.entrySet().forEach(e -> tsb.append((Object)("[" + String.valueOf(e.getKey()) + ": " + String.valueOf(e.getValue()) + "]")));
        return tsb.toString();
    }

    public long getPdmId() {
        return this.pdmId;
    }

    public void setPdmId(long pdmId) {
        this.pdmId = pdmId;
    }

    public String getPdmName() {
        return this.pdmName;
    }

    public void setPdmName(String pdmName) {
        this.pdmName = pdmName;
    }

    public int getPdmNumber() {
        return this.pdmNumber;
    }

    public void setPdmNumber(int pdmNumber) {
        this.pdmNumber = pdmNumber;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Map<PaymentType, UiAmountCount> getItems() {
        return this.items;
    }

    public void setItems(Map<PaymentType, UiAmountCount> items) {
        this.items = items;
    }
}

