/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.revenue;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.model.CashBoxLevel;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.ui.controllers.model.UiMoney;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;

class UiCashBoxLevelRow {
    private int pdmId;
    @JsonProperty(value="pt")
    private PaymentType paymentType;
    private UiMoney amount;
    private LocalDateTime lastClearing;

    UiCashBoxLevelRow() {
    }

    public static UiCashBoxLevelRow of(CashBoxLevel dm, ZoneId timeZone) {
        UiCashBoxLevelRow result = new UiCashBoxLevelRow();
        result.pdmId = dm.getPdm().getId();
        result.paymentType = dm.getPaymentType();
        result.amount = new UiMoney(dm.getLevel(), dm.getCurrency());
        result.lastClearing = DateTimeUtils.toLocalDateTime((OffsetDateTime)dm.getLastClearing(), (ZoneId)timeZone);
        return result;
    }

    @JsonGetter(value="pt")
    public Integer getPaymentTypeJson() {
        return this.paymentType == null ? null : Integer.valueOf(this.paymentType.getValue());
    }

    public int getPdmId() {
        return this.pdmId;
    }

    public void setPdmId(int pdmId) {
        this.pdmId = pdmId;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public UiMoney getAmount() {
        return this.amount;
    }

    public void setAmount(UiMoney amount) {
        this.amount = amount;
    }

    public LocalDateTime getLastClearing() {
        return this.lastClearing;
    }

    public void setLastClearing(LocalDateTime lastClearing) {
        this.lastClearing = lastClearing;
    }
}

