/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.revenue;

import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueByPaymentTypeUi;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueByPdmDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueByPeriodDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueBySummaryDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayReportDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayReportItemDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayRowDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueMonthlySummaryDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueRepository;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Tuple;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.mutable.MutableLong;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RevenueReportService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private I18nService i18nService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private RevenueRepository revenueRepository;

    @Transactional(readOnly=true)
    public List<RevenueByPeriodDto> revenueByPeriod(OffsetDateTime from, OffsetDateTime to, Collection<PaymentType> paymentTypes, Collection<Pdm> pdms, String grouping) {
        if (pdms.isEmpty()) {
            return Collections.emptyList();
        }
        this.entityManager.createNativeQuery("SET LOCAL TIME ZONE '" + this.i18nService.userTimeZoneId().toString() + "'").executeUpdate();
        String query = "SELECT   extract(year from pt.id.pdmTime) as year,   %1$s as groupNr,   pt.paymentType as paymentTypeExt,   pt.currency as currency,   pdm as pdm,   pt.paymentReason as paymentReason,   sum(pt.amount) as amount FROM PaymentTransaction pt JOIN pt.id.pdm pdm JOIN pdm.zone.area area WHERE pt.id.pdmTime >= :timeFrom   and pt.id.pdmTime < :timeTo   and pdm in (:pdms)   and pt.paymentType in (:paymentTypes) GROUP by   extract(year from pt.id.pdmTime),   %1$s,   pt.paymentType,   pdm,   pt.currency,   pt.paymentReason ORDER BY   extract(year from pt.id.pdmTime),   %1$s,   pt.currency,   pdm,   pt.paymentType,   pt.paymentReason".formatted(switch (grouping.toUpperCase()) {
            case "DAY" -> "sql('extract(doy from ?)::integer', pt.id.pdmTime)";
            case "WEEK" -> "extract(week from pt.id.pdmTime)";
            case "MONTH" -> "extract(month from pt.id.pdmTime)";
            default -> "extract(year from pt.id.pdmTime)";
        });
        List qResult = this.entityManager.createQuery(query, Tuple.class).setParameter("timeFrom", (Object)from).setParameter("timeTo", (Object)to).setParameter("pdms", pdms).setParameter("paymentTypes", paymentTypes).getResultList();
        int periodOrder = 0;
        RevenueByPeriodDto currentEntry = null;
        LinkedList<RevenueByPeriodDto> revenueMap = new LinkedList<RevenueByPeriodDto>();
        String lastEntryId = "";
        for (Tuple resValues : qResult) {
            int year = (Integer)resValues.get("year", Integer.class);
            int groupNr = (Integer)resValues.get("groupNr", Integer.class);
            PaymentType paymentType = (PaymentType)resValues.get("paymentTypeExt", PaymentType.class);
            String currency = (String)resValues.get("currency", String.class);
            Pdm pdm = (Pdm)resValues.get("pdm", Pdm.class);
            PaymentReason paymentReason = (PaymentReason)resValues.get("paymentReason", PaymentReason.class);
            BigDecimal sum = (BigDecimal)resValues.get("amount", BigDecimal.class);
            String currentEntryId = String.format("%d/%d/%s/%d/%s/%s", year, groupNr, currency, pdm.getId(), paymentType, paymentReason);
            if (currentEntryId.equals(lastEntryId)) continue;
            if (currentEntry != null) {
                revenueMap.add(currentEntry);
            }
            currentEntry = new RevenueByPeriodDto(periodOrder++);
            switch (grouping.toUpperCase()) {
                case "DAY": {
                    currentEntry.setPeriodLabel(this.i18nService.formatDate(FormatStyle.SHORT, LocalDate.ofYearDay(year, groupNr)));
                    break;
                }
                case "YEAR": {
                    currentEntry.setPeriodLabel(Integer.toString(year));
                    break;
                }
                default: {
                    currentEntry.setPeriodLabel(year + "/" + groupNr);
                }
            }
            currentEntry.setCurrency(currency);
            currentEntry.setPdm(pdm);
            currentEntry.setPaymentType(paymentType);
            currentEntry.setPaymentReasonValue(paymentReason, sum);
        }
        if (currentEntry != null) {
            revenueMap.add(currentEntry);
        }
        return revenueMap;
    }

    @Transactional(readOnly=true)
    public List<RevenueByPdmDto> byPdm(Collection<Pdm> pdms, OffsetDateTime from, OffsetDateTime to, Collection<PaymentReason> paymentReasons, Collection<PaymentType> paymentTypes) {
        return this.revenueRepository.reportRevenueuByPdm(pdms, from, to, paymentTypes, paymentReasons);
    }

    @Transactional(readOnly=true)
    public RevenueEndOfDayReportDto byEndOfDay(Collection<Pdm> pdms, OffsetDateTime from, OffsetDateTime to, Collection<PaymentReason> paymentReasons) {
        if (pdms.isEmpty()) {
            return new RevenueEndOfDayReportDto();
        }
        ZoneId userTimeZoneId = this.i18nService.userTimeZoneId();
        this.entityManager.createNativeQuery("SET LOCAL timezone to '" + userTimeZoneId.toString() + "'").executeUpdate();
        List endOfDayData = this.revenueRepository.reportRevenueEndOfDay(pdms, from, to, paymentReasons);
        RevenueEndOfDayReportDto report = new RevenueEndOfDayReportDto();
        HashSet<PaymentType> usedPaymentTypeSet = new HashSet<PaymentType>();
        HashMap<String, MutableLong> usedCurrenciesMap = new HashMap<String, MutableLong>();
        RevenueEndOfDayRowDto repRow = null;
        Object lastRowBase = "";
        for (RevenueEndOfDayDto dbRow : endOfDayData) {
            usedPaymentTypeSet.add(dbRow.getPaymentType());
            usedCurrenciesMap.computeIfAbsent(dbRow.getCurrency(), k -> new MutableLong(0L)).increment();
            String thisRowBase = dbRow.getDate().toString() + dbRow.getPaymentReason().toString() + dbRow.getCurrency();
            if (!thisRowBase.equals(lastRowBase)) {
                repRow = report.createReportRow();
                repRow.setDate(dbRow.getDate());
                repRow.setPaymentReason(dbRow.getPaymentReason());
                repRow.setCurrency(dbRow.getCurrency());
            }
            RevenueEndOfDayReportItemDto repItem = repRow.createItem(dbRow.getPaymentType());
            repItem.setCount(dbRow.getNrOfPayments());
            repItem.setAmount(dbRow.getAmount());
            lastRowBase = thisRowBase;
        }
        List usedPaymentTypes = usedPaymentTypeSet.stream().sorted(this.i18nService.comparingString(p -> this.i18nService.getEnumLocalText((Enum)p))).toList();
        report.setPaymentTypes(usedPaymentTypes);
        List currenciesByFrequency = usedCurrenciesMap.keySet().stream().sorted((c1, c2) -> ((MutableLong)usedCurrenciesMap.get(c1)).compareTo((MutableLong)usedCurrenciesMap.get(c2))).toList();
        report.setCurrencies(currenciesByFrequency);
        return report;
    }

    @Transactional(readOnly=true)
    public List<RevenueBySummaryDto> bySummary(Collection<Pdm> pdms, OffsetDateTime from, OffsetDateTime to, Collection<PaymentReason> paymentReasons) {
        return this.revenueRepository.reportRevenueSummary(pdms, from, to, paymentReasons);
    }

    @Transactional(readOnly=true)
    public List<RevenueByPaymentTypeUi> byPaymentType(Collection<Pdm> pdms, OffsetDateTime from, OffsetDateTime to, Collection<PaymentReason> paymentReasons) {
        return this.revenueRepository.reportRevenueByPaymentType(pdms, from, to, paymentReasons).stream().map(RevenueByPaymentTypeUi::new).toList();
    }

    @Transactional(readOnly=true)
    public Map<String, Map<YearMonth, BigDecimal>> prepareMonthlySummaryByPaymentReasonReport(Collection<Pdm> pdms, Collection<PaymentReason> paymentReasons, YearMonth fromYm, YearMonth toYm) {
        OffsetDateTime from = ZonedDateTime.of(fromYm.atDay(1), LocalTime.MIN, this.i18nService.userTimeZoneId()).toOffsetDateTime();
        OffsetDateTime to = ZonedDateTime.of(toYm.plusMonths(1L).atDay(1), LocalTime.MIN, this.i18nService.userTimeZoneId()).toOffsetDateTime();
        List dbData = this.revenueRepository.reportMonthlySummary(pdms, from, to, paymentReasons, this.securityService.getCurrentUser());
        TreeMap<String, Map<YearMonth, BigDecimal>> result = new TreeMap<String, Map<YearMonth, BigDecimal>>();
        for (RevenueMonthlySummaryDto o : dbData) {
            Map<YearMonth, BigDecimal> currencyMap;
            if (result.containsKey(o.getCurrency())) {
                currencyMap = (Map)result.get(o.getCurrency());
            } else {
                currencyMap = new TreeMap();
                result.put(o.getCurrency(), currencyMap);
            }
            currencyMap.put(YearMonth.of((int)o.getYear(), o.getMonth()), o.getSale());
        }
        if (result.keySet().isEmpty()) {
            String currencySymbol = Currency.getInstance(this.i18nService.getUserLocale()).getSymbol();
            result.put(currencySymbol, new TreeMap());
        }
        YearMonth currentYearMonth = fromYm;
        while (!toYm.isBefore(currentYearMonth)) {
            for (Map<YearMonth, BigDecimal> currencyMap : result.values()) {
                currencyMap.computeIfAbsent(currentYearMonth, k -> BigDecimal.ZERO);
            }
            currentYearMonth = currentYearMonth.plusMonths(1L);
        }
        return result;
    }
}

