/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.revenue;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueByPeriodDto;
import java.math.BigDecimal;

class RevenueByPeriodUi {
    private String periodLabel;
    private int periodOrder;
    private int pdm;
    @JsonProperty(value="pt")
    private PaymentType paymentType;
    @JsonProperty(value="curr")
    private String currency;
    private BigDecimal revenue;
    private BigDecimal recharging;
    private BigDecimal canceled;
    private BigDecimal reconciliation;
    private BigDecimal penalty;
    private BigDecimal jeton;
    private BigDecimal rtp;

    RevenueByPeriodUi() {
    }

    public static final RevenueByPeriodUi fromDm(RevenueByPeriodDto dm) {
        RevenueByPeriodUi result = new RevenueByPeriodUi();
        result.periodLabel = dm.getPeriodLabel();
        result.periodOrder = dm.getPeriodOrder();
        result.pdm = dm.getPdm().getId();
        result.paymentType = dm.getPaymentType();
        result.currency = dm.getCurrency();
        result.revenue = dm.getRevenue();
        result.recharging = dm.getPaymentReasonValue(PaymentReason.RECHARGING);
        result.canceled = dm.getPaymentReasonValue(PaymentReason.CANCEL);
        result.reconciliation = dm.getPaymentReasonValue(PaymentReason.RECONCILIATION);
        result.penalty = dm.getPaymentReasonValue(PaymentReason.PENALTY);
        result.jeton = dm.getPaymentReasonValue(PaymentReason.JETON);
        result.rtp = dm.getRtpValue();
        return result;
    }

    @JsonGetter(value="pt")
    public Integer getPaymentTypeJson() {
        return PaymentType.ordinalOf((PaymentType)this.paymentType);
    }

    public String getPeriodLabel() {
        return this.periodLabel;
    }

    public void setPeriodLabel(String periodLabel) {
        this.periodLabel = periodLabel;
    }

    public int getPeriodOrder() {
        return this.periodOrder;
    }

    public void setPeriodOrder(int periodOrder) {
        this.periodOrder = periodOrder;
    }

    public int getPdm() {
        return this.pdm;
    }

    public void setPdm(int pdm) {
        this.pdm = pdm;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public BigDecimal getRevenue() {
        return this.revenue;
    }

    public void setRevenue(BigDecimal revenue) {
        this.revenue = revenue;
    }

    public BigDecimal getRecharging() {
        return this.recharging;
    }

    public void setRecharging(BigDecimal recharging) {
        this.recharging = recharging;
    }

    public BigDecimal getCanceled() {
        return this.canceled;
    }

    public void setCanceled(BigDecimal canceled) {
        this.canceled = canceled;
    }

    public BigDecimal getReconciliation() {
        return this.reconciliation;
    }

    public void setReconciliation(BigDecimal reconciliation) {
        this.reconciliation = reconciliation;
    }

    public BigDecimal getPenalty() {
        return this.penalty;
    }

    public void setPenalty(BigDecimal penalty) {
        this.penalty = penalty;
    }

    public BigDecimal getJeton() {
        return this.jeton;
    }

    public void setJeton(BigDecimal jeton) {
        this.jeton = jeton;
    }

    public BigDecimal getRtp() {
        return this.rtp;
    }

    public void setRtp(BigDecimal rtp) {
        this.rtp = rtp;
    }
}

