/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import de.rtb.pcon.ui.controllers.reports.payments.TableFormatter;
import de.rtb.pcon.ui.services.I18nService;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;

class TimeCurrencyTableFormatter
implements TableFormatter<LocalTime, BigDecimal> {
    private DateTimeFormatter localTimeFormatter;
    private I18nService i18nService;

    public TimeCurrencyTableFormatter(I18nService i18nService) {
        this.localTimeFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(i18nService.getUserLocale());
        this.i18nService = i18nService;
    }

    public String formatColHeader(LocalTime value) {
        String formattedTime = this.localTimeFormatter.format(value);
        formattedTime = formattedTime.replaceAll("(\\D*)(\\d+)(\\D\\d+)(\\D\\d+)(\\D*)", "$1$2$3$5");
        return formattedTime;
    }

    public String formatRowHeader(BigDecimal value) {
        String formattedCurrency = this.i18nService.formatCurrencyWithoutSymbol(value.doubleValue());
        return formattedCurrency;
    }

    public String formatCellValue(Integer value) {
        return value.toString();
    }
}

