/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import de.rtb.pcon.ui.controllers.reports.payments.CategoryStrategy;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

class DurationCategoryStrategy
implements CategoryStrategy<Duration> {
    private Duration categorySize;

    public DurationCategoryStrategy(Duration categorySize) {
        this.categorySize = categorySize;
    }

    public int category(Duration value) {
        return (int)(value.getSeconds() / this.categorySize.getSeconds());
    }

    public Duration minValue(int category) {
        return this.categorySize.multipliedBy(category);
    }

    public Duration maxValue(int category) {
        return this.categorySize.multipliedBy(category + 1).minus(1L, ChronoUnit.MILLIS);
    }
}

