/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.bonus;

import de.rtb.pcon.features.bonus.AppliedBonus;
import de.rtb.pcon.model.PaymentTransaction;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;

class UiBonusHistoryRow {
    private Integer pdm;
    private String lpn;
    private LocalDateTime from;
    private LocalDateTime to;
    private long payedTime;
    private long bonusTime;

    public UiBonusHistoryRow(PaymentTransaction pt, ZoneId timeZone, boolean protectGdprData) {
        this.pdm = pt.getId().getPdm().getId();
        this.lpn = protectGdprData ? "" : pt.getLpn();
        this.from = pt.getId().getPdmTime().toZonedDateTime().withZoneSameInstant(timeZone).toLocalDateTime();
        this.to = pt.getParkEndTime().toZonedDateTime().withZoneSameInstant(timeZone).toLocalDateTime();
        this.payedTime = Duration.between(this.from, this.to).toMinutes();
        this.bonusTime = ((AppliedBonus)pt.getBonus().get(0)).getDuration().toMinutes();
    }

    public Integer getPdm() {
        return this.pdm;
    }

    public void setPdm(Integer pdm) {
        this.pdm = pdm;
    }

    public String getLpn() {
        return this.lpn;
    }

    public void setLpn(String lpn) {
        this.lpn = lpn;
    }

    public LocalDateTime getFrom() {
        return this.from;
    }

    public void setFrom(LocalDateTime from) {
        this.from = from;
    }

    public LocalDateTime getTo() {
        return this.to;
    }

    public void setTo(LocalDateTime to) {
        this.to = to;
    }

    public long getPayedTime() {
        return this.payedTime;
    }

    public void setPayedTime(long paydTime) {
        this.payedTime = paydTime;
    }

    public long getBonusTime() {
        return this.bonusTime;
    }

    public void setBonusTime(long bonusTime) {
        this.bonusTime = bonusTime;
    }
}

