/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmOperationalMode;

public class UiPdmProperties {
    private String name;
    private String phoneNumber;
    private String geoLocation;
    private Integer parkingZone;
    @JsonFormat(shape=JsonFormat.Shape.NUMBER)
    private PdmOperationalMode opMode;

    public UiPdmProperties() {
    }

    public UiPdmProperties(Pdm pdm) {
        this.name = pdm.getName();
        this.phoneNumber = pdm.getPhoneNumber();
        this.parkingZone = pdm.getZone().getId();
        if (pdm.getLongitude() != null && pdm.getLatitude() != null) {
            this.geoLocation = pdm.getLatitude() + ", " + pdm.getLongitude();
        }
        this.opMode = pdm.getOpMode();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getGeoLocation() {
        return this.geoLocation;
    }

    public void setGeoLocation(String geoLocation) {
        this.geoLocation = geoLocation;
    }

    public Integer getParkingZone() {
        return this.parkingZone;
    }

    public void setParkingZone(Integer parkingZone) {
        this.parkingZone = parkingZone;
    }

    public PdmOperationalMode getOpMode() {
        return this.opMode;
    }

    public void setOpMode(PdmOperationalMode mode) {
        this.opMode = mode;
    }
}

