/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.logbooks;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.gdpr.GdprService;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmLogCatalog;
import de.rtb.pcon.model.UserRole;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.clearing.Clearing;
import de.rtb.pcon.repositories.ClearingRepository;
import de.rtb.pcon.repositories.PdmLogCatalogRepository;
import de.rtb.pcon.ui.controllers.PdmFilterRepository;
import de.rtb.pcon.ui.controllers.UiBackgroundJobSubmitResult;
import de.rtb.pcon.ui.controllers.logbooks.LogbookClearingRepository;
import de.rtb.pcon.ui.controllers.logbooks.LogbookLogsRepository;
import de.rtb.pcon.ui.controllers.logbooks.LogbookPaymentRepository;
import de.rtb.pcon.ui.controllers.logbooks.LogbookStatusRepository;
import de.rtb.pcon.ui.controllers.logbooks.SimpleSlice;
import de.rtb.pcon.ui.controllers.model.UiClearingDetail;
import de.rtb.pcon.ui.controllers.model.UiClearingLog;
import de.rtb.pcon.ui.controllers.model.UiPayment;
import de.rtb.pcon.ui.controllers.model.UiStatusMessageLog;
import de.rtb.pcon.ui.data_tables.ClearingRequest;
import de.rtb.pcon.ui.data_tables.DataTableResponse;
import de.rtb.pcon.ui.data_tables.PaymentRequest;
import de.rtb.pcon.ui.data_tables.PdmLogRequest;
import de.rtb.pcon.ui.data_tables.StatusRequest;
import de.rtb.pcon.ui.data_tables.export.BackgroundJobProcessorService;
import de.rtb.pcon.ui.data_tables.export.ExportClearingsToExcelTask;
import de.rtb.pcon.ui.data_tables.export.ExportPaymentsToExcelTask;
import de.rtb.pcon.ui.data_tables.export.ExportPdmLogsToExcelTask;
import de.rtb.pcon.ui.data_tables.export.ExportStatusToExcelTask;
import de.rtb.pcon.ui.data_tables.export.UserBackgroundJob;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.StopWatch;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Slice;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.Authentication;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/pcon/ui/logbooks"})
public class LogbookController {
    @Autowired
    private I18nService i18n;
    @Autowired
    private PdmFilterRepository pdmFilterRepo;
    @Autowired
    private ClearingRepository clearingRepo;
    @Autowired
    private PdmLogCatalogRepository catRepo;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private BackgroundJobProcessorService backgroundTaskProcessor;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private LogbookPaymentRepository logbookPaymentRepository;
    @Autowired
    private LogbookStatusRepository logbookStatusRepository;
    @Autowired
    private LogbookClearingRepository logbookClearingRepository;
    @Autowired
    private LogbookLogsRepository logbookLogRepository;
    @Autowired
    private GdprService gdprService;
    private static final String HDR_SERVER_TIMING = "Server-Timing";
    private static final String TIM_PREPARATION = "Preparation";
    private static final String TIM_LOAD_PDMS = "Load PDMs";
    private static final String TIM_LOAD_MAIN = "Load data - main";
    private static final String TIM_LOAD_LAZY = "Load data - lazy";
    private static final String TIM_COUNT = "Count";

    @PostMapping(value={"payments"})
    @PreAuthorize(value="hasRole('ROLE_PCON_ECONOMIST')")
    @Transactional(readOnly=true)
    public ResponseEntity<DataTableResponse<UiPayment>> getPaymentsJson(@RequestBody PaymentRequest filter) {
        StopWatch sw = new StopWatch("Payments");
        sw.start(TIM_PREPARATION);
        boolean isLpnProtected = this.gdprService.isLpnProtected();
        if (isLpnProtected) {
            filter.getColumns().stream().filter(dtc -> StringUtils.equals((CharSequence)"carLicencePlate", (CharSequence)dtc.getName())).forEach(col -> col.setSearch(null));
        }
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        filter.setUserTimeZone(userTimeZone);
        DataTableResponse uiResult = new DataTableResponse();
        sw.switchTask(TIM_LOAD_PDMS);
        List pdms = this.pdmFilterRepo.findBySelector(filter.getPdmSelector());
        filter.setPdmIds(pdms.stream().map(Pdm::getId).toList());
        uiResult.setDraw(filter.getDraw());
        sw.switchTask(TIM_LOAD_MAIN);
        SimpleSlice paymentSlice = this.logbookPaymentRepository.findPayments((Collection)pdms, filter);
        List payments = paymentSlice.getItems();
        sw.switchTask(TIM_LOAD_LAZY);
        List<UiPayment> uiTableData = payments.stream().map(p -> new UiPayment(p, userTimeZone, isLpnProtected)).toList();
        uiResult.setData(uiTableData);
        if (Boolean.TRUE.equals(filter.getCountRows())) {
            sw.switchTask(TIM_COUNT);
            Long count = this.logbookPaymentRepository.countPayments((Collection)pdms, filter);
            uiResult.setRecordsTotal(count.longValue());
            uiResult.setRecordsFiltered(count.longValue());
            sw.stop();
        } else {
            long recordsShown = filter.getPageable().getOffset();
            long totalPagesFaked = paymentSlice.isLast() ? recordsShown + (long)payments.size() : recordsShown + (long)filter.getPageable().getPageSize() + 1L;
            uiResult.setRecordsTotal(totalPagesFaked);
            uiResult.setRecordsFiltered(totalPagesFaked);
        }
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.ok();
        if (this.securityService.hasRole(UserRole.ROLE_GENERAL_SERVER_MONITOR)) {
            responseBuilder.header(HDR_SERVER_TIMING, new String[]{sw.toServerTiming()});
        }
        return responseBuilder.body((Object)uiResult);
    }

    @Transactional(readOnly=true)
    @PostMapping(value={"payments/export"})
    @PreAuthorize(value="hasRole('ROLE_PCON_ECONOMIST')")
    public UiBackgroundJobSubmitResult getTransactionHistoryExcel(@RequestBody String jsonParams) throws IOException {
        User user = this.securityService.getCurrentUser();
        if (StringUtils.isEmpty((CharSequence)user.getEmail())) {
            return new UiBackgroundJobSubmitResult(UiBackgroundJobSubmitResult.Result.NO_EMAIL);
        }
        PaymentRequest filter = (PaymentRequest)this.mapper.readValue(jsonParams, PaymentRequest.class);
        List pdms = this.pdmFilterRepo.findBySelector(filter.getPdmSelector());
        filter.setPdmIds(pdms.stream().map(Pdm::getId).toList());
        filter.setUserTimeZone(ZoneId.of(user.getTimeZoneName()));
        this.backgroundTaskProcessor.addJob((UserBackgroundJob)new ExportPaymentsToExcelTask(user, this.i18n.getUserLocale(), filter));
        return new UiBackgroundJobSubmitResult(UiBackgroundJobSubmitResult.Result.SUCCESS);
    }

    @PostMapping(value={"status"})
    @Transactional(readOnly=true)
    public ResponseEntity<DataTableResponse<UiStatusMessageLog>> getStatusJson(@RequestBody StatusRequest filter, Authentication authentication) {
        boolean showAllStatusMessages = UserRole.containsRole((Authentication)authentication, (UserRole)UserRole.ROLE_PCON_SUPPORT);
        StopWatch sw = new StopWatch("Status");
        sw.start(TIM_PREPARATION);
        DataTableResponse uiResult = new DataTableResponse();
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        filter.setUserTimeZone(userTimeZone);
        sw.switchTask(TIM_LOAD_PDMS);
        List pdms = this.pdmFilterRepo.findBySelector(filter.getPdmSelector());
        filter.setPdmIds(pdms.stream().map(Pdm::getId).toList());
        sw.switchTask(TIM_LOAD_MAIN);
        SimpleSlice statusSlice = this.logbookStatusRepository.findStatus((Collection)pdms, filter, showAllStatusMessages);
        List statuses = statusSlice.getItems();
        sw.switchTask(TIM_LOAD_LAZY);
        List<UiStatusMessageLog> uiTableData = statuses.stream().map(s -> new UiStatusMessageLog(s, userTimeZone)).toList();
        uiResult.setData(uiTableData);
        uiResult.setDraw(filter.getDraw());
        if (Boolean.TRUE.equals(filter.getCountRows())) {
            sw.switchTask(TIM_COUNT);
            Long count = this.logbookStatusRepository.countStatus((Collection)pdms, filter, showAllStatusMessages);
            uiResult.setRecordsTotal(count.longValue());
            uiResult.setRecordsFiltered(count.longValue());
        } else {
            long recordsShown = filter.getPageable().getOffset();
            long totalPagesFaked = statusSlice.isLast() ? recordsShown + (long)statuses.size() : recordsShown + (long)filter.getPageable().getPageSize() + 1L;
            uiResult.setRecordsTotal(totalPagesFaked);
            uiResult.setRecordsFiltered(totalPagesFaked);
        }
        sw.stop();
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.ok();
        if (this.securityService.hasRole(UserRole.ROLE_GENERAL_SERVER_MONITOR)) {
            responseBuilder.header(HDR_SERVER_TIMING, new String[]{sw.toServerTiming()});
        }
        return responseBuilder.body((Object)uiResult);
    }

    @Transactional(readOnly=true)
    @PostMapping(value={"status/export"})
    @PreAuthorize(value="hasAnyRole('ROLE_PCON_SERVICE')")
    public UiBackgroundJobSubmitResult getStautsHistoryExcel(@RequestBody String jsonParams) throws IOException {
        User user = this.securityService.getCurrentUser();
        if (StringUtils.isEmpty((CharSequence)user.getEmail())) {
            return new UiBackgroundJobSubmitResult(UiBackgroundJobSubmitResult.Result.NO_EMAIL);
        }
        StatusRequest filter = (StatusRequest)this.mapper.readValue(jsonParams, StatusRequest.class);
        List pdms = this.pdmFilterRepo.findBySelector(filter.getPdmSelector());
        filter.setPdmIds(pdms.stream().map(Pdm::getId).toList());
        filter.setUserTimeZone(ZoneId.of(user.getTimeZoneName()));
        this.backgroundTaskProcessor.addJob((UserBackgroundJob)new ExportStatusToExcelTask(user, this.i18n.getUserLocale(), filter));
        return new UiBackgroundJobSubmitResult(UiBackgroundJobSubmitResult.Result.SUCCESS);
    }

    @PostMapping(value={"clearings"})
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ROLE_PCON_ECONOMIST')")
    public ResponseEntity<DataTableResponse<UiClearingLog>> getClearingsJson(@RequestBody ClearingRequest filter) {
        StopWatch sw = new StopWatch("Clearing");
        sw.start(TIM_PREPARATION);
        DataTableResponse uiResult = new DataTableResponse();
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        filter.setUserTimeZone(userTimeZone);
        sw.switchTask(TIM_LOAD_PDMS);
        List pdms = this.pdmFilterRepo.findBySelector(filter.getPdmSelector());
        filter.setPdmIds(pdms.stream().map(Pdm::getId).toList());
        uiResult.setDraw(filter.getDraw());
        sw.switchTask(TIM_LOAD_MAIN);
        SimpleSlice clearingSlice = this.logbookClearingRepository.findClearings((Collection)pdms, filter);
        List clearings = clearingSlice.getItems();
        sw.switchTask(TIM_LOAD_LAZY);
        List<UiClearingLog> uiTableData = clearings.stream().map(s -> new UiClearingLog(s, userTimeZone)).toList();
        uiResult.setData(uiTableData);
        if (Boolean.TRUE.equals(filter.getCountRows())) {
            sw.switchTask(TIM_COUNT);
            Long count = this.logbookClearingRepository.countClearings((Collection)pdms, filter);
            uiResult.setRecordsTotal(count.longValue());
            uiResult.setRecordsFiltered(count.longValue());
        } else {
            long recordsShown = filter.getPageable().getOffset();
            long totalPagesFaked = clearingSlice.isLast() ? recordsShown + (long)clearings.size() : recordsShown + (long)filter.getPageable().getPageSize() + 1L;
            uiResult.setRecordsTotal(totalPagesFaked);
            uiResult.setRecordsFiltered(totalPagesFaked);
        }
        sw.stop();
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.ok();
        if (this.securityService.hasRole(UserRole.ROLE_GENERAL_SERVER_MONITOR)) {
            responseBuilder.header(HDR_SERVER_TIMING, new String[]{sw.toServerTiming()});
        }
        return responseBuilder.body((Object)uiResult);
    }

    @Transactional(readOnly=true)
    @PostMapping(value={"clearings/export"})
    @PreAuthorize(value="hasRole('ROLE_PCON_ECONOMIST')")
    public UiBackgroundJobSubmitResult getClearingsHistoryExcel(@RequestBody ClearingRequest filter) {
        User user = this.securityService.getCurrentUser();
        if (StringUtils.isEmpty((CharSequence)user.getEmail())) {
            return new UiBackgroundJobSubmitResult(UiBackgroundJobSubmitResult.Result.NO_EMAIL);
        }
        List pdms = this.pdmFilterRepo.findBySelector(filter.getPdmSelector());
        filter.setPdmIds(pdms.stream().map(Pdm::getId).toList());
        filter.setUserTimeZone(ZoneId.of(user.getTimeZoneName()));
        this.backgroundTaskProcessor.addJob((UserBackgroundJob)new ExportClearingsToExcelTask(user, this.i18n.getUserLocale(), filter));
        return new UiBackgroundJobSubmitResult(UiBackgroundJobSubmitResult.Result.SUCCESS);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"clearings/{id}"})
    @PreAuthorize(value="hasRole('ROLE_PCON_ECONOMIST')")
    public ResponseEntity<UiClearingDetail> getClearingDetail(@PathVariable(value="id") Long clearingId) {
        Optional clearingOpt = this.clearingRepo.findById((Object)clearingId);
        if (clearingOpt.isEmpty()) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).build();
        }
        Clearing c = (Clearing)clearingOpt.get();
        if (this.securityService.deniedFor(c.getPdm())) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
        }
        List previousClearings = this.clearingRepo.find5Before(c.getPdm(), c.getPdmTime(), c.getPaymentType());
        return ResponseEntity.ok((Object)new UiClearingDetail(c, this.i18n.userTimeZoneId(), previousClearings));
    }

    @PostMapping(value={"events"})
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ROLE_PCON_SUPPORT')")
    public ResponseEntity<DataTableResponse<Map<String, Object>>> getPdmLogsJson(@RequestBody PdmLogRequest filter) {
        StopWatch sw = new StopWatch("Logs");
        DataTableResponse uiResult = new DataTableResponse();
        sw.start(TIM_PREPARATION);
        filter.setUserTimeZone(this.i18n.userTimeZoneId());
        uiResult.setDraw(filter.getDraw());
        sw.switchTask(TIM_LOAD_PDMS);
        List pdms = this.pdmFilterRepo.findBySelector(filter.getPdmSelector());
        filter.setPdmIds(pdms.stream().map(Pdm::getId).toList());
        sw.switchTask(TIM_LOAD_MAIN);
        Slice logSlice = this.logbookLogRepository.findPdmLogs((Collection)pdms, filter);
        sw.switchTask(TIM_LOAD_LAZY);
        List<Map> tableData = logSlice.getContent().stream().map(l -> {
            HashMap<String, Object> uiLog = new HashMap<String, Object>();
            uiLog.put("pdm", l.getPdm().getId());
            uiLog.put("time", this.i18n.toUserLocalDateTime(l.getPdmTime()));
            uiLog.put("level", l.getLevel());
            uiLog.put("catalog", l.getCatalog().getId());
            uiLog.put("text", l.getText());
            return uiLog;
        }).toList();
        uiResult.setData(tableData);
        if (Boolean.TRUE.equals(filter.getCountRows())) {
            sw.switchTask(TIM_COUNT);
            long count = this.logbookLogRepository.countPdmLogs((Collection)pdms, filter);
            uiResult.setRecordsTotal(count);
            uiResult.setRecordsFiltered(count);
        } else {
            long recordsShown = filter.getPageable().getOffset();
            long totalPagesFaked = logSlice.isLast() ? recordsShown + (long)tableData.size() : recordsShown + (long)filter.getPageable().getPageSize() + 1L;
            uiResult.setRecordsTotal(totalPagesFaked);
            uiResult.setRecordsFiltered(totalPagesFaked);
        }
        sw.stop();
        ResponseEntity.BodyBuilder responseBuilder = ResponseEntity.ok();
        if (this.securityService.hasRole(UserRole.ROLE_GENERAL_SERVER_MONITOR)) {
            responseBuilder.header(HDR_SERVER_TIMING, new String[]{sw.toServerTiming()});
        }
        return responseBuilder.body((Object)uiResult);
    }

    @GetMapping(value={"events/catalogs"})
    @Transactional(readOnly=true)
    @PreAuthorize(value="hasRole('ROLE_PCON_SUPPORT')")
    public Collection<PdmLogCatalog> getPdmLogCatalogsJson() {
        return IterableUtils.toList((Iterable)this.catRepo.findAll());
    }

    @PostMapping(value={"events/export"})
    @PreAuthorize(value="hasRole('ROLE_PCON_SUPPORT')")
    @Transactional(readOnly=true)
    public UiBackgroundJobSubmitResult getExcel(@RequestBody PdmLogRequest filter) throws IOException {
        User user = this.securityService.getCurrentUser();
        List pdms = this.pdmFilterRepo.findBySelector(filter.getPdmSelector());
        filter.setPdmIds(pdms.stream().map(Pdm::getId).toList());
        this.backgroundTaskProcessor.addJob((UserBackgroundJob)new ExportPdmLogsToExcelTask(user, this.i18n.getUserLocale(), filter));
        return new UiBackgroundJobSubmitResult(UiBackgroundJobSubmitResult.Result.SUCCESS);
    }
}

