/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers;

import com.google.common.base.Stopwatch;
import de.rtb.pcon.core.events.AreaUpdatedEvent;
import de.rtb.pcon.core.open_messages.OpenMessagesService;
import de.rtb.pcon.model.AlertType;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.TariffInfo;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.zone.PermitExtensionOptions;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.repositories.PermitExtensionOptionsRepository;
import de.rtb.pcon.repositories.TariffInfoRepository;
import de.rtb.pcon.repositories.ZoneRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcon.ui.controllers.EntityNotAvailableException;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.controllers.model.UiPdm;
import de.rtb.pcon.ui.controllers.model.UiPdmStatus;
import de.rtb.pcon.ui.controllers.model.UiZone;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/pcon/ui/zones/"})
public class ZoneController {
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.");
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private TariffInfoRepository tariffInfoRepo;
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private ZoneRepository zoneRepo;
    @Autowired
    private PdmRepository pdmRepo;
    @Autowired
    private PermitExtensionOptionsRepository permitExtensionOptionsRepo;
    @Autowired
    private OpenMessagesService openMessagesService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @ExceptionHandler(value={EntityNotAvailableException.class})
    public ResponseEntity<String> handleEntityLoadException(EntityNotAvailableException ex) {
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)ex.getHttpStatus());
    }

    @GetMapping(value={"{id}"})
    @Transactional(readOnly=true)
    public ResponseEntity<UiZone> getZoneInfo(@PathVariable(value="id") int zoneId) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Zone zone = this.entityLoader.loadZone(zoneId);
        UiZone result = new UiZone(zone);
        stopwatch.stop();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Server-Timing", "proc;desc=\"Controller total\";dur=" + stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)result);
    }

    @DeleteMapping(value={"{id}"})
    @PreAuthorize(value="hasRole('ROLE_PCON_SERVICE')")
    @Transactional
    public void deleteZone(@PathVariable(value="id") int zoneId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        zone.getPdms().stream().forEach(p -> p.setZone(null));
        this.zoneRepo.delete((Object)zone);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)AreaUpdatedEvent.oneArea((Object)this, (Integer)zone.getArea().getId()));
        if (actionLogger.isInfoEnabled()) {
            actionLogger.info("The {} has deleted {}", (Object)LoggerUtils.log((User)this.securityService.getCurrentUser()), (Object)LoggerUtils.log((Zone)zone));
        }
    }

    @PutMapping(value={"{id}"})
    @PreAuthorize(value="hasRole('ROLE_PCON_SERVICE')")
    @Transactional
    public UiZone.Properties setZoneInfo(@PathVariable(value="id") int zoneId, @RequestBody UiZone.Properties uiZoneProperties) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        UiZone.Properties uiZoneBaseProperties = new UiZone.Properties(zone);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)AreaUpdatedEvent.oneArea((Object)this, (Integer)zone.getArea().getId()));
        String objChanges = LoggerUtils.makeObjectDiff((Object)uiZoneProperties, (Object)uiZoneBaseProperties);
        if (!objChanges.isEmpty()) {
            actionLogger.info(LoggerUtils.formatObjectDiff((User)this.securityService.getCurrentUser(), (String)LoggerUtils.log((Zone)zone), (String)objChanges));
            zone.setName(uiZoneProperties.getName());
            zone.setDescription(uiZoneProperties.getDescription());
            zone.setEnforcementMode(uiZoneProperties.getEnforcementMode());
            zone.setColor(uiZoneProperties.getColor());
        }
        return new UiZone.Properties(zone);
    }

    @GetMapping(value={"{id}/extensions"})
    @Transactional(readOnly=true)
    public ResponseEntity<UiZone.UiPermitExtensionOptions> getPermitExtensionOptions(@PathVariable(value="id") int zoneId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        UiZone.UiPermitExtensionOptions uiExtOptions = this.permitExtensionOptionsRepo.findByZone(zone).map(UiZone.UiPermitExtensionOptions::new).orElseGet(UiZone.UiPermitExtensionOptions::makeDefault);
        return ResponseEntity.ok().body((Object)uiExtOptions);
    }

    @PutMapping(value={"{id}/extensions"})
    @PreAuthorize(value="hasRole('ROLE_PCON_SERVICE')")
    @Transactional
    public ResponseEntity<String> putPermitExtensionOptions(@PathVariable(value="id") int zoneId, @RequestBody UiZone.UiPermitExtensionOptions uiExtensionOpts) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        Optional dbExtOptsO = this.permitExtensionOptionsRepo.findByZone(zone);
        if (dbExtOptsO.isPresent()) {
            PermitExtensionOptions dbExtOpts = (PermitExtensionOptions)dbExtOptsO.get();
            UiZone.UiPermitExtensionOptions uiExtendedParkingkOptsBase = new UiZone.UiPermitExtensionOptions(dbExtOpts);
            String objChanges = LoggerUtils.makeObjectDiff((Object)uiExtensionOpts, (Object)uiExtendedParkingkOptsBase);
            if (!objChanges.isEmpty()) {
                if (actionLogger.isInfoEnabled()) {
                    actionLogger.info(LoggerUtils.formatObjectDiff((User)this.securityService.getCurrentUser(), (String)(" permit extension in " + LoggerUtils.log((Zone)zone)), (String)objChanges));
                }
                dbExtOpts.setEnabled(uiExtensionOpts.isEnabled());
                dbExtOpts.setPenaltyTime(Duration.ofMinutes(uiExtensionOpts.getPenalty().getDuration()));
                dbExtOpts.setPenaltyValue(uiExtensionOpts.getPenalty().getPrice());
                dbExtOpts.setToleranceTime(Duration.ofMinutes(uiExtensionOpts.getTolerance().getDuration()));
                dbExtOpts.setMaxPermits(uiExtensionOpts.getLimits().getCount());
                dbExtOpts.setMaxPrice(uiExtensionOpts.getLimits().getPrice());
                dbExtOpts.setMaxDuration(Duration.ofMinutes(uiExtensionOpts.getLimits().getDuration()));
            }
        } else {
            PermitExtensionOptions peo = new PermitExtensionOptions();
            peo.setEnabled(uiExtensionOpts.isEnabled());
            peo.setPenaltyTime(Duration.ofMinutes(uiExtensionOpts.getPenalty().getDuration()));
            peo.setPenaltyValue(uiExtensionOpts.getPenalty().getPrice());
            peo.setToleranceTime(Duration.ofMinutes(uiExtensionOpts.getTolerance().getDuration()));
            peo.setMaxPermits(uiExtensionOpts.getLimits().getCount());
            peo.setMaxPrice(uiExtensionOpts.getLimits().getPrice());
            peo.setMaxDuration(Duration.ofMinutes(uiExtensionOpts.getLimits().getDuration()));
            peo.setZone(zone);
            this.permitExtensionOptionsRepo.save((Object)peo);
            if (actionLogger.isDebugEnabled()) {
                String changeDescription = "enabled = " + peo.isEnabled() + ", /penalty/duration = " + String.valueOf(peo.getPenaltyTime()) + ", /penalty/price = " + String.valueOf(peo.getPenaltyValue()) + ", /tolerance/duration = " + String.valueOf(peo.getToleranceTime()) + ", /limits/count = " + peo.getMaxPermits() + ", /limits/price = " + String.valueOf(peo.getMaxPrice()) + ", /limits/duration = " + String.valueOf(peo.getMaxDuration());
                actionLogger.info("The user {} has created new parking permit extension in {}. Properties: {}.", new Object[]{LoggerUtils.log((User)this.securityService.getCurrentUser()), LoggerUtils.log((Zone)zone), changeDescription});
            }
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @DeleteMapping(value={"{id}/extensions"})
    @PreAuthorize(value="hasRole('ROLE_PCON_SERVICE')")
    @Transactional
    public void deletePermitExtensionOptions(@PathVariable(value="id") int zoneId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        this.permitExtensionOptionsRepo.findByZone(zone).ifPresent(pex -> {
            this.permitExtensionOptionsRepo.delete(pex);
            actionLogger.info("The {} has deleted the parking permint extension in {}.", (Object)LoggerUtils.log((User)this.securityService.getCurrentUser()), (Object)LoggerUtils.log((Zone)zone));
        });
    }

    @GetMapping(value={"{id}/pdms"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<UiPdm>> getPdmInZone(@PathVariable(value="id") int zoneId, @RequestParam(value="page", defaultValue="1") int uiPageNumber, @RequestParam(value="limit", defaultValue="10") int uiPageSize) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        Long pdmCount = (Long)this.entityManager.createQuery("SELECT COUNT(*)\nFROM Pdm\nWHERE zone = :zone\n", Long.class).setParameter("zone", (Object)zone).getSingleResult();
        List uiPdms = this.entityManager.createQuery("FROM Pdm\nWHERE zone = :zone\nORDER BY number asc", Pdm.class).setParameter("zone", (Object)zone).setFirstResult((uiPageNumber - 1) * uiPageSize).setMaxResults(uiPageSize).getResultStream().map(UiPdm::new).collect(Collectors.toList());
        int totalPageCount = (int)Math.ceil((double)pdmCount.longValue() / ((double)uiPageSize * 1.0));
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("total-records", new String[]{pdmCount.toString()})).header("total-pages", new String[]{Integer.toString(totalPageCount)})).body(uiPdms);
    }

    @GetMapping(value={"{id}/pdms/status"})
    @Transactional(readOnly=true)
    public Collection<UiPdmStatus> getStatusOfPdms(@PathVariable(value="id") int zoneId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        List pdms = this.pdmRepo.findByZone(zone);
        Map openMessages = this.openMessagesService.listUiOpenMessages((Collection)pdms);
        return pdms.stream().map(pdm -> {
            List oms = openMessages.getOrDefault(pdm, List.of());
            AlertType maxAlert = oms.stream().map(s -> s.getAlert()).max(Comparable::compareTo).orElse(AlertType.NONE);
            return new UiPdmStatus(pdm.getId(), maxAlert);
        }).toList();
    }

    @GetMapping(value={"{id}/pdms/free"})
    @Transactional(readOnly=true)
    public ResponseEntity<List<UiPdm>> getPdmsForAssignment(@PathVariable(value="id") int zoneId, @RequestParam(value="page", defaultValue="1") int uiPageNumber, @RequestParam(value="limit", defaultValue="10") int uiPageSize) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        Long pdmCount = (Long)this.entityManager.createQuery("SELECT COUNT(*)\nFROM Pdm\nWHERE\n zone is null\nAND\n area = :area\n", Long.class).setParameter("area", (Object)zone.getArea()).getSingleResult();
        List uiPdms = this.entityManager.createQuery("FROM Pdm\nWHERE\n zone is null\nAND\n area = :area\nORDER BY number asc", Pdm.class).setParameter("area", (Object)zone.getArea()).setFirstResult((uiPageNumber - 1) * uiPageSize).setMaxResults(uiPageSize).getResultStream().map(UiPdm::new).collect(Collectors.toList());
        int totalPageCount = (int)Math.ceil((double)pdmCount.longValue() / ((double)uiPageSize * 1.0));
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("total-records", new String[]{pdmCount.toString()})).header("total-pages", new String[]{Integer.toString(totalPageCount)})).body(uiPdms);
    }

    @PutMapping(value={"{zoneId}/pdm/link/{pdmId}"})
    @PreAuthorize(value="hasRole('ROLE_PCON_SERVICE')")
    @Transactional
    public ResponseEntity<Object> linkPdm(@PathVariable(value="zoneId") int zoneId, @PathVariable(value="pdmId") int pdmId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        Pdm pdm = this.entityLoader.loadPdm(pdmId);
        if (!pdm.getZone().getArea().getId().equals(zone.getArea().getId())) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.CONFLICT);
        }
        pdm.setZone(zone);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)AreaUpdatedEvent.oneArea((Object)this, (Integer)zone.getArea().getId()));
        if (actionLogger.isInfoEnabled()) {
            actionLogger.info("The {} linked {} into {}.", new Object[]{LoggerUtils.log((User)this.securityService.getCurrentUser()), LoggerUtils.log((Pdm)pdm), LoggerUtils.log((Zone)zone)});
        }
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"{id}/tariffs"})
    @Transactional(readOnly=true)
    public List<String> getUsedTariffs(@PathVariable(value="id") int zoneId) {
        this.entityLoader.loadZone(zoneId);
        List tariffInfos = this.tariffInfoRepo.findAllInZone(zoneId);
        return tariffInfos.stream().map(TariffInfo::getName).distinct().toList();
    }
}

