/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers;

import de.rtb.pcon.ui.controllers.IndexController;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public class IndexController {
    private static final Logger log = LoggerFactory.getLogger(IndexController.class);
    private static final Pattern RESOURCE_WITH_HASH = Pattern.compile("\\w+\\.[a-f\\d]{16}\\.[\\w\\.]+$");
    private final Map<String, String> encodingExtensions = new LinkedHashMap();
    @Autowired
    private ResourceLoader resourceLoader;

    public IndexController() {
        this.encodingExtensions.put("br", ".br");
        this.encodingExtensions.put("gzip", ".gz");
    }

    @GetMapping(value={"/"})
    ModelAndView getRoot(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        return new ModelAndView((View)new RedirectView("/control/"));
    }

    @GetMapping(value={"/login.html", "/login", "/index**"})
    public String redirectedLogin(RedirectAttributes attributes) {
        return "login";
    }

    @GetMapping(value={"/error.html", "/error"})
    ModelAndView getErrorPage() {
        return new ModelAndView("error.html");
    }

    @GetMapping(value={"/control/**"})
    public void getControlPage(HttpServletRequest request, HttpServletResponse response, Locale locale) throws IOException {
        this.writeAngularRespnse("control", request, response);
    }

    @GetMapping(value={"/watchman/**"})
    public void getWatchmanPage(HttpServletRequest request, HttpServletResponse response, Locale locale) throws IOException {
        this.writeAngularRespnse("watchman", request, response);
    }

    private void writeAngularRespnse(String appName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String resourcePath = StringUtils.substringAfter((String)request.getRequestURI(), (String)appName);
        resourcePath = StringUtils.strip((String)resourcePath, (String)"/");
        log.trace("Requested resource path is '{}/{}'", (Object)appName, (Object)resourcePath);
        if (StringUtils.isBlank((CharSequence)resourcePath)) {
            this.redirectToLocalizedApp(appName, request, response, "");
            return;
        }
        String directResourcePath = UriComponentsBuilder.fromUriString((String)"classpath:/apps").pathSegment(new String[]{appName, resourcePath}).build().toString();
        Resource resource = this.resourceLoader.getResource(directResourcePath);
        if (resource.exists() && IndexController.isFile((String)resource.getFilename())) {
            log.trace("Loading direct resource {}/{}", (Object)appName, (Object)resourcePath);
            this.writeResourceToResponse(resource, request, response);
            return;
        }
        log.debug("Angular resource '{}/{}' was not found.", (Object)appName, (Object)resourcePath);
        AngularAppPath angularPath = new AngularAppPath(resourcePath);
        String pathLocaleCandidate = angularPath.getFirstSegment();
        String appLocalizedRootDirectory = UriComponentsBuilder.fromPath((String)"classpath:/apps").pathSegment(new String[]{appName, pathLocaleCandidate}).build().toString();
        Resource appDirectoryResource = this.resourceLoader.getResource(appLocalizedRootDirectory);
        if (appDirectoryResource.exists() && IndexController.isDirectory((String)appDirectoryResource.getFilename())) {
            angularPath.removeFirstSegment();
            log.trace("Application locale '{}' exists but not file '{}'. Serving index.html.", (Object)pathLocaleCandidate, (Object)angularPath.getPath());
            String indexPath = UriComponentsBuilder.fromPath((String)"classpath:/apps").pathSegment(new String[]{appName, pathLocaleCandidate, "index.html"}).build().toString();
            Resource indexResource = this.resourceLoader.getResource(indexPath);
            this.writeResourceToResponse(indexResource, request, response);
        } else {
            this.redirectToLocalizedApp(appName, request, response, angularPath.toString());
        }
    }

    private void redirectToLocalizedApp(String appName, HttpServletRequest request, HttpServletResponse response, String inAppPath) throws IOException {
        String localizedPathPart = this.findAngularAppLocalizedPathPart(appName, request.getLocales());
        log.trace("Path locale is not provided. Redirecting to '{}/{}' based on browser settings.", (Object)appName, (Object)localizedPathPart);
        String redirectPath = UriComponentsBuilder.fromUriString((String)"/").pathSegment(new String[]{appName, localizedPathPart, inAppPath}).query(request.getQueryString()).build().toString();
        response.sendRedirect(redirectPath);
    }

    private void writeResourceToResponse(Resource resource, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Matcher matcher;
        String resourceFileName = resource.getFilename();
        Optional<String> detectedMimeType = Optional.ofNullable(request.getServletContext().getMimeType(resource.getFilename())).or(() -> {
            Optional<Object> mimeType = Optional.empty();
            if (resourceFileName.endsWith(".ico")) {
                mimeType = Optional.of("image/x-icon");
            } else if (resourceFileName.endsWith(".js.map")) {
                mimeType = Optional.of("application/json");
            } else if (resourceFileName.endsWith(".webmanifest")) {
                mimeType = Optional.of("application/manifest+json");
            }
            return mimeType;
        });
        if (detectedMimeType.isEmpty()) {
            log.error("Mime type for file '{}' was not detected.", (Object)resourceFileName);
        }
        String mimeType = detectedMimeType.orElse("application/octet-stream");
        response.setContentType(mimeType);
        String acceptEncoding = StringUtils.lowerCase((String)request.getHeader("Accept-Encoding"));
        if (StringUtils.isNotBlank((CharSequence)acceptEncoding)) {
            for (Map.Entry codingEntry : this.encodingExtensions.entrySet()) {
                Resource encoded;
                String encodingName = (String)codingEntry.getKey();
                String extension = (String)codingEntry.getValue();
                if (!acceptEncoding.contains(encodingName) || !(encoded = resource.createRelative(resource.getFilename() + extension)).exists()) continue;
                response.addHeader("Content-Encoding", encodingName);
                resource = encoded;
                break;
            }
        }
        if ((matcher = RESOURCE_WITH_HASH.matcher(resourceFileName)).matches() || matcher.find()) {
            response.addHeader("Cache-Control", "max-age=31536000,immutable");
        } else if (mimeType.startsWith("image")) {
            response.addHeader("Cache-Control", "max-age=1209600");
        } else {
            response.addHeader("Cache-Control", "no-cache");
        }
        log.atTrace().setMessage("Served resource {}. Mime type: {}, Cache control: {}").addArgument((Object)resourceFileName).addArgument((Object)mimeType).addArgument(() -> response.getHeader("Cache-Control")).log();
        response.setContentLength((int)resource.contentLength());
        IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)response.getOutputStream());
    }

    private String findAngularAppLocalizedPathPart(String appName, Enumeration<Locale> locales) {
        String appPrefix = "classpath:/apps/" + appName + "/";
        String separator = "_";
        Object localizedPathPart = null;
        Resource resource = null;
        while (locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            if (locale != null) {
                String location;
                String lang = locale.getLanguage();
                String country = locale.getCountry();
                String variant = locale.getVariant();
                if (variant.length() > 0) {
                    localizedPathPart = lang + separator + country + separator + variant;
                    location = appPrefix + (String)localizedPathPart;
                    resource = this.resourceLoader.getResource(location);
                }
                if (!(resource != null && resource.exists() || country.length() <= 0)) {
                    localizedPathPart = lang + separator + country;
                    location = appPrefix + (String)localizedPathPart;
                    resource = this.resourceLoader.getResource(location);
                }
                if (!(resource != null && resource.exists() || lang.length() <= 0)) {
                    localizedPathPart = lang;
                    location = appPrefix + (String)localizedPathPart;
                    resource = this.resourceLoader.getResource(location);
                }
            }
            if (!resource.exists()) continue;
            break;
        }
        if (resource == null || !resource.exists()) {
            localizedPathPart = "en";
        }
        return localizedPathPart;
    }

    private static boolean isDirectory(String fileName) {
        return FilenameUtils.getExtension((String)fileName).isEmpty();
    }

    private static boolean isFile(String fileName) {
        return !FilenameUtils.getExtension((String)fileName).isEmpty();
    }
}

