/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.repositories.fw_update;

import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.download.DownloadEntry;
import de.rtb.pcon.model.download.DownloadStatus;
import de.rtb.pcon.model.download.DownloadTarget;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface DownloadEntryRepository
extends JpaRepository<DownloadEntry, Integer> {
    @Query(value="SELECT max(pdm.pdm_id) AS pdm_id\nFROM control.download_entry\nJOIN control.download_plan ON download_plan.dwp_id = download_entry.dwe_plan_id\nJOIN control.pdm AS pdm ON pdm.pdm_id = download_entry.dwe_pdm_id\nJOIN control.hw_device ON hw_device.pdm_id = pdm.pdm_id\nWHERE\ndwe_status IN ('QUEUED', 'IN_PROGRESS')\nAND target = 'PDM'\nAND part_model like 'PDM5%'\nAND dwp_upload_date_time < now()\nGROUP BY pdm.pdm_id\nHAVING max(dwe_status) = 'QUEUED'\nORDER BY pdm_id", nativeQuery=true)
    public List<Integer> listPdmIdWdithPlannedUpdate();

    default public List<Pdm> listPdmWithPlannedUpdate() {
        return List.of();
    }

    @Query(value="SELECT CONCAT(p.number, '@', a.id) AS pdm_label FROM Pdm p LEFT JOIN p.zone.area a WHERE p.id in :ids ORDER by a.id, p.number")
    public List<String> listSortedPdmLabels(@Param(value="ids") Collection<Integer> var1);

    @Query(value="SELECT d\n  FROM DownloadEntry d\n  WHERE\n  d.pdm.id = :pdmId\n  AND d.status = :dsQueued\n  AND d.plan.downloadTime < offset_datetime()")
    public List<DownloadEntry> findEntriesReadyToBeDownloadedForPdm(@Param(value="pdmId") int var1, @Param(value="dsQueued") DownloadStatus var2);

    default public List<DownloadEntry> findEntriesReadyToBeDownloadedForPdm(int pdm) {
        return this.findEntriesReadyToBeDownloadedForPdm(pdm, DownloadStatus.QUEUED);
    }

    @Modifying
    @Query(value="UPDATE DownloadEntry d\nSET d.status = :status\nWHERE d IN (:entries)")
    public void setEntriesStatus(@Param(value="entries") Collection<DownloadEntry> var1, @Param(value="status") DownloadStatus var2);

    @Query(value="FROM DownloadEntry\nWHERE\nplan.enabled = true\nAND status = :dsQueued\nAND pdm = :pdm\nAND plan.downloadTime < offset_datetime()")
    public List<DownloadEntry> availableDownloads(@Param(value="pdm") Pdm var1, @Param(value="dsQueued") DownloadStatus var2);

    default public List<DownloadEntry> availableDownloads(Pdm pdm) {
        return this.availableDownloads(pdm, DownloadStatus.QUEUED);
    }

    @Query(value="FROM DownloadEntry\nWHERE\nstatus in (:dsQueued, :dsInProgress)\nAND plan.downloadTarget = :target\nAND pdm = :pdm\nORDER by status DESC")
    public List<DownloadEntry> availableDownloadsForTarget(@Param(value="pdm") Pdm var1, @Param(value="target") DownloadTarget var2, @Param(value="dsQueued") DownloadStatus var3, @Param(value="dsInProgress") DownloadStatus var4, Pageable var5);

    default public List<DownloadEntry> availableDownloadsForTarget(Pdm pdm, DownloadTarget target, Pageable pageable) {
        return this.availableDownloadsForTarget(pdm, target, DownloadStatus.QUEUED, DownloadStatus.IN_PROGRESS, pageable);
    }

    default public Optional<DownloadEntry> nextAvailableDownloadForTarget(Pdm pdm, DownloadTarget target) {
        return this.availableDownloadsForTarget(pdm, target, (Pageable)PageRequest.of((int)0, (int)1)).stream().findFirst();
    }

    @Query(value="FROM DownloadEntry d\nWHERE\n d.status = :dsActivated\n AND d.plan.downloadTarget = :target\n AND d.pdm = :pdm\nORDER by d.activationConfirmation DESC")
    public List<DownloadEntry> lastActivatedEntries(@Param(value="pdm") Pdm var1, @Param(value="target") DownloadTarget var2, @Param(value="dsActivated") DownloadStatus var3, Pageable var4);

    default public List<DownloadEntry> lastActivatedEntries(Pdm pdm, DownloadTarget target, Pageable pageable) {
        return this.lastActivatedEntries(pdm, target, DownloadStatus.ACTIVATED, pageable);
    }

    default public Optional<DownloadEntry> lastActivatedEntry(Pdm pdm, DownloadTarget target) {
        return this.lastActivatedEntries(pdm, target, (Pageable)PageRequest.of((int)0, (int)1)).stream().findFirst();
    }

    @Query(value="FROM DownloadEntry d\nWHERE d.pdm=:pdm\n  AND d.status = :dsTransferred\n  AND d.plan.downloadTarget in(:targets)")
    public List<DownloadEntry> transferedForTargets(@Param(value="pdm") Pdm var1, @Param(value="targets") Collection<DownloadTarget> var2, @Param(value="dsTransferred") DownloadStatus var3);

    default public List<DownloadEntry> transferedForTargets(Pdm pdm, Collection<DownloadTarget> targets) {
        return this.transferedForTargets(pdm, targets, DownloadStatus.TRANSFERRED);
    }

    @Query(value="FROM DownloadEntry\nWHERE status = :status\nAND plan.downloadTarget = :target\nAND pdm = :pdm")
    public Optional<DownloadEntry> findByPdmAndTargetAndStatus(@Param(value="pdm") Pdm var1, @Param(value="target") DownloadTarget var2, @Param(value="status") DownloadStatus var3);

    @Query(value="FROM #{#entityName} WHERE pdm = :pdm AND status <= :dsTransferred")
    public List<DownloadEntry> planedForPdm(@Param(value="pdm") Pdm var1, @Param(value="dsTransferred") DownloadStatus var2);

    default public List<DownloadEntry> planedForPdm(Pdm pdm) {
        return this.planedForPdm(pdm, DownloadStatus.TRANSFERRED);
    }

    @Query(value="FROM DownloadEntry de\nJOIN FETCH de.plan p\nLEFT JOIN FETCH p.softwareDescription\nWHERE de.pdm = ?1\nORDER BY p.id DESC")
    public List<DownloadEntry> historyForPdm(Pdm var1);
}

