/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.repositories;

import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentTransactionId;
import de.rtb.pcon.model.Pdm;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface PaymentTransactionRepository
extends JpaRepository<PaymentTransaction, PaymentTransactionId>,
JpaSpecificationExecutor<PaymentTransaction> {
    public Slice<PaymentTransaction> findByIdPdmAndIdPdmTimeAfter(Pdm var1, OffsetDateTime var2, Pageable var3);

    public Optional<PaymentTransaction> findByIdPdmTimeAndIdPdm(OffsetDateTime var1, Pdm var2);

    @Query(value="FROM #{#entityName} WHERE id.pdm = :pdm AND id.pdmTime = :payTime AND ticketNumber = :ticketNumber")
    public Optional<PaymentTransaction> findByPdmAndTicket(Pdm var1, OffsetDateTime var2, int var3);

    @Query(value="FROM #{#entityName}\nWHERE id.pdm = :pdm AND id.pdmTime >= :from AND id.pdmTime < :to\nORDER BY serverTime")
    public List<PaymentTransaction> findforPdmAndTimeBetween(@Param(value="pdm") Pdm var1, @Param(value="from") OffsetDateTime var2, @Param(value="to") OffsetDateTime var3);

    public long countByIdPdmAndPaymentReasonAndIdPdmTimeBetween(Pdm var1, PaymentReason var2, OffsetDateTime var3, OffsetDateTime var4);

    public Optional<PaymentTransaction> findByIdPdmAndTicketNumberAndIdPdmTimeBetween(Pdm var1, int var2, OffsetDateTime var3, OffsetDateTime var4);

    @Query(value="FROM #{#entityName} WHERE id.pdm.zone.area = :area AND lpn = :lpn AND id.pdmTime >= :fromTs AND id.pdmTime < :toTs")
    public Slice<PaymentTransaction> findInAreaWithLpn(Area var1, String var2, OffsetDateTime var3, OffsetDateTime var4, Pageable var5);
}

