/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.model.download;

import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.download.DownloadEntry;
import de.rtb.pcon.model.download.DownloadTarget;
import de.rtb.pcon.model.download.SoftwareDescription;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.List;
import org.hibernate.annotations.JdbcType;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;

@Entity
@Table(name="download_plan", schema="control")
public class DownloadPlan {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="dwp_id")
    private Integer id;
    @Column(name="dwp_name")
    private String name;
    @Column(name="dwp_note")
    private String note;
    @Column(name="dwp_upload_date_time")
    private OffsetDateTime downloadTime;
    @Column(name="dwp_activation_date")
    private LocalDate activationDate;
    @Column(name="dwp_enabled")
    private boolean enabled;
    @Column(name="dwp_visible")
    private boolean visible;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dwp_area_id")
    private Area area;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dwp_sw_desc_id")
    private SoftwareDescription softwareDescription;
    @Column(name="dwp_target", columnDefinition="\"control\".\"download_target\"\n")
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private DownloadTarget downloadTarget;
    @OneToMany(mappedBy="plan")
    private List<DownloadEntry> entries;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dwp_modified_by")
    private User modifiedBy;
    @Column(name="dwp_modified_at")
    private OffsetDateTime modifiedAt;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String description) {
        this.note = description;
    }

    public OffsetDateTime getDownloadTime() {
        return this.downloadTime;
    }

    public void setDownloadTime(OffsetDateTime downloadTime) {
        this.downloadTime = downloadTime;
    }

    public LocalDate getActivationDate() {
        return this.activationDate;
    }

    public void setActivationDate(LocalDate activationDate) {
        this.activationDate = activationDate;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Area getArea() {
        return this.area;
    }

    public void setArea(Area area) {
        this.area = area;
    }

    public SoftwareDescription getSoftwareDescription() {
        return this.softwareDescription;
    }

    public void setSoftwareDescription(SoftwareDescription softwareDescription) {
        this.softwareDescription = softwareDescription;
    }

    public DownloadTarget getDownloadTarget() {
        return this.downloadTarget;
    }

    public void setDownloadTarget(DownloadTarget downloadTarget) {
        this.downloadTarget = downloadTarget;
    }

    public List<DownloadEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<DownloadEntry> entries) {
        this.entries = entries;
    }

    public User getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(User editor) {
        this.modifiedBy = editor;
    }

    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }
}

