/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.model.download;

import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.download.DownloadPlan;
import de.rtb.pcon.model.download.DownloadStatus;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.OffsetDateTime;
import org.hibernate.annotations.JdbcType;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="download_entry", schema="control")
public class DownloadEntry {
    public static final String DEFAULT_PATH = "";
    public static final String PATH_DELIMITER = "/";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="dwe_id")
    private Integer id;
    @ManyToOne
    @JoinColumn(name="dwe_pdm_id")
    private Pdm pdm;
    @Column(name="dwe_download")
    private OffsetDateTime downloadConfirmation;
    @Column(name="dwe_activation")
    private OffsetDateTime activationConfirmation;
    @Column(name="dwe_status", columnDefinition="\"control\".\"download_status\"\n")
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private DownloadStatus status;
    @Column(name="dwe_path")
    private String path;
    @ManyToOne
    @JoinColumn(name="dwe_plan_id")
    private DownloadPlan plan;

    public static DownloadEntry simple(DownloadPlan plan, Pdm pdm) {
        DownloadEntry de = new DownloadEntry();
        de.pdm = pdm;
        de.downloadConfirmation = null;
        de.activationConfirmation = null;
        de.status = DownloadStatus.QUEUED;
        de.path = "";
        de.plan = plan;
        return de;
    }

    public static DownloadEntry withPath(DownloadPlan plan, Pdm pdm) {
        DownloadEntry de = DownloadEntry.simple((DownloadPlan)plan, (Pdm)pdm);
        de.path = pdm.getZone().getArea().getId() + "/" + pdm.getNumber();
        return de;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Pdm getPdm() {
        return this.pdm;
    }

    public void setPdm(Pdm pdm) {
        this.pdm = pdm;
    }

    public OffsetDateTime getDownloadConfirmation() {
        return this.downloadConfirmation;
    }

    public void setDownloadConfirmation(OffsetDateTime downloadConfirmation) {
        this.downloadConfirmation = downloadConfirmation;
    }

    public OffsetDateTime getActivationConfirmation() {
        return this.activationConfirmation;
    }

    public void setActivationConfirmation(OffsetDateTime activationConfirmation) {
        this.activationConfirmation = activationConfirmation;
    }

    public DownloadStatus getStatus() {
        return this.status;
    }

    public void setStatus(DownloadStatus status) {
        this.status = status;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DownloadPlan getPlan() {
        return this.plan;
    }

    public void setPlan(DownloadPlan downloadPlan) {
        this.plan = downloadPlan;
    }
}

