/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.model;

import de.rtb.pcon.db.converter.MinuteDurationConverter;
import de.rtb.pcon.model.NetworkType;
import de.rtb.pcon.model.Pdm;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.Duration;
import java.time.OffsetDateTime;
import org.hibernate.annotations.JdbcType;
import org.hibernate.annotations.UpdateTimestamp;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;

@Entity
@Table(name="pdm_runtime", schema="control")
public class PdmRuntimeMonitor {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pdm_id")
    private Pdm pdm;
    @Column(name="online")
    private Boolean online;
    @Column(name="kal_inerval")
    @Convert(converter=MinuteDurationConverter.class)
    private Duration keepAliveInterval;
    @Column(name="kal_time")
    private OffsetDateTime lastKeepAlive;
    @Column(name="pay_time")
    private OffsetDateTime payTime;
    @Column(name="pay_tracer")
    private Integer payTracer;
    @Column(name="sta_time")
    private OffsetDateTime staTime;
    @Column(name="sta_tracer")
    private Integer staTracer;
    @Column(name="sys_time")
    private OffsetDateTime sysTime;
    @Column(name="sys_tracer")
    private Integer sysTracer;
    @Column(name="clr_time")
    private OffsetDateTime clrTime;
    @Column(name="clr_tracer")
    private Integer clrTracer;
    @Column(name="service")
    private OffsetDateTime lastService;
    @Column(name="net_signal")
    private Integer netSignal;
    @Column(name="net_type", columnDefinition="\"control\".\"network_type\"\n")
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private NetworkType netType;
    @Column(name="net_login")
    private OffsetDateTime netLogin;
    @Column(name="pow_time")
    private OffsetDateTime powerTime;
    @Column(name="pow_voltage")
    private Float powerVoltage;
    @Column(name="pow_mcs_sol")
    private Float powMcsSol;
    @Column(name="pow_sven_bat")
    private Float powSvenBat;
    @Column(name="pow_sven_in")
    private Float powSvenIn;
    @Column(name="last_contact")
    @UpdateTimestamp
    private OffsetDateTime lastContact;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Pdm getPdm() {
        return this.pdm;
    }

    public void setPdm(Pdm pdm) {
        this.pdm = pdm;
    }

    public Boolean getOnline() {
        return this.online;
    }

    public void setOnline(Boolean online) {
        this.online = online;
    }

    public Duration getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(Duration keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public OffsetDateTime getLastKeepAlive() {
        return this.lastKeepAlive;
    }

    public void setLastKeepAlive(OffsetDateTime lastKeepAlive) {
        this.lastKeepAlive = lastKeepAlive;
    }

    public OffsetDateTime getPayTime() {
        return this.payTime;
    }

    public void setPayTime(OffsetDateTime payTime) {
        this.payTime = payTime;
    }

    public Integer getPayTracer() {
        return this.payTracer;
    }

    public void setPayTracer(Integer payTracer) {
        this.payTracer = payTracer;
    }

    public OffsetDateTime getStaTime() {
        return this.staTime;
    }

    public void setStaTime(OffsetDateTime staTime) {
        this.staTime = staTime;
    }

    public Integer getStaTracer() {
        return this.staTracer;
    }

    public void setStaTracer(Integer staTracer) {
        this.staTracer = staTracer;
    }

    public OffsetDateTime getSysTime() {
        return this.sysTime;
    }

    public void setSysTime(OffsetDateTime sysTime) {
        this.sysTime = sysTime;
    }

    public Integer getSysTracer() {
        return this.sysTracer;
    }

    public void setSysTracer(Integer sysTracer) {
        this.sysTracer = sysTracer;
    }

    public OffsetDateTime getClrTime() {
        return this.clrTime;
    }

    public void setClrTime(OffsetDateTime clrTime) {
        this.clrTime = clrTime;
    }

    public Integer getClrTracer() {
        return this.clrTracer;
    }

    public void setClrTracer(Integer clrTracer) {
        this.clrTracer = clrTracer;
    }

    public OffsetDateTime getLastService() {
        return this.lastService;
    }

    public void setLastService(OffsetDateTime lastService) {
        this.lastService = lastService;
    }

    public Integer getNetSignal() {
        return this.netSignal;
    }

    public void setNetSignal(Integer netSignal) {
        this.netSignal = netSignal;
    }

    public OffsetDateTime getNetLogin() {
        return this.netLogin;
    }

    public void setNetLogin(OffsetDateTime netLastLogin) {
        this.netLogin = netLastLogin;
    }

    public NetworkType getNetType() {
        return this.netType;
    }

    public void setNetType(NetworkType netType) {
        this.netType = netType;
    }

    public OffsetDateTime getPowerTime() {
        return this.powerTime;
    }

    public void setPowerTime(OffsetDateTime powerTime) {
        this.powerTime = powerTime;
    }

    public Float getPowerVoltage() {
        return this.powerVoltage;
    }

    public void setPowerVoltage(Float powerVoltage) {
        this.powerVoltage = powerVoltage;
    }

    public Float getPowMcsSol() {
        return this.powMcsSol;
    }

    public void setPowMcsSol(Float powerIn) {
        this.powMcsSol = powerIn;
    }

    public Float getPowSvenBat() {
        return this.powSvenBat;
    }

    public void setPowSvenBat(Float powerOut) {
        this.powSvenBat = powerOut;
    }

    public Float getPowSvenIn() {
        return this.powSvenIn;
    }

    public void setPowSvenIn(Float powSvenIn) {
        this.powSvenIn = powSvenIn;
    }

    public OffsetDateTime getLastContact() {
        return this.lastContact;
    }

    public void setLastContact(OffsetDateTime lastContact) {
        this.lastContact = lastContact;
    }
}

