/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.model;

import de.rtb.pcon.model.AccuLevel;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PdmHwDevice;
import de.rtb.pcon.model.PdmOperationalMode;
import de.rtb.pcon.model.PdmStatus;
import de.rtb.pcon.model.StatusMessage;
import de.rtb.pcon.model.TariffInfo;
import de.rtb.pcon.model.clearing.Clearing;
import de.rtb.pcon.model.zone.Zone;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedEntityGraphs;
import jakarta.persistence.NamedSubgraph;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.Table;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.JdbcType;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;

@NamedEntityGraphs(value={@NamedEntityGraph(name="Pdm.Zone.Area", attributeNodes={@NamedAttributeNode(value="zone", subgraph="zoneArea")}, subgraphs={@NamedSubgraph(name="zoneArea", attributeNodes={@NamedAttributeNode(value="area")})}), @NamedEntityGraph(name="Pdm.Devices+Area", attributeNodes={@NamedAttributeNode(value="zone", subgraph="zoneArea"), @NamedAttributeNode(value="devices")}, subgraphs={@NamedSubgraph(name="zoneArea", attributeNodes={@NamedAttributeNode(value="area")})})})
@Entity
@Table(name="pdm", schema="control")
public class Pdm {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="pdm_id", nullable=false)
    private Integer id;
    @Column(name="pdm_number", nullable=true)
    private Integer number;
    @Column(name="pdm_name", nullable=true, length=30)
    private String name;
    @Column(name="pdm_phone_number", nullable=true, length=40)
    private String phoneNumber;
    @Column(name="pdm_lat")
    private Double latitude;
    @Column(name="pdm_lon")
    private Double longitude;
    @Column(name="pdm_operational_mode")
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private PdmOperationalMode opMode;
    @OneToMany(mappedBy="pdm")
    private Set<AccuLevel> accuLevels;
    @OneToMany(mappedBy="pdm")
    private Set<PdmStatus> statuses;
    @OneToMany(mappedBy="pdm")
    private Set<StatusMessage> statusMessages;
    @OneToMany(mappedBy="id.pdm")
    private Set<PaymentTransaction> payments;
    @OneToMany(mappedBy="pdm")
    private Set<Clearing> clearings;
    @OneToMany(mappedBy="pdm")
    private List<PdmHwDevice> devices;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pdm_zone_id")
    private Zone zone;
    @OneToMany
    @JoinTable(name="pdm_x_tariff_info", schema="control", joinColumns={@JoinColumn(name="pti_pdm_id")}, inverseJoinColumns={@JoinColumn(name="pti_tariff_info_id")})
    @OrderColumn(name="pti_tariff_order")
    private List<TariffInfo> tariffInfos;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    public PdmOperationalMode getOpMode() {
        return this.opMode;
    }

    public void setOpMode(PdmOperationalMode serviceMode) {
        this.opMode = serviceMode;
    }

    public Set<AccuLevel> getAccuLevels() {
        return this.accuLevels;
    }

    public void setAccuLevels(Set<AccuLevel> accuLevels) {
        this.accuLevels = accuLevels;
    }

    public Set<PdmStatus> getStatuses() {
        return this.statuses;
    }

    public void setStatuses(Set<PdmStatus> statuses) {
        this.statuses = statuses;
    }

    public Set<StatusMessage> getStatusMessages() {
        return this.statusMessages;
    }

    public void setStatusMessages(Set<StatusMessage> logbooks) {
        this.statusMessages = logbooks;
    }

    public Set<PaymentTransaction> getPayments() {
        return this.payments;
    }

    public void setPayments(Set<PaymentTransaction> payments) {
        this.payments = payments;
    }

    public Set<Clearing> getClearings() {
        return this.clearings;
    }

    public void setClearings(Set<Clearing> clearings) {
        this.clearings = clearings;
    }

    public Zone getZone() {
        return this.zone;
    }

    public void setZone(Zone zone) {
        this.zone = zone;
    }

    public List<TariffInfo> getTariffInfos() {
        return this.tariffInfos;
    }

    public void setTariffInfos(List<TariffInfo> tariffInfos) {
        this.tariffInfos = tariffInfos;
    }

    public List<PdmHwDevice> getDevices() {
        return this.devices;
    }

    public void setDevices(List<PdmHwDevice> devices) {
        this.devices = devices;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE);
        tsb.append("id", (Object)this.getId());
        tsb.append("name", (Object)this.getName());
        tsb.append((Object)("(" + this.getNumber() + "@" + String.valueOf(this.getZone().getArea()) + ")"));
        return tsb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pdm other = (Pdm)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

