/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.touchnet;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.touchnet.OneCardApiService;
import de.rtb.pcon.features.partners.touchnet.OneCardConfigDto;
import de.rtb.pcon.features.partners.touchnet.OneCardConfigService;
import de.rtb.pcon.features.partners.touchnet.OneCardException;
import de.rtb.pcon.features.partners.touchnet.OneCardTransactionStatusBaseResponse;
import de.rtb.pcon.features.partners.touchnet.OneCardTransactionStatusInquiryResponse;
import de.rtb.pcon.features.partners.touchnet.OneCardTransactionStatusVendMoneyResponse;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;

@Component
class OneCardRtrTransactionResult
implements RealTimeRequest {
    private final OneCardConfigService configService;
    private final OneCardApiService apiService;

    public OneCardRtrTransactionResult(OneCardConfigService configService, OneCardApiService apiService) {
        this.configService = configService;
        this.apiService = apiService;
    }

    public int getId() {
        return 49;
    }

    public String getDescription() {
        return "OneCard, transaction result";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        OneCardConfigDto config = (OneCardConfigDto)this.configService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        String sessionId = ctx.getLocalString("sessionId");
        String oneCardPreInitTransID = ctx.getLocalString("oneCardTransId");
        Pdm pdm = ctx.findPdmEntity();
        try {
            OneCardTransactionStatusBaseResponse apiResutl = this.apiService.transactionResult(pdm, sessionId, oneCardPreInitTransID);
            HashMap<String, Object> pdmResp = new HashMap<String, Object>();
            pdmResp.put("completed", apiResutl.isCompleted());
            if (apiResutl instanceof OneCardTransactionStatusInquiryResponse) {
                OneCardTransactionStatusInquiryResponse inq = (OneCardTransactionStatusInquiryResponse)apiResutl;
                pdmResp.put("resultType", "Inquiry");
                pdmResp.put("balanceNoCredit", inq.getResult().getBalanceNoCredit());
            } else if (apiResutl instanceof OneCardTransactionStatusVendMoneyResponse) {
                OneCardTransactionStatusVendMoneyResponse vm = (OneCardTransactionStatusVendMoneyResponse)apiResutl;
                pdmResp.put("resultType", "VendMoney");
                pdmResp.put("balanceNoCredit", vm.getResult().getBalanceNoCredit());
                pdmResp.put("receipt", vm.getResult().getReceipt());
            } else {
                pdmResp = Map.of("ERC", 7, "ERM", "Result type of " + apiResutl.getClass().getSimpleName() + " is not supported.");
            }
            return pdmResp;
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
        catch (OneCardException e) {
            return e.toPdmMnemonicMap();
        }
    }
}

