/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.touchnet;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.touchnet.OneCardApiService;
import de.rtb.pcon.features.partners.touchnet.OneCardConfigDto;
import de.rtb.pcon.features.partners.touchnet.OneCardConfigService;
import de.rtb.pcon.features.partners.touchnet.OneCardException;
import de.rtb.pcon.features.partners.touchnet.OneCardInquiryResponse;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;

@Component
class OneCardRtrInquiryBalance
implements RealTimeRequest {
    private final OneCardConfigService configService;
    private final OneCardApiService apiService;

    public OneCardRtrInquiryBalance(OneCardConfigService configService, OneCardApiService apiService) {
        this.configService = configService;
        this.apiService = apiService;
    }

    public int getId() {
        return 47;
    }

    public String getDescription() {
        return "OneCard, inquiry balance";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        OneCardConfigDto config = (OneCardConfigDto)this.configService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        String sessionId = ctx.getLocalString("sessionId");
        Optional oneCardTransId = ctx.getLocalStringO("oneCardTransId");
        String accountId = ctx.getLocalString("accountId");
        String tranType = ctx.getLocalString("accountType");
        Integer queryType = ctx.getLocalIntegerO("tranType").orElse(12);
        Integer decimalScale = ctx.global().getDpa();
        Optional<BigDecimal> amount = ctx.getLocalIntegerO("bet").map(bet -> BigDecimal.valueOf(bet.intValue(), decimalScale));
        Pdm pdm = ctx.findPdmEntity();
        try {
            OneCardInquiryResponse apiResponse = this.apiService.queryBalance(pdm, sessionId, oneCardTransId, accountId, tranType, queryType, amount);
            return Map.of("balanceNoCredit", apiResponse.getResult().getBalanceNoCredit().scaleByPowerOfTen(decimalScale).intValue(), "oneCardTransId", apiResponse.getOneCardTransId());
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
        catch (OneCardException e) {
            return e.toPdmMnemonicMap();
        }
    }
}

