/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.touchnet;

import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.features.partners.touchnet.OneCardConfigDto;
import de.rtb.pcon.features.partners.touchnet.OneCardConfigService;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pcon/ui/areas/{id}/partners/one-card"})
class OneCardController {
    private final OneCardConfigService cfgService;
    private final SecureEntityLoaderService entityLoader;

    public OneCardController(OneCardConfigService cfgService, SecureEntityLoaderService entityLoader) {
        this.cfgService = cfgService;
        this.entityLoader = entityLoader;
    }

    @GetMapping(value={"config"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional(readOnly=true)
    public OneCardConfigDto getConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        OneCardConfigDto config = (OneCardConfigDto)this.cfgService.fetchConfig(area);
        return new OneCardConfigDto(config.enabled(), config.baseUrl(), config.operatorId(), config.operatorPassword());
    }

    @PostMapping(value={"config"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional
    public void setConfig(@PathVariable(value="id") Integer areaId, @RequestBody OneCardConfigDto config) {
        Area area = this.entityLoader.loadArea(areaId.intValue());
        OneCardConfigDto newConfig = new OneCardConfigDto(config.enabled(), StringUtils.removeEnd((String)config.baseUrl(), (String)"/"), config.operatorId(), config.operatorPassword());
        this.cfgService.updateConfig(area, (PartnerConfiguration)newConfig);
    }
}

