/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.satispay;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;

class SatispayUtils {
    private SatispayUtils() {
    }

    public static String formatKey(String base64Key, String keyMarker) {
        if (base64Key.isEmpty()) {
            return "";
        }
        String newline = System.lineSeparator();
        StringBuilder sb = new StringBuilder(1000);
        sb.append("-----BEGIN ");
        sb.append(keyMarker.toUpperCase());
        sb.append(" KEY-----");
        sb.append(newline);
        String formattedKey = base64Key.replaceAll("(.{64})", "$1" + newline);
        sb.append(formattedKey);
        sb.append(newline);
        sb.append("-----END ");
        sb.append(keyMarker.toUpperCase());
        sb.append(" KEY-----");
        sb.append(newline);
        return sb.toString();
    }

    public static PrivateKey readPrivateKey(String base64PrivateKey) {
        byte[] privateKeyBytes = Base64.getDecoder().decode(base64PrivateKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalStateException("Can not read private key", e);
        }
    }

    public static String signData(String message, PrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] signatureBytes = signature.sign();
            return Base64.getEncoder().encodeToString(signatureBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IllegalStateException("Can not sign Satispay message", e);
        }
    }

    public static String createDigest(String body) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = messageDigest.digest(body.getBytes(StandardCharsets.UTF_8));
            return "SHA-256=" + Base64.getEncoder().encodeToString(hashBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Digest SHA-256 was not found in Java VM");
        }
    }

    public static String makeAuthorization(String keyId, String signature) {
        return String.format("Signature keyId=\"%s\", algorithm=\"rsa-sha256\", headers=\"(request-target) host date digest\", signature=\"%s\"", keyId, signature);
    }
}

