/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.satispay;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rtb.pcon.features.partners.satispay.SatispayConfigDto;
import de.rtb.pcon.features.partners.satispay.SatispayConfigService;
import de.rtb.pcon.features.partners.satispay.SatispayUtils;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.math.BigDecimal;
import java.net.URI;
import java.security.PrivateKey;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.fellbaum.jemoji.EmojiManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
class SatispayService {
    private static final Logger log = LoggerFactory.getLogger(SatispayService.class);
    private final ObjectMapper objectMapper;
    private final RestClient restClient;
    private final SatispayConfigService satisPayConfigService;

    SatispayService(SatispayConfigService satisPayConfigService, ObjectMapper objectMapper, @Qualifier(value="wc3rdPartyApi") RestClient restClient) {
        this.satisPayConfigService = satisPayConfigService;
        this.objectMapper = objectMapper;
        this.restClient = restClient;
    }

    public Map<String, Object> createPayment(Pdm pdm, BigDecimal amount, String currency, String idempotencyKey, OffsetDateTime parkStart, OffsetDateTime parkEnd) {
        SatispayConfigDto config = (SatispayConfigDto)this.satisPayConfigService.fetchConfig(pdm.getZone().getArea());
        if (!config.enabled()) {
            return Map.of("ERC", 1, "ERM", "Satispay partner is disabled.");
        }
        SatispayConfigDto.SatispayKey key = Objects.requireNonNull(config.key(), "There is no Satispay key for Zone " + LoggerUtils.log((Zone)pdm.getZone()));
        String pureAreaName = EmojiManager.removeAllEmojis((String)pdm.getZone().getArea().getName());
        String purePdmName = EmojiManager.removeAllEmojis((String)pdm.getName());
        String externalCode = "Parking " + pureAreaName + ", " + purePdmName;
        ObjectNode metaData = this.objectMapper.createObjectNode();
        metaData.put("pdm_id", pdm.getId().toString());
        metaData.put("park_start", DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(parkStart));
        metaData.put("park_end", DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(parkEnd));
        ObjectNode reqBody = this.objectMapper.createObjectNode();
        reqBody.put("flow", "MATCH_CODE");
        reqBody.put("amount_unit", amount.scaleByPowerOfTen(2).intValue());
        reqBody.put("currency", currency);
        reqBody.put("external_code", externalCode);
        reqBody.put("callback_url", "");
        reqBody.put("redirect_url", "");
        reqBody.set("metadata", (JsonNode)metaData);
        URI serviceUri = UriComponentsBuilder.fromUri((URI)config.environment().endpoint()).pathSegment(new String[]{"g_business", "v1", "payments"}).build().encode().toUri();
        log.trace("Service URI {}", (Object)serviceUri);
        String body = reqBody.toString();
        String hDigest = SatispayUtils.createDigest((String)body);
        log.trace("Body {}, Digest {}", (Object)body, (Object)hDigest);
        String hDate = DateTimeFormatter.RFC_1123_DATE_TIME.format(OffsetDateTime.now());
        String messageToSign = "(request-target): post " + serviceUri.getPath() + "\nhost: " + serviceUri.getHost() + "\ndate: " + hDate + "\ndigest: " + hDigest;
        log.info("Message to sing {}", (Object)messageToSign);
        PrivateKey privateKey = SatispayUtils.readPrivateKey((String)key.privateKey());
        String signature = SatispayUtils.signData((String)messageToSign, (PrivateKey)privateKey);
        log.info("signature {}", (Object)signature);
        String hAuthorization = SatispayUtils.makeAuthorization((String)key.satispayId(), (String)signature);
        log.info("Authorization {}", (Object)hAuthorization);
        ResponseEntity responseEntity = (ResponseEntity)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(serviceUri)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON})).header("Host", new String[]{serviceUri.getHost()})).header("Date", new String[]{hDate})).header("Digest", new String[]{hDigest})).header("Idempotency-Key", new String[]{idempotencyKey})).header("Authorization", new String[]{hAuthorization})).body((Object)body).exchange(SatispayService.exchangeJsonSafeHeaders());
        JsonNode respBody = Objects.requireNonNull((JsonNode)responseEntity.getBody(), "Satispay response body is empty");
        SatispayService.removeUnwantedFieldsFromResponse((JsonNode)respBody);
        return Map.of("body", respBody, "statusCode", responseEntity.getStatusCode().value());
    }

    public Map<String, Object> getPayment(Pdm pdm, String paymentId, Optional<Integer> responseWaitTime) {
        Area area = pdm.getZone().getArea();
        SatispayConfigDto config = (SatispayConfigDto)this.satisPayConfigService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1, "ERM", "Satispay partner is disabled.");
        }
        SatispayConfigDto.SatispayKey key = Objects.requireNonNull(config.key(), "There is no Satispay key for Zone " + area.getId());
        URI serviceUri = UriComponentsBuilder.fromUri((URI)config.environment().endpoint()).pathSegment(new String[]{"g_business", "v1", "payments", paymentId}).build().encode().toUri();
        log.trace("Service URI {}", (Object)serviceUri);
        String hDigest = SatispayUtils.createDigest((String)"");
        log.trace("Digest of body {}", (Object)hDigest);
        String hHost = serviceUri.getHost();
        String hDate = DateTimeFormatter.RFC_1123_DATE_TIME.format(OffsetDateTime.now());
        String messageToSign = "(request-target): get " + serviceUri.getPath() + "\nhost: " + hHost + "\ndate: " + hDate + "\ndigest: " + hDigest;
        log.trace("Message to sign {}", (Object)messageToSign);
        PrivateKey privateKey = SatispayUtils.readPrivateKey((String)key.privateKey());
        String signature = SatispayUtils.signData((String)messageToSign, (PrivateKey)privateKey);
        log.trace("signature {}", (Object)signature);
        String hAuthorization = SatispayUtils.makeAuthorization((String)key.satispayId(), (String)signature);
        log.info("Authorization {}", (Object)hAuthorization);
        RestClient.RequestHeadersSpec req = this.restClient.get().uri(serviceUri).accept(new MediaType[]{MediaType.APPLICATION_JSON}).header("Host", new String[]{hHost}).header("Date", new String[]{hDate}).header("Digest", new String[]{hDigest}).header("Authorization", new String[]{hAuthorization});
        responseWaitTime.ifPresent(r -> req.header("x-satispay-response-wait-time", new String[]{r.toString()}));
        ResponseEntity responseEntity = (ResponseEntity)req.exchange(SatispayService.exchangeJsonSafeHeaders());
        log.trace("Response: {}", (Object)responseEntity);
        JsonNode respBody = Objects.requireNonNull((JsonNode)responseEntity.getBody(), "Satispay response body is empty");
        SatispayService.removeUnwantedFieldsFromResponse((JsonNode)respBody);
        return Map.of("body", respBody, "statusCode", responseEntity.getStatusCode().value());
    }

    public Map<String, Object> cancelPayment(Pdm pdm, String paymentId) {
        SatispayConfigDto config = (SatispayConfigDto)this.satisPayConfigService.fetchConfig(pdm.getZone().getArea());
        if (!config.enabled()) {
            return Map.of("ERC", 1, "ERM", "Satispay partner is disabled.");
        }
        SatispayConfigDto.SatispayKey key = Objects.requireNonNull(config.key(), "There is no Satispay key for Zone " + LoggerUtils.log((Zone)pdm.getZone()));
        ObjectNode reqBody = this.objectMapper.createObjectNode();
        reqBody.put("action", "CANCEL_OR_REFUND");
        URI serviceUri = UriComponentsBuilder.fromUri((URI)config.environment().endpoint()).pathSegment(new String[]{"g_business", "v1", "payments", paymentId}).build().encode().toUri();
        log.trace("Service URI {}", (Object)serviceUri);
        String body = reqBody.toString();
        String hDigest = SatispayUtils.createDigest((String)body);
        log.trace("Body {}, Digest {}", (Object)body, (Object)hDigest);
        String hDate = DateTimeFormatter.RFC_1123_DATE_TIME.format(OffsetDateTime.now());
        String messageToSign = "(request-target): put " + serviceUri.getPath() + "\nhost: " + serviceUri.getHost() + "\ndate: " + hDate + "\ndigest: " + hDigest;
        log.info("Message to sing {}", (Object)messageToSign);
        PrivateKey privateKey = SatispayUtils.readPrivateKey((String)key.privateKey());
        String signature = SatispayUtils.signData((String)messageToSign, (PrivateKey)privateKey);
        log.info("signature {}", (Object)signature);
        String hAuthorization = SatispayUtils.makeAuthorization((String)key.satispayId(), (String)signature);
        log.info("Authorization {}", (Object)hAuthorization);
        ResponseEntity responseEntity = (ResponseEntity)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.put().uri(serviceUri)).contentType(MediaType.APPLICATION_JSON).accept(new MediaType[]{MediaType.APPLICATION_JSON})).header("Host", new String[]{serviceUri.getHost()})).header("Date", new String[]{hDate})).header("Digest", new String[]{hDigest})).header("Authorization", new String[]{hAuthorization})).body((Object)body).exchange(SatispayService.exchangeJsonSafeHeaders());
        JsonNode respBody = Objects.requireNonNull((JsonNode)responseEntity.getBody(), "Satispay response body is empty");
        SatispayService.removeUnwantedFieldsFromResponse((JsonNode)respBody);
        return Map.of("body", respBody, "statusCode", responseEntity.getStatusCode().value());
    }

    static RestClient.RequestHeadersSpec.ExchangeFunction<ResponseEntity<JsonNode>> exchangeJsonSafeHeaders() {
        Set<String> badHeaders = Set.of("content-length", "date", "server", ":status");
        UnaryOperator filterHeaders = h -> {
            HttpHeaders nh = new HttpHeaders();
            h.forEach((key, value) -> {
                if (!badHeaders.contains(key.toLowerCase())) {
                    nh.put(key, value);
                }
            });
            return nh;
        };
        return (request, response) -> ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)response.getStatusCode()).headers((HttpHeaders)filterHeaders.apply(response.getHeaders()))).body((Object)((JsonNode)response.bodyTo(JsonNode.class)));
    }

    static void removeUnwantedFieldsFromResponse(JsonNode spResp) {
        if (spResp instanceof ObjectNode) {
            ObjectNode on = (ObjectNode)spResp;
            on.remove("redirect_url");
            on.remove("receiver");
            on.remove("description");
            on.remove("external_code");
            on.remove("metadata");
            on.remove("sender");
            on.remove("receiver");
        }
    }
}

