/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.satispay;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.satispay.SatispayService;
import de.rtb.pcon.model.Pdm;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
class SatispayGetPaymentRtr
implements RealTimeRequest {
    private final SatispayService satispayService;

    public SatispayGetPaymentRtr(SatispayService satispayService) {
        this.satispayService = satispayService;
    }

    public int getId() {
        return 70;
    }

    public String getDescription() {
        return "Satispay, Get payment";
    }

    @Transactional
    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Pdm pdm = ctx.findPdmEntity();
        String paymentId = ctx.getLocalString("paymentId");
        Optional responseWaitTime = ctx.getLocalIntegerO("responseWaitTime");
        return this.satispayService.getPayment(pdm, paymentId, responseWaitTime);
    }
}

