/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.rao;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.rao.RaoConfigDto;
import de.rtb.pcon.features.partners.rao.RaoConfigService;
import de.rtb.pcon.features.partners.rao.RaoPbaParkingZonesResponsePdmDao;
import de.rtb.pcon.features.partners.rao.RaoPbaParkingZonesResponseRaoDao;
import de.rtb.pcon.features.partners.rao.RaoProperties;
import de.rtb.pcon.features.partners.rao.RaoUtils;
import de.rtb.pcon.model.Area;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class RaoRtrPbaZones
implements RealTimeRequest {
    private final RestClient restClient;
    private final RaoConfigService raoConfigService;
    private final RaoProperties raoProps;

    RaoRtrPbaZones(@Qualifier(value="wc3rdPartyApi") RestClient restClient, RaoConfigService raoConfigService, RaoProperties raoProps) {
        this.restClient = restClient;
        this.raoConfigService = raoConfigService;
        this.raoProps = raoProps;
    }

    public int getId() {
        return 63;
    }

    public String getDescription() {
        return "RAO, pay by amount / zone list";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        RaoConfigDto raoCfg = (RaoConfigDto)this.raoConfigService.fetchConfig(area);
        if (!raoCfg.enabled()) {
            return Map.of("ERC", 1);
        }
        Integer zoneId = ctx.findPdmEntity().getZone().getId();
        Optional<Pair> zoneFilter = raoCfg.zones().stream().filter(z -> Objects.equals(z.rtbId(), zoneId)).findAny().map(z -> Pair.of((Object)raoCfg.zoneIdProperty(), (Object)z.raoId()));
        Optional townFilter = RaoUtils.createCompletePair((String)raoCfg.townProperty(), (String)raoCfg.townValue());
        try {
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.raoProps.getUrl()).pathSegment(new String[]{"api", "rao", "pay-by-amount", "zones"});
            zoneFilter.ifPresent(f -> {
                uriBuilder.queryParam("zoneKey", new Object[]{((String)f.getKey()).toUpperCase()});
                uriBuilder.queryParam("zone", new Object[]{f.getValue()});
            });
            townFilter.ifPresent(f -> {
                uriBuilder.queryParam("townKey", new Object[]{((String)f.getKey()).toUpperCase()});
                uriBuilder.queryParam("town", new Object[]{f.getValue()});
            });
            URI uri = uriBuilder.encode().build().toUri();
            ResponseEntity articleResponseEntity = this.restClient.get().uri(uri).retrieve().toEntity(RaoPbaParkingZonesResponseRaoDao.class);
            RaoPbaParkingZonesResponsePdmDao articleResponsePdm = RaoPbaParkingZonesResponsePdmDao.fromRao((RaoPbaParkingZonesResponseRaoDao)((RaoPbaParkingZonesResponseRaoDao)articleResponseEntity.getBody()));
            return Map.of("httpStatus", HttpStatus.OK.value(), "body", articleResponsePdm);
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (ResourceAccessException e) {
            return Map.of("ERC", 3, "ERM", "Cannot access Applejack API.");
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

