/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.rao;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.rao.RaoConfigDto;
import de.rtb.pcon.features.partners.rao.RaoConfigService;
import de.rtb.pcon.features.partners.rao.RaoProperties;
import de.rtb.pcon.features.partners.rao.model.RaoArticleIndexCompanyPdm;
import de.rtb.pcon.features.partners.rao.model.RaoArticlesMultipleCompaniesResponse;
import de.rtb.pcon.model.Area;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class RaoRtrArticleListOld
implements RealTimeRequest {
    private final RestClient restClient;
    private final RaoConfigService raoConfigService;
    private final RaoProperties raoProps;

    RaoRtrArticleListOld(@Qualifier(value="wc3rdPartyApi") RestClient restClient, RaoConfigService raoConfigService, RaoProperties raoProps) {
        this.restClient = restClient;
        this.raoConfigService = raoConfigService;
        this.raoProps = raoProps;
    }

    public int getId() {
        return 54;
    }

    public String getDescription() {
        return "RAO, article list (OLD)";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        RaoConfigDto config = (RaoConfigDto)this.raoConfigService.fetchConfig(area);
        RaoArticleIndexCompanyPdm pdmFilterReq = (RaoArticleIndexCompanyPdm)ctx.getLocalObject("filter", RaoArticleIndexCompanyPdm.class);
        if (StringUtils.isBlank((CharSequence)pdmFilterReq.companyId())) {
            throw new IllegalStateException("CompanyId must be provided.");
        }
        if (CollectionUtils.isEmpty((Collection)pdmFilterReq.articleIds())) {
            throw new IllegalStateException("At least one articleId must be provided.");
        }
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        try {
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.raoProps.getUrl()).pathSegment(new String[]{"api", "rao", "articles"});
            URI uri = uriBuilder.build().toUri();
            RaoArticlesMultipleCompaniesResponse articleResponse = (RaoArticlesMultipleCompaniesResponse)this.restClient.get().uri(uri).retrieve().body(RaoArticlesMultipleCompaniesResponse.class);
            if (articleResponse.companies() != null) {
                List articles = articleResponse.companies().stream().filter(c -> Objects.equals(pdmFilterReq.companyId(), c.id())).findAny().map(c -> c.articles().stream().filter(a -> pdmFilterReq.articleIds().contains(a.id())).toList()).orElse(List.of());
                HashMap<String, Object> body = new HashMap<String, Object>();
                body.put("articles", articles);
                if (articleResponse.status() != null) {
                    body.put("status", articleResponse.status());
                }
                if (articleResponse.error() != null) {
                    body.put("error", articleResponse.error());
                }
                return Map.of("httpStatus", 200, "body", body);
            }
            return Map.of("httpStatus", 200);
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (ResourceAccessException e) {
            return Map.of("ERC", 3, "ERM", "Cannot access Applejack API.");
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

