/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.rao;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.rao.RaoConfigDto;
import de.rtb.pcon.features.partners.rao.RaoConfigService;
import de.rtb.pcon.features.partners.rao.RaoProperties;
import de.rtb.pcon.features.partners.rao.model.RaoArticle;
import de.rtb.pcon.features.partners.rao.model.RaoArticleIndexCompanyPdm;
import de.rtb.pcon.features.partners.rao.model.RaoArticleIndexResponsePdm;
import de.rtb.pcon.features.partners.rao.model.RaoArticlesSingleCompanyResponse;
import de.rtb.pcon.features.partners.rao.model.RaoCompany;
import de.rtb.pcon.model.Area;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class RaoRtrArticleForAuthorizationIndex
implements RealTimeRequest {
    private final RestClient restClient;
    private final RaoConfigService raoConfigService;
    private final RaoProperties raoProps;

    RaoRtrArticleForAuthorizationIndex(@Qualifier(value="wc3rdPartyApi") RestClient restClient, RaoConfigService raoConfigService, RaoProperties raoProps) {
        this.restClient = restClient;
        this.raoConfigService = raoConfigService;
        this.raoProps = raoProps;
    }

    public int getId() {
        return 60;
    }

    public String getDescription() {
        return "RAO, article for authorization index";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        RaoConfigDto config = (RaoConfigDto)this.raoConfigService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        try {
            String companyId = ctx.getLocalString("companyId");
            String transactionId = ctx.getLocalString("transactionId");
            String type = ctx.getLocalString("type");
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)this.raoProps.getUrl()).pathSegment(new String[]{"api", "rao", "articles", "for-authorization"}).queryParam("companyId", new Object[]{companyId}).queryParam("transactionId", new Object[]{transactionId}).queryParam("type", new Object[]{type});
            URI uri = uriBuilder.encode().build().toUri();
            RaoArticlesSingleCompanyResponse articleResponse = (RaoArticlesSingleCompanyResponse)this.restClient.get().uri(uri).retrieve().body(RaoArticlesSingleCompanyResponse.class);
            RaoCompany comp = articleResponse.company();
            LinkedList<RaoArticleIndexCompanyPdm> companiesWitArticleIds = new LinkedList<RaoArticleIndexCompanyPdm>();
            List<String> articleIds = comp.articles().stream().map(RaoArticle::id).toList();
            companiesWitArticleIds.add(new RaoArticleIndexCompanyPdm(comp.id(), comp.name(), articleIds));
            return Map.of("httpStatus", 200, "body", new RaoArticleIndexResponsePdm(articleResponse.status(), articleResponse.error(), companiesWitArticleIds));
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (ResourceAccessException e) {
            return Map.of("ERC", 3, "ERM", "Cannot access Applejack API.");
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

