/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.rao;

import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.features.partners.PartnerUtils;
import de.rtb.pcon.features.partners.rao.RaoConfigDto;
import de.rtb.pcon.features.partners.rao.RaoConfigService;
import de.rtb.pcon.features.partners.rao.RaoConfigZone;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.AreaPartnerType;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClient;

@RestController
@RequestMapping(value={"/api/pcon/ui/areas/{id}/partners/rao/"})
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
class RaoController {
    @Autowired
    private RaoConfigService cfgService;
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    @Qualifier(value="wc3rdPartyApi")
    private RestClient restClient;

    RaoController() {
    }

    @GetMapping(value={"config"})
    @Transactional(readOnly=true)
    public RaoConfigDto getConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        RaoConfigDto cfg = (RaoConfigDto)this.cfgService.fetchConfig(area);
        List uiZones = PartnerUtils.adjustZones((List)area.getZones(), (List)cfg.zones(), rtbId -> new RaoConfigZone(Integer.valueOf(rtbId), ""));
        return new RaoConfigDto(cfg.enabled(), StringUtils.trimToNull((String)cfg.townProperty()), StringUtils.trimToNull((String)cfg.townValue()), StringUtils.trimToNull((String)cfg.zoneIdProperty()), cfg.reseller(), uiZones);
    }

    @PostMapping(value={"config"})
    @Transactional
    public void setConfig(@PathVariable int id, @RequestBody RaoConfigDto config) {
        Area area = this.entityLoader.loadArea(id);
        List<RaoConfigZone> zones = PartnerUtils.adjustZones((List)area.getZones(), (List)config.zones(), rtbId -> new RaoConfigZone(Integer.valueOf(rtbId), "")).stream().filter(z -> StringUtils.isNotEmpty((CharSequence)z.raoId())).toList();
        RaoConfigDto newConfig = new RaoConfigDto(config.enabled(), config.townProperty(), config.townValue(), config.zoneIdProperty(), config.reseller(), zones);
        this.cfgService.updateConfig(area, (PartnerConfiguration)newConfig);
    }

    @DeleteMapping(value={"config"})
    @Transactional
    public void deleteConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        this.cfgService.deleteConfig(area, AreaPartnerType.RAO);
    }
}

