/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.pagopa;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.pagopa.PagoPaConfigDto;
import de.rtb.pcon.features.partners.pagopa.PagoPaConfigService;
import de.rtb.pcon.features.partners.pagopa.PagoPaRaInitRequestPdmDto;
import de.rtb.pcon.features.partners.pagopa.PagoPaWsGateway;
import de.rtb.pcon.features.partners.pagopa.PagoPaWsGatewayFagory;
import de.rtb.pcon.model.Area;
import it.pagaonlinepa.preprod.RaInitInput;
import it.pagaonlinepa.preprod.RaInitOutput;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class PagoPaRaInitRtr
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(PagoPaRaInitRtr.class);
    private final PagoPaWsGatewayFagory pagoPaGwFactory;
    private final PagoPaConfigService configService;

    public PagoPaRaInitRtr(PagoPaWsGatewayFagory pagoPaGwFactory, PagoPaConfigService configService) {
        this.pagoPaGwFactory = pagoPaGwFactory;
        this.configService = configService;
    }

    public int getId() {
        return 66;
    }

    public String getDescription() {
        return "PagoPA RA_Init";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        PagoPaRaInitRequestPdmDto pdmReq = (PagoPaRaInitRequestPdmDto)ctx.getLocalObject("pago", PagoPaRaInitRequestPdmDto.class);
        Area area = ctx.global().getPdm().getZone().getArea();
        log.info("{}: {}.", (Object)this.getDescription(), (Object)pdmReq);
        PagoPaConfigDto config = (PagoPaConfigDto)this.configService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1, "ERM", "PagoPa partner is disabled.");
        }
        PagoPaWsGateway pagPaClient = this.pagoPaGwFactory.createPagoPaGateway(config.apiUrl(), config.apiUser(), config.apiPassword());
        RaInitInput raInitInput = pagPaClient.createRaInitInput();
        raInitInput.setDebitAmount(pdmReq.debitAmount());
        raInitInput.setNavCode(pdmReq.navCode());
        raInitInput.setPagopaDomainID(pdmReq.pagopaDomainID());
        raInitInput.setPayerEMail(config.payerEmail());
        raInitInput.setPayerFirstName(config.payerFirstName());
        raInitInput.setPayerLastName(config.payerLastName());
        raInitInput.setPaymentMode(3);
        String totemId = String.format("%d%05d", config.totemPrefix(), ctx.global().getPdm());
        raInitInput.setTotemID(totemId);
        RaInitOutput pagoPaResponse = pagPaClient.raInit(raInitInput);
        return Map.of("pago", pagoPaResponse);
    }
}

