/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.pagopa;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.pagopa.PagoPaConfigDto;
import de.rtb.pcon.features.partners.pagopa.PagoPaConfigService;
import de.rtb.pcon.features.partners.pagopa.PagoPaRaConfirmRequestPdmDto;
import de.rtb.pcon.features.partners.pagopa.PagoPaWsGateway;
import de.rtb.pcon.model.Area;
import it.pagaonlinepa.preprod.RaConfirmInput;
import it.pagaonlinepa.preprod.RaConfirmOutput;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class PagoPaRaConfirmRtr
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(PagoPaRaConfirmRtr.class);
    private final PagoPaWsGateway pagoPaClient;
    private final PagoPaConfigService configService;

    public PagoPaRaConfirmRtr(PagoPaWsGateway pagoPaClient, PagoPaConfigService configService) {
        this.pagoPaClient = pagoPaClient;
        this.configService = configService;
    }

    public int getId() {
        return 67;
    }

    public String getDescription() {
        return "PagoPA RA_Confirm";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        PagoPaRaConfirmRequestPdmDto pdmReq = (PagoPaRaConfirmRequestPdmDto)ctx.getLocalObject("pago", PagoPaRaConfirmRequestPdmDto.class);
        Area area = ctx.global().getPdm().getZone().getArea();
        log.info("{}: {}.", (Object)this.getDescription(), (Object)pdmReq);
        PagoPaConfigDto config = (PagoPaConfigDto)this.configService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1, "ERM", "PagoPa partner is disabled.");
        }
        RaConfirmInput raConfirmInput = this.pagoPaClient.createRaConfirmInput();
        raConfirmInput.setPaymentID(pdmReq.paymentID());
        raConfirmInput.setReceiptFormat(pdmReq.receiptFormat());
        raConfirmInput.setTotemID("1110027");
        RaConfirmOutput pagoPaResponse = this.pagoPaClient.raConfirm(raConfirmInput);
        return Map.of("pago", pagoPaResponse);
    }
}

