/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.feratel;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.core.real_time_request.RealTimeRequestParameterException;
import de.rtb.pcon.features.partners.feratel.FeratelCheckResponse;
import de.rtb.pcon.features.partners.feratel.FeratelConfigDto;
import de.rtb.pcon.features.partners.feratel.FeratelConfigService;
import de.rtb.pcon.features.partners.feratel.FeratelTokenInfo;
import de.rtb.pcon.features.partners.feratel.FeratelTokenResponse;
import de.rtb.pcon.model.Area;
import java.math.BigInteger;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class FeratelRtr
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(FeratelRtr.class);
    private static final String AUTH_URL = "https://idp.feratel.com/auth/realms/card-api/protocol/openid-connect/token";
    private static final String API_URL = "https://card-check-api.feratel.com";
    private RestClient restClient;
    private FeratelConfigService configService;
    private Map<Integer, FeratelTokenInfo> accessTokens = new HashMap();

    public FeratelRtr(FeratelConfigService configService, @Qualifier(value="wc3rdPartyApi") RestClient restClient) {
        this.configService = configService;
        this.restClient = restClient;
    }

    public int getId() {
        return 24;
    }

    public String getDescription() {
        return "Feratel, card check";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        String cardId = ctx.getLocalString("KNN");
        log.info("Feratel card check {}.", (Object)cardId);
        FeratelConfigDto config = (FeratelConfigDto)this.configService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1, "ERM", "Feratel service is disabled.");
        }
        String token = this.getAccessToken(area.getId(), config);
        URI cardCheckUri = UriComponentsBuilder.fromUriString((String)API_URL).pathSegment(new String[]{"v1", config.tenantId(), "secure", "checkpoints", config.checkPointId(), "check"}).queryParam("identifier", new Object[]{cardId}).build().toUri();
        try {
            FeratelCheckResponse checkRespone = (FeratelCheckResponse)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(cardCheckUri)).header("Authorization", new String[]{"Bearer " + token})).retrieve().body(FeratelCheckResponse.class);
            Optional<FeratelCheckResponse> oResponse = Optional.ofNullable(checkRespone);
            String cardValid = oResponse.map(r -> r.cardValid()).map(v -> Boolean.TRUE.equals(v) ? "1" : "0").orElse("0");
            Optional<BigInteger> cardNumber = oResponse.flatMap(r -> Optional.ofNullable(r.identification())).map(i -> i.cardNumer());
            return Map.of("ERC", 0, "cardValid", cardValid, "cardNr", cardNumber);
        }
        catch (HttpClientErrorException e) {
            log.debug("Feratel rejected the card. Status code {}, body {}", (Object)e.getStatusCode(), (Object)e.getResponseBodyAsString());
            return Map.of("ERC", 8, "ERM", e.getStatusCode().value() + " - " + e.getStatusText());
        }
        catch (RestClientException e) {
            log.debug("Feratel API error: {}", (Object)e.getMessage());
            return Map.of("ERC", 8, "ERM", "API error.");
        }
    }

    protected synchronized String getAccessToken(Integer areaId, FeratelConfigDto config) {
        FeratelTokenInfo accessToken = this.accessTokens.computeIfAbsent(areaId, k -> FeratelTokenInfo.INVALID);
        if (accessToken.expiration().isAfter(LocalDateTime.now())) {
            return accessToken.value();
        }
        log.debug("Access token for area {} expired on {}.", (Object)areaId, (Object)accessToken.expiration());
        accessToken = this.requestAccessToken(config);
        this.accessTokens.put(areaId, accessToken);
        return accessToken.value();
    }

    private FeratelTokenInfo requestAccessToken(FeratelConfigDto config) {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.add((Object)"client_id", (Object)config.clientId());
        formData.add((Object)"client_secret", (Object)config.clientSecret());
        formData.add((Object)"username", (Object)config.username());
        formData.add((Object)"password", (Object)config.password());
        formData.add((Object)"grant_type", (Object)"password");
        URI authUri = UriComponentsBuilder.fromUriString((String)AUTH_URL).build().toUri();
        FeratelTokenResponse token = (FeratelTokenResponse)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(authUri)).header("Content-Type", new String[]{"application/x-www-form-urlencoded"})).body((Object)formData).retrieve().body(FeratelTokenResponse.class);
        if (token != null) {
            LocalDateTime expiration = LocalDateTime.now().plusSeconds((long)token.accessExpiresIn().intValue() - 30L);
            log.debug("Obtained new token. Duration {}s. It will expire on {}.", (Object)token.accessExpiresIn(), (Object)expiration);
            return new FeratelTokenInfo(expiration, token.accessToken());
        }
        throw new RealTimeRequestParameterException("Authorization failed, the answer was null.");
    }
}

