/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.brain_behind;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.brain_behind.BrainBehindUtilService;
import de.rtb.pcon.features.partners.brain_behind.BrbConfigurationService;
import de.rtb.pcon.features.partners.brain_behind.BrbQrCodeRequestDto;
import de.rtb.pcon.features.partners.brain_behind.BrbQrCodeResponseDto;
import de.rtb.pcon.features.partners.brain_behind.BrbQrCodeResponsePdmDto;
import de.rtb.pcon.features.partners.brain_behind.BrbQrCodeResponseWDto;
import de.rtb.pcon.features.partners.brain_behind.BrbRequestConfigDto;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
class BrbQrCodeRtr
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(BrbQrCodeRtr.class);
    private final RestTemplate restTemplate;
    private final BrainBehindUtilService bbUtilsService;
    private final BrbConfigurationService configService;

    public BrbQrCodeRtr(@Qualifier(value="rt3rdPartyApi") RestTemplate restTemplate, BrainBehindUtilService bbUtilsService, BrbConfigurationService config) {
        this.restTemplate = restTemplate;
        this.bbUtilsService = bbUtilsService;
        this.configService = config;
    }

    public int getId() {
        return 31;
    }

    public String getDescription() {
        return "Brain behind, QR code";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        String cardNumber = ctx.getLocalString("KNN");
        Pdm pdm = ctx.global().getPdm();
        Area area = ctx.global().getPdm().getZone().getArea();
        HashMap<String, Object> result = new HashMap<String, Object>();
        BrbRequestConfigDto config = (BrbRequestConfigDto)this.configService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("password", config.password3());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        try {
            URI uri = BrbConfigurationService.createServiceUri((String)config.urlPrefix(), (String)"CU_Service");
            BrbQrCodeRequestDto bbRequest = BrbQrCodeRequestDto.createRequest((String)cardNumber, (String)BrbConfigurationService.makeTerminalId((Pdm)pdm), (int)config.integratorId(), (int)config.serviceId());
            BrbQrCodeResponseWDto bbResponse = (BrbQrCodeResponseWDto)this.restTemplate.postForObject(uri, (Object)new HttpEntity((Object)bbRequest, (MultiValueMap)headers), BrbQrCodeResponseWDto.class);
            if (bbResponse != null && bbResponse.d() != null) {
                result.put("qrc", BrbQrCodeResponsePdmDto.from((BrbQrCodeResponseDto)bbResponse.d()));
            } else {
                log.error("Response is null");
                result.put("ERC", 3);
                result.put("ERM", "Response is null");
            }
        }
        catch (HttpServerErrorException.InternalServerError e) {
            log.error("Brain behind server error.", (Throwable)e);
            result.putAll(this.bbUtilsService.mapInternalServerError(e));
        }
        catch (RestClientException e) {
            log.error("Error occurred in communication with brain behind.", (Throwable)e);
            result.put("ERC", 3);
            result.put("ERM", e.getMostSpecificCause().getMessage());
        }
        return result;
    }
}

